/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.rendezvous;

import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.rendezvous.ResponseStrategy;
import rice.environment.Environment;
import rice.environment.time.TimeSource;
import rice.p2p.util.TimerWeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutResponseStrategy<Identifier>
implements ResponseStrategy<Identifier> {
    Map<Identifier, Long> lastTimeReceived;
    int timeout;
    TimeSource time;

    public TimeoutResponseStrategy(int timeout, Environment env) {
        this.timeout = timeout;
        this.lastTimeReceived = new TimerWeakHashMap<Identifier, Long>(env.getSelectorManager(), 60000 + timeout);
        this.time = env.getTimeSource();
    }

    @Override
    public void messageReceived(Identifier i, ByteBuffer msg, Map<String, Object> options) {
        this.lastTimeReceived.put(i, this.time.currentTimeMillis());
    }

    @Override
    public void messageSent(Identifier i, ByteBuffer msg, Map<String, Object> options) {
    }

    @Override
    public boolean sendDirect(Identifier i, ByteBuffer msg, Map<String, Object> options) {
        long lastTime = 0L;
        if (this.lastTimeReceived.containsKey(i)) {
            lastTime = this.lastTimeReceived.get(i);
        }
        return this.time.currentTimeMillis() <= lastTime + (long)this.timeout;
    }
}

