/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.replay.playback;

import org.mpisws.p2p.transport.peerreview.replay.Verifier;
import rice.environment.Environment;
import rice.environment.logging.LogManager;
import rice.environment.time.simulated.DirectTimeSource;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

public class ReplaySM
extends SelectorManager {
    Verifier verifier;
    DirectTimeSource simTime;

    public ReplaySM(String instance, DirectTimeSource timeSource, LogManager log) {
        super(instance, timeSource, log, null);
        this.simTime = timeSource;
        this.setSelect(false);
    }

    public void setVerifier(Verifier v) {
        this.verifier = v;
    }

    public void setEnvironment(Environment env) {
        if (env == null) {
            throw new IllegalArgumentException("env is null!");
        }
        if (this.environment != null) {
            return;
        }
        this.environment = env;
    }

    protected synchronized void addTask(TimerTask task) {
        long now = this.timeSource.currentTimeMillis();
        if (task.scheduledExecutionTime() < now && this.timeSource instanceof DirectTimeSource) {
            if (this.logger.level <= 900) {
                this.logger.logException("Can't schedule a task in the past. " + task + " now:" + now + " task.execTime:" + task.scheduledExecutionTime(), new Exception("Stack Trace"));
            }
            throw new RuntimeException("Can't schedule a task in the past.");
        }
        super.addTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean makeProgress() {
        if (this.logger.level <= 400) {
            this.logger.log("executeDueTasks()");
        }
        if (this.isSuccess()) {
            return false;
        }
        boolean timerProgress = true;
        long now = this.verifier.getNextEventTime();
        while (timerProgress) {
            now = this.verifier.getNextEventTime();
            if (now == -1L) {
                return false;
            }
            TimerTask next = null;
            ReplaySM replaySM = this;
            synchronized (replaySM) {
                if (this.timerQueue.size() > 0) {
                    next = (TimerTask)this.timerQueue.peek();
                    if (next.scheduledExecutionTime() <= now) {
                        this.timerQueue.poll();
                        this.simTime.setTime(next.scheduledExecutionTime());
                    } else {
                        timerProgress = false;
                    }
                } else {
                    timerProgress = false;
                }
            }
            if (!timerProgress) continue;
            super.doInvocations();
            if (this.logger.level <= 500) {
                this.logger.log("executing task " + next);
            }
            if (!next.execute(this.simTime)) continue;
            replaySM = this;
            synchronized (replaySM) {
                this.timerQueue.add(next);
            }
        }
        this.simTime.setTime(now);
        super.doInvocations();
        return this.verifier.makeProgress();
    }

    protected boolean isSuccess() {
        boolean ret = this.verifier.isSuccess();
        if (ret) {
            this.environment.destroy();
        }
        return ret;
    }

    protected void doInvocations() {
    }
}

