/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.replay.playback;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.replay.playback.ReplaySM;
import org.mpisws.p2p.transport.peerreview.replay.playback.ReplaySocket;
import org.mpisws.p2p.transport.peerreview.replay.playback.ReplayVerifier;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.Serializer;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.environment.logging.LogManager;
import rice.environment.params.simple.SimpleParameters;
import rice.environment.processing.sim.SimProcessor;
import rice.environment.random.simple.SimpleRandomSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.p2p.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayLayer<Identifier>
extends ReplayVerifier<Identifier> {
    TransportLayerCallback<Identifier, ByteBuffer> callback;
    Map<Integer, ReplaySocket<Identifier>> sockets = new HashMap<Integer, ReplaySocket<Identifier>>();
    Environment environment;

    public ReplayLayer(Serializer<Identifier> serializer, HashProvider hashProv, SecureHistory history, Identifier localHandle, Environment environment) throws IOException {
        super(serializer, hashProv, history, localHandle, (short)0, (short)0, 0, environment.getLogManager().getLogger(ReplayLayer.class, localHandle.toString()));
        this.environment = environment;
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(final Identifier i, SocketCallback<Identifier> deliverSocketToMe, final Map<String, Object> options) {
        try {
            int socketId = this.openSocket(i);
            ReplaySocket<Identifier> socket = new ReplaySocket<Identifier>(i, socketId, this, options);
            socket.setDeliverSocketToMe(deliverSocketToMe);
            this.sockets.put(socketId, socket);
            return socket;
        }
        catch (IOException ioe) {
            SocketRequestHandle ret = new SocketRequestHandle<Identifier>(){

                @Override
                public Identifier getIdentifier() {
                    return i;
                }

                @Override
                public Map<String, Object> getOptions() {
                    return options;
                }

                @Override
                public boolean cancel() {
                    return true;
                }
            };
            deliverSocketToMe.receiveException(ret, ioe);
            return ret;
        }
    }

    @Override
    public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(Identifier i, ByteBuffer m, MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        if (this.logger.level <= 300) {
            this.logger.logException("sendMessage(" + i + "," + m + "):" + MathUtils.toHex(m.array()), new Exception("Stack Trace"));
        } else if (this.logger.level <= 400) {
            this.logger.log("sendMessage(" + i + "," + m + "):" + MathUtils.toHex(m.array()));
        } else if (this.logger.level <= 500) {
            this.logger.log("sendMessage(" + i + "," + m + ")");
        }
        MessageRequestHandleImpl<Identifier, ByteBuffer> ret = new MessageRequestHandleImpl<Identifier, ByteBuffer>(i, m, options);
        try {
            this.send(i, m, -1);
            if (deliverAckToMe != null) {
                deliverAckToMe.ack(ret);
            }
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.logException("", ioe);
            }
            throw new RuntimeException(ioe);
        }
        return ret;
    }

    @Override
    public Identifier getLocalIdentifier() {
        return (Identifier)this.localHandle;
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void acceptMessages(boolean b) {
    }

    @Override
    public void acceptSockets(boolean b) {
    }

    @Override
    protected void receive(Identifier from, ByteBuffer msg) throws IOException {
        if (this.logger.level <= 400) {
            this.logger.log("receive(" + from + "," + msg + ")");
        }
        this.callback.messageReceived(from, msg, null);
    }

    @Override
    protected void socketIO(int socketId, boolean canRead, boolean canWrite) throws IOException {
        this.sockets.get(socketId).notifyIO(canRead, canWrite);
    }

    @Override
    protected void incomingSocket(Identifier from, int socketId) throws IOException {
        ReplaySocket<Identifier> socket = new ReplaySocket<Identifier>(from, socketId, this, null);
        this.sockets.put(socketId, socket);
        this.callback.incomingSocket(socket);
    }

    public static Environment generateEnvironment(String name, long startTime, long randSeed, LogManager lm2) {
        LogManager lm;
        SimpleParameters params = new SimpleParameters(Environment.defaultParamFileArray, null);
        DirectTimeSource dts = new DirectTimeSource(startTime);
        if (lm2 != null && lm2 instanceof CloneableLogManager) {
            CloneableLogManager clm = (CloneableLogManager)lm2;
            lm = clm.clone(clm.getPrefix() + "-" + name, dts);
        } else {
            lm = Environment.generateDefaultLogManager(dts, params);
        }
        SimpleRandomSource rs = new SimpleRandomSource(randSeed, lm);
        dts.setLogManager(lm);
        ReplaySM selector = new ReplaySM("Replay " + name, dts, lm);
        dts.setSelectorManager(selector);
        SimProcessor proc = new SimProcessor(selector);
        Environment env = new Environment(selector, proc, rs, dts, lm, params, Environment.generateDefaultExceptionStrategy(lm));
        return env;
    }

    @Override
    protected void socketOpened(int socketId) throws IOException {
        this.sockets.get(socketId).socketOpened();
    }

    @Override
    protected void socketException(int socketId, IOException ioe) throws IOException {
        this.sockets.get(socketId).receiveException(ioe);
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }
}

