/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.replay;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.PeerReviewCallback;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.peerreview.replay.EventCallback;
import org.mpisws.p2p.transport.peerreview.replay.ReplaySocket;
import org.mpisws.p2p.transport.peerreview.replay.Verifier;
import org.mpisws.p2p.transport.peerreview.replay.VerifierMRH;
import org.mpisws.p2p.transport.peerreview.replay.playback.ReplaySM;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierImpl<Handle extends RawSerializable, Identifier extends RawSerializable>
implements Verifier<Handle> {
    Map<Short, EventCallback> eventCallback = new HashMap<Short, EventCallback>();
    Map<Long, VerifierMRH<Handle>> callbacks = new HashMap<Long, VerifierMRH<Handle>>();
    protected Handle localHandle;
    protected SecureHistory history;
    PeerReviewCallback<Handle, Identifier> app;
    boolean foundFault;
    long nextEventIndex;
    IndexEntry next;
    InputBuffer nextEvent;
    boolean initialized;
    int[] eventToCallback = new int[256];
    protected Logger logger;
    protected IdentityTransport<Handle, Identifier> transport;
    RandomSource prng;
    PeerReview<Handle, Identifier> peerreview;
    Environment environment;
    Object extInfo;
    Map<Integer, ReplaySocket<Handle>> sockets = new HashMap<Integer, ReplaySocket<Handle>>();

    public VerifierImpl(PeerReview<Handle, Identifier> peerreview, Environment env, SecureHistory history, Handle localHandle, long firstEntryToReplay, Object extInfo) throws IOException {
        if (!(env.getSelectorManager() instanceof ReplaySM)) {
            throw new IllegalArgumentException("Environment.getSelectorManager() must be a ReplaySM, was a " + env.getSelectorManager().getClass());
        }
        this.environment = env;
        this.logger = this.environment.getLogManager().getLogger(VerifierImpl.class, localHandle.toString());
        this.history = history;
        this.app = null;
        this.transport = peerreview;
        this.peerreview = peerreview;
        this.localHandle = localHandle;
        this.foundFault = false;
        this.nextEventIndex = firstEntryToReplay - 1L;
        this.initialized = false;
        this.extInfo = extInfo;
        for (int i = 0; i < 256; ++i) {
            this.eventToCallback[i] = -1;
        }
        this.fetchNextEvent();
        if (this.next == null) {
            this.foundFault = true;
        }
    }

    public Object getExtInfo() {
        return this.extInfo;
    }

    protected void fetchNextEvent() {
        this.next = null;
        ++this.nextEventIndex;
        try {
            this.next = this.history.statEntry(this.nextEventIndex);
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.logException("Error fetching log entry #" + this.nextEventIndex, ioe);
            }
            this.foundFault = true;
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("fetchNextEvent():" + this.next);
        }
        if (this.next == null) {
            return;
        }
        if (this.next.isHashed()) {
            if (this.logger.level <= 500) {
                this.logger.log("Fetched log entry #" + this.nextEventIndex + " (type " + this.next.getType() + ", hashed, seq=" + this.next.getSeq() + ")");
            }
        } else {
            try {
                this.nextEvent = new SimpleInputBuffer(this.history.getEntry(this.nextEventIndex, this.next.getSizeInFile()));
            }
            catch (IOException ioe) {
                if (this.logger.level <= 900) {
                    this.logger.logException("Error fetching log entry #" + this.nextEventIndex + " (type " + this.next.getType() + ", size " + this.next.getSizeInFile() + " bytes, seq=" + this.next.getSeq() + ")", ioe);
                }
                this.foundFault = true;
                return;
            }
            if (this.logger.level <= 500) {
                this.logger.log("Fetched log entry #" + this.nextEventIndex + " (type " + this.next.getType() + ", size " + this.next.getSizeInFile() + " bytes, seq=" + this.next.getSeq() + ")");
            }
        }
    }

    @Override
    public boolean verifiedOK() {
        return !this.foundFault;
    }

    public IndexEntry getNextEvent() {
        return this.next;
    }

    @Override
    public void setApplication(PeerReviewCallback app) {
        this.app = app;
    }

    public void registerEvent(EventCallback callback, short ... eventType) {
        for (short s : eventType) {
            this.registerEvent(callback, s);
        }
    }

    public void registerEvent(EventCallback callback, short eventType) {
        if (this.eventCallback.containsKey(eventType) && callback != this.eventCallback.get(eventType)) {
            throw new IllegalStateException("Event #" + eventType + " registered twice");
        }
        this.eventCallback.put(eventType, callback);
    }

    @Override
    public boolean makeProgress() {
        if (this.logger.level <= 500) {
            this.logger.log("makeProgress()");
        }
        if (this.foundFault || this.next == null) {
            return false;
        }
        if (!this.initialized && this.next.getType() != 4 && this.next.getType() != 5) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: No INIT or CHECKPOINT found at the beginning of the log; marking as invalid " + this.next);
            }
            this.foundFault = true;
            return false;
        }
        if (this.next == null) {
            return false;
        }
        if (this.logger.level <= 400) {
            this.logger.log("Replaying event #" + this.nextEventIndex + " (type " + this.next.getType() + ", seq=" + this.next.getSeq() + ")");
        }
        if (this.next.isHashed() && this.next.getType() != 4 && this.next.getType() != 5) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: Trying to replay hashed event " + this.next.getType());
            }
            this.foundFault = true;
            return false;
        }
        try {
            switch (this.next.getType()) {
                case 7: {
                    this.fetchNextEvent();
                    break;
                }
                case 0: {
                    if (this.logger.level <= 900) {
                        this.logger.logException("Replay: Encountered EVT_SEND evt #" + this.nextEventIndex + "; marking as invalid", new Exception("Stack Trace"));
                    }
                    this.foundFault = true;
                    return false;
                }
                case 40: {
                    if (this.logger.level <= 900) {
                        this.logger.logException("Replay: Encountered EVT_SOCKET_READ evt #" + this.nextEventIndex + "; marking as invalid", new Exception("Stack Trace"));
                    }
                    this.foundFault = true;
                    return false;
                }
                case 34: {
                    if (this.logger.level <= 900) {
                        this.logger.logException("Replay: Encountered EVT_SOCKET_CLOSE evt #" + this.nextEventIndex + "; marking as invalid", new Exception("Stack Trace"));
                    }
                    this.foundFault = true;
                    return false;
                }
                case 35: {
                    if (this.logger.level <= 900) {
                        this.logger.logException("Replay: Encountered EVT_SOCKET_SHUTDOWN_OUTPUT evt #" + this.nextEventIndex + "; marking as invalid", new Exception("Stack Trace"));
                    }
                    this.foundFault = true;
                    return false;
                }
                case 1: {
                    RawSerializable sender = (RawSerializable)this.peerreview.getHandleSerializer().deserialize(this.nextEvent);
                    long senderSeq = this.nextEvent.readLong();
                    boolean hashed = this.nextEvent.readBoolean();
                    int msgLen = this.nextEvent.bytesRemaining();
                    int relevantLen = hashed ? msgLen - this.transport.getHashSizeBytes() : msgLen;
                    byte[] msgBytes = new byte[msgLen];
                    this.nextEvent.read(msgBytes);
                    ByteBuffer msgBuf = ByteBuffer.wrap(msgBytes);
                    this.fetchNextEvent();
                    if (this.next == null || this.next.getType() != 2 || this.next.getSizeInFile() != this.transport.getHashSizeBytes() + this.transport.getSignatureSizeBytes()) {
                        if (this.logger.level <= 900) {
                            this.logger.log("Replay: RECV event not followed by SIGN; marking as invalid");
                        }
                        this.foundFault = true;
                        return false;
                    }
                    this.fetchNextEvent();
                    this.app.messageReceived(sender, msgBuf, null);
                    break;
                }
                case 2: {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: Spurious SIGN event; marking as invalid");
                    }
                    this.foundFault = true;
                    return false;
                }
                case 3: {
                    RawSerializable id = (RawSerializable)this.peerreview.getIdSerializer().deserialize(this.nextEvent);
                    long ackedSeq = this.nextEvent.readLong();
                    VerifierMRH<Handle> foo = this.callbacks.remove(ackedSeq);
                    if (foo == null) {
                        if (this.logger.level <= 900) {
                            this.logger.log("Replay: no message to be acked for seq:" + ackedSeq + " fail.");
                        }
                        this.foundFault = true;
                        return false;
                    }
                    foo.ack();
                    this.fetchNextEvent();
                    break;
                }
                case 6: {
                    this.fetchNextEvent();
                    break;
                }
                case 4: {
                    if (!this.initialized) {
                        if (!this.next.isHashed()) {
                            this.initialized = true;
                            if (!this.app.loadCheckpoint(this.nextEvent)) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("Cannot load checkpoint");
                                }
                                this.foundFault = true;
                            }
                        } else {
                            if (this.logger.level <= 900) {
                                this.logger.log("Replay: Initial checkpoint is hashed; marking as invalid");
                            }
                            this.foundFault = true;
                        }
                    } else {
                        SimpleOutputBuffer buf = new SimpleOutputBuffer();
                        this.app.storeCheckpoint(buf);
                        int actualCheckpointSize = buf.getWritten();
                        if (!this.next.isHashed()) {
                            if (actualCheckpointSize != this.next.getSizeInFile()) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("Replay: Checkpoint has different size (expected " + this.next.getSizeInFile() + " bytes, but got " + actualCheckpointSize + "); marking as invalid");
                                }
                                if (this.logger.level <= 500) {
                                    this.logger.log("Expected:" + this.nextEvent);
                                }
                                if (this.logger.level <= 500) {
                                    this.logger.log("Found:" + actualCheckpointSize);
                                }
                                this.foundFault = true;
                                return false;
                            }
                            byte[] bar = new byte[actualCheckpointSize];
                            this.nextEvent.read(bar);
                            if (!Arrays.equals(bar, buf.getBytes())) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("Replay: Checkpoint does not match");
                                }
                                if (this.logger.level <= 500) {
                                    this.logger.log("Expected:" + this.next.getSizeInFile());
                                }
                                if (this.logger.level <= 500) {
                                    this.logger.log("Found:" + buf.getWritten());
                                }
                                this.foundFault = true;
                                return false;
                            }
                        } else {
                            byte[] checkpointHash = this.transport.hash(buf.getByteBuffer());
                            if (!Arrays.equals(checkpointHash, this.next.getContentHash())) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("Replay: Checkpoint is hashed, but does not match hash value in the log\n" + Arrays.toString(checkpointHash) + "\n" + Arrays.toString(this.next.getContentHash()));
                                }
                                this.foundFault = true;
                                return false;
                            }
                            if (this.logger.level <= 300) {
                                this.logger.log("Hashed checkpoint is OK");
                            }
                            this.history.upgradeHashedEntry((int)this.nextEventIndex, buf.getByteBuffer());
                        }
                    }
                    this.fetchNextEvent();
                    break;
                }
                case 5: {
                    this.initialized = true;
                    this.app.init();
                    this.fetchNextEvent();
                    break;
                }
                case 30: {
                    int socketId = this.nextEvent.readInt();
                    RawSerializable opener = (RawSerializable)this.peerreview.getHandleSerializer().deserialize(this.nextEvent);
                    this.fetchNextEvent();
                    this.incomingSocket(opener, socketId);
                    break;
                }
                case 32: {
                    int socketId = this.nextEvent.readInt();
                    this.fetchNextEvent();
                    this.socketOpened(socketId);
                    break;
                }
                case 37: {
                    int socketId = this.nextEvent.readInt();
                    this.fetchNextEvent();
                    this.socketIO(socketId, true, false);
                    break;
                }
                case 38: {
                    int socketId = this.nextEvent.readInt();
                    this.fetchNextEvent();
                    this.socketIO(socketId, false, true);
                    break;
                }
                case 39: {
                    int socketId = this.nextEvent.readInt();
                    this.fetchNextEvent();
                    this.socketIO(socketId, true, true);
                    break;
                }
                case 33: {
                    int socketId = this.nextEvent.readInt();
                    IOException ex = this.deserializeException(this.nextEvent);
                    this.logger.log("deserializeException(" + ex + ")");
                    this.fetchNextEvent();
                    this.socketException(socketId, ex);
                    break;
                }
                default: {
                    if (!this.eventCallback.containsKey(this.next.getType())) {
                        if (this.logger.level <= 900) {
                            this.logger.log("Replay(" + this.nextEventIndex + "): Unregistered event #" + this.next.getType() + "; marking as invalid");
                        }
                        this.foundFault = true;
                        return false;
                    }
                    IndexEntry temp = this.next;
                    InputBuffer tempEvent = this.nextEvent;
                    this.fetchNextEvent();
                    this.eventCallback.get(temp.getType()).replayEvent(temp.getType(), tempEvent);
                    break;
                }
            }
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.logException("Exception handling event #" + this.nextEventIndex + " " + this.next, ioe);
            }
            this.foundFault = true;
            return false;
        }
        return true;
    }

    @Override
    public MessageRequestHandle<Handle, ByteBuffer> sendMessage(Handle target, ByteBuffer message, MessageCallback<Handle, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        try {
            int msgLen = message.remaining();
            int pos = message.position();
            int lim = message.limit();
            int relevantLen = message.remaining();
            if (options != null && options.containsKey("PeerReview_Relevant_length")) {
                relevantLen = (Integer)options.get("PeerReview_Relevant_length");
            }
            if (this.logger.level <= 500) {
                this.logger.log("Verifier::send(" + target + ", " + relevantLen + "/" + message.remaining() + " bytes)");
            }
            if (this.next == null) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: Send event after end of segment; marking as invalid");
                }
                this.foundFault = true;
                return null;
            }
            if (this.next.getType() == 5) {
                if (this.logger.level <= 400) {
                    this.logger.log("Skipped; next event is an INIT");
                }
                return null;
            }
            if (this.next.getType() != 0) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay(" + this.nextEventIndex + "): SEND event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
                }
                this.foundFault = true;
                return null;
            }
            long sendSeq = this.next.getSeq();
            VerifierMRH<Handle> ret = new VerifierMRH<Handle>(target, message, deliverAckToMe, options);
            this.callbacks.put(sendSeq, ret);
            if (this.next.isHashed()) {
                byte[] cHash;
                SimpleOutputBuffer buf = new SimpleOutputBuffer();
                RawSerializable targetId = (RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(target);
                targetId.serialize(buf);
                buf.writeBoolean(relevantLen < msgLen);
                buf.write(message.array(), message.position(), relevantLen);
                if (relevantLen < msgLen) {
                    message.position(pos);
                    message.limit(lim);
                    byte[] hash = this.transport.hash(message);
                }
                if (!Arrays.equals(cHash = this.transport.hash(buf.getByteBuffer()), this.next.getContentHash())) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: SEND is hashed, but hash of predicted SEND entry does not match hash in the log");
                    }
                    this.foundFault = true;
                    return null;
                }
                this.fetchNextEvent();
                assert (this.next.getType() == 6);
                this.fetchNextEvent();
                return ret;
            }
            RawSerializable logReceiver = (RawSerializable)this.peerreview.getHandleSerializer().deserialize(this.nextEvent);
            if (!logReceiver.equals(target)) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay(" + this.nextEventIndex + "): SEND to " + target + " during replay, but log shows SEND to " + logReceiver + "; marking as invalid");
                }
                this.nextEvent = new SimpleInputBuffer(this.history.getEntry(this.next, this.next.getSizeInFile()));
                this.foundFault = true;
                return ret;
            }
            boolean logIsHashed = this.nextEvent.readBoolean();
            if (logIsHashed) {
                if (relevantLen >= msgLen) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: Message sent during replay is entirely relevant, but log entry is partly hashed; marking as invalid");
                    }
                    this.foundFault = true;
                    return null;
                }
                int logRelevantLen = this.nextEvent.bytesRemaining() - this.transport.getHashSizeBytes();
                assert (logRelevantLen >= 0);
                if (relevantLen != logRelevantLen) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: Message sent during replay has " + relevantLen + " relevant bytes, but log entry has " + logRelevantLen + "; marking as invalid");
                    }
                    this.foundFault = true;
                    return null;
                }
                byte[] loggedMsg = new byte[logRelevantLen];
                this.nextEvent.read(loggedMsg);
                ByteBuffer loggedMsgBB = ByteBuffer.wrap(loggedMsg);
                if (relevantLen > 0 && message.equals(loggedMsgBB)) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: Relevant part of partly hashed message differs");
                    }
                    if (this.logger.level <= 500) {
                        this.logger.log("Expected: [" + loggedMsgBB + "]");
                    }
                    if (this.logger.level <= 500) {
                        this.logger.log("Actual:   [" + message + "]");
                    }
                    this.foundFault = true;
                    return null;
                }
                byte[] logHash = new byte[this.transport.getHashSizeBytes()];
                this.nextEvent.read(logHash);
                byte[] msgHashBytes = message.array();
                byte[] msgHash = new byte[this.transport.getHashSizeBytes()];
                System.arraycopy(msgHashBytes, msgHashBytes.length - this.transport.getHashSizeBytes(), msgHash, 0, this.transport.getHashSizeBytes());
                assert (msgLen == relevantLen + this.transport.getHashSizeBytes());
                if (!msgHash.equals(logHash)) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: Hashed part of partly hashed message differs");
                    }
                    if (this.logger.level <= 500) {
                        this.logger.log("Expected: [" + logHash + "]");
                    }
                    if (this.logger.level <= 500) {
                        this.logger.log("Actual:   [" + msgHash + "]");
                    }
                    this.foundFault = true;
                    return null;
                }
            } else {
                if (relevantLen < msgLen) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: Message sent during replay is only partly relevant, but log entry is not hashed; marking as invalid");
                    }
                    this.foundFault = true;
                    return null;
                }
                int logMsglen = this.nextEvent.bytesRemaining();
                if (msgLen != logMsglen) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: Message sent during replay has " + msgLen + " bytes, but log entry has " + logMsglen + "; marking as invalid");
                    }
                    this.foundFault = true;
                    return null;
                }
                byte[] loggedMsg = new byte[this.nextEvent.bytesRemaining()];
                this.nextEvent.read(loggedMsg);
                byte[] sentMsg = new byte[message.remaining()];
                message.get(sentMsg);
                if (loggedMsg.length != sentMsg.length) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: Message sent during replay differs from message in the log by length log:" + loggedMsg.length + " sent:" + sentMsg.length);
                    }
                    this.foundFault = true;
                    return null;
                }
                if (msgLen > 0 && !Arrays.equals(loggedMsg, sentMsg)) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: Message sent during replay differs from message in the log");
                    }
                    this.foundFault = true;
                    return null;
                }
            }
            this.fetchNextEvent();
            assert (this.next.getType() == 6);
            this.fetchNextEvent();
            if (this.next == null) {
                this.logger.log("next event is null");
            }
            return ret;
        }
        catch (IOException ioe) {
            this.logger.logException("Error calculating hash", ioe);
            this.foundFault = true;
            return null;
        }
    }

    @Override
    public long getNextEventTime() {
        if (this.next == null) {
            return -1L;
        }
        return this.next.getSeq() / 1000000L;
    }

    @Override
    public boolean isSuccess() {
        return this.initialized && this.verifiedOK() && this.next == null;
    }

    protected IOException deserializeException(InputBuffer nextEvent) throws IOException {
        short exType = nextEvent.readShort();
        switch (exType) {
            case 1: {
                return new IOException(nextEvent.readUTF());
            }
            case 2: {
                return new ClosedChannelException(nextEvent.readUTF());
            }
            case 0: {
                Class<?> c;
                String className = nextEvent.readUTF();
                String message = nextEvent.readUTF();
                try {
                    c = Class.forName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Couldn't find class" + className + " " + message);
                }
                Class[] parameterTypes = new Class[]{String.class};
                try {
                    Constructor<?> ctor = c.getConstructor(parameterTypes);
                    IOException ioe = (IOException)ctor.newInstance(message);
                    return ioe;
                }
                catch (Exception e) {
                    try {
                        Constructor<?> ctor = c.getConstructor(new Class[0]);
                        IOException ioe = (IOException)ctor.newInstance(message);
                        return ioe;
                    }
                    catch (Exception e2) {
                        throw new RuntimeException("Couldn't find constructor for" + className + " " + message);
                    }
                }
            }
        }
        throw new RuntimeException("Unknown EX_TYPE:" + exType);
    }

    @Override
    public SocketRequestHandle<Handle> openSocket(Handle i, SocketCallback<Handle> deliverSocketToMe, Map<String, Object> options) {
        try {
            int socketId = this.openSocket(i);
            ReplaySocket<Handle> socket = new ReplaySocket<Handle>(i, socketId, this, options);
            socket.setDeliverSocketToMe(deliverSocketToMe);
            this.sockets.put(socketId, socket);
            return socket;
        }
        catch (IOException ioe) {
            SocketRequestHandle ret = new SocketRequestHandle<Handle>((RawSerializable)i, options){
                final /* synthetic */ RawSerializable val$i;
                final /* synthetic */ Map val$options;
                {
                    this.val$i = rawSerializable;
                    this.val$options = map;
                }

                @Override
                public Handle getIdentifier() {
                    return this.val$i;
                }

                @Override
                public Map<String, Object> getOptions() {
                    return this.val$options;
                }

                @Override
                public boolean cancel() {
                    return true;
                }
            };
            deliverSocketToMe.receiveException(ret, ioe);
            return ret;
        }
    }

    protected void socketIO(int socketId, boolean canRead, boolean canWrite) throws IOException {
        this.sockets.get(socketId).notifyIO(canRead, canWrite);
    }

    protected void incomingSocket(Handle from, int socketId) throws IOException {
        ReplaySocket<Handle> socket = new ReplaySocket<Handle>(from, socketId, this, null);
        this.sockets.put(socketId, socket);
        this.app.incomingSocket(socket);
    }

    protected void socketOpened(int socketId) throws IOException {
        this.sockets.get(socketId).socketOpened();
    }

    protected void socketException(int socketId, IOException ioe) throws IOException {
        this.sockets.get(socketId).receiveException(ioe);
    }

    public int openSocket(Handle target) throws IOException {
        if (this.next == null) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: OpenSocket event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return Integer.MIN_VALUE;
        }
        if (this.next.getType() != 31) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_OPEN_OUTGOING event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
            }
            this.foundFault = true;
            return Integer.MIN_VALUE;
        }
        int ret = this.nextEvent.readInt();
        RawSerializable logReceiver = (RawSerializable)this.peerreview.getHandleSerializer().deserialize(this.nextEvent);
        if (!logReceiver.equals(target)) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_OPEN_OUTGOING to " + target + " during replay, but log shows SOCKET_OPEN_OUTGOING to " + logReceiver + "; marking as invalid");
            }
            this.foundFault = true;
            return Integer.MIN_VALUE;
        }
        this.fetchNextEvent();
        return ret;
    }

    public int readSocket(int socketId, ByteBuffer dst) throws IOException {
        if (this.next == null) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: ReadSocket event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        if (this.next.getType() == 36) {
            this.fetchNextEvent();
            return -1;
        }
        if (this.next.getType() != 40) {
            if (this.logger.level <= 900) {
                this.logger.logException("Replay (" + this.nextEventIndex + "): SOCKET_READ event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid", new Exception("Stack Trace"));
            }
            this.foundFault = true;
            return Integer.MIN_VALUE;
        }
        int loggedSocket = this.nextEvent.readInt();
        if (loggedSocket != socketId) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_READ on socket " + socketId + " during replay, but log shows SOCKET_READ to " + loggedSocket + "; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        int ret = this.nextEvent.bytesRemaining();
        if (dst.remaining() < ret) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_READ reading a maximum of " + dst.remaining() + " on socket " + socketId + " during replay, but log shows SOCKET_READ reading " + ret + " bytes; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        this.nextEvent.read(dst.array(), dst.position(), ret);
        dst.position(dst.position() + ret);
        this.fetchNextEvent();
        return ret;
    }

    public void generatedSocketException(int socketId, IOException ioe) {
        block8: {
            if (this.next == null) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: WriteSocket event after end of segment; marking as invalid");
                }
                this.foundFault = true;
                return;
            }
            if (this.next.getType() != 33) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: EVT_SOCKET_EXCEPTION event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
                }
                this.foundFault = true;
                return;
            }
            try {
                int loggedSocket = this.nextEvent.readInt();
                if (loggedSocket != socketId) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: EVT_SOCKET_EXCEPTION on socket " + socketId + " during replay, but log shows EVT_SOCKET_EXCEPTION to " + loggedSocket + "; marking as invalid");
                    }
                    this.foundFault = true;
                    return;
                }
            }
            catch (IOException ioe2) {
                if (this.logger.level > 900) break block8;
                this.logger.logException("Replay: Error reading log", ioe2);
            }
        }
        this.fetchNextEvent();
    }

    public int writeSocket(int socketId, ByteBuffer src) throws IOException {
        if (this.next == null) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: WriteSocket event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        if (this.next.getType() == 36) {
            this.fetchNextEvent();
            return -1;
        }
        if (this.next.getType() != 41) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_WRITE event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
            }
            this.foundFault = true;
            return Integer.MIN_VALUE;
        }
        int loggedSocket = this.nextEvent.readInt();
        if (loggedSocket != socketId) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_WRITE on socket " + socketId + " during replay, but log shows SOCKET_WRITE to " + loggedSocket + "; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        int ret = this.nextEvent.bytesRemaining();
        if (src.remaining() < ret) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_WRITE writing a maximum of " + src.remaining() + " on socket " + socketId + " during replay, but log shows SOCKET_WRITE writing " + ret + " bytes; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        byte[] loggedMsg = new byte[ret];
        byte[] sentMsg = new byte[ret];
        this.nextEvent.read(loggedMsg);
        src.get(sentMsg);
        if (!Arrays.equals(loggedMsg, sentMsg)) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: Message wrote during replay differs from message in the log");
            }
            this.foundFault = true;
            return 0;
        }
        this.fetchNextEvent();
        return ret;
    }

    public void close(int socketId) {
        int loggedSocket;
        if (this.next == null) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay(" + this.nextEventIndex + "): SOCKET_CLOSE event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        if (this.next.getType() != 34) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay(" + this.nextEventIndex + "): SOCKET_CLOSE event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        try {
            loggedSocket = this.nextEvent.readInt();
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: Error deserializing event " + this.next);
            }
            this.foundFault = true;
            return;
        }
        if (loggedSocket != socketId) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_CLOSE on socket " + socketId + " during replay, but log shows SOCKET_CLOSE to " + loggedSocket + "; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        this.fetchNextEvent();
    }

    public void shutdownOutput(int socketId) {
        int loggedSocket;
        if (this.next == null) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: EVT_SOCKET_SHUTDOWN_OUTPUT event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        if (this.next.getType() != 35) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: EVT_SOCKET_SHUTDOWN_OUTPUT event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        try {
            loggedSocket = this.nextEvent.readInt();
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: Error deserializing event " + this.next);
            }
            this.foundFault = true;
            return;
        }
        if (loggedSocket != socketId) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: EVT_SOCKET_SHUTDOWN_OUTPUT on socket " + socketId + " during replay, but log shows EVT_SOCKET_SHUTDOWN_OUTPUT to " + loggedSocket + "; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        this.fetchNextEvent();
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void acceptMessages(boolean b) {
        throw new RuntimeException("implement");
    }

    @Override
    public void acceptSockets(boolean b) {
        throw new RuntimeException("implement");
    }

    @Override
    public Handle getLocalIdentifier() {
        return this.localHandle;
    }

    @Override
    public void setCallback(TransportLayerCallback<Handle, ByteBuffer> callback) {
        this.app = (PeerReviewCallback)callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Handle> handler) {
        throw new RuntimeException("implement");
    }

    @Override
    public void destroy() {
        throw new RuntimeException("implement");
    }
}

