/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtRecv;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.peerreview.message.PeerReviewMessage;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.p2p.util.MathUtils;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDataMessage<Handle extends RawSerializable>
implements PeerReviewMessage,
Evidence {
    public static final short TYPE = 16;
    long topSeq;
    Handle senderHandle;
    byte[] hTopMinusOne;
    byte[] signature;
    int relevantLen;
    private byte[] payload;

    public UserDataMessage(long topSeq, Handle senderHandle, byte[] topMinusOne, byte[] sig, ByteBuffer message, int relevantlen) {
        this.topSeq = topSeq;
        this.senderHandle = senderHandle;
        this.hTopMinusOne = topMinusOne;
        this.signature = sig;
        this.relevantLen = relevantlen;
        assert (relevantlen == message.remaining() || relevantlen < 255);
        if (message.remaining() == message.array().length) {
            this.payload = message.array();
        } else {
            this.payload = new byte[message.remaining()];
            System.arraycopy(message.array(), message.position(), this.payload, 0, this.payload.length);
        }
    }

    public String toString() {
        return "UDM:" + this.topSeq + "," + this.senderHandle + "," + MathUtils.toHex(this.hTopMinusOne) + "," + MathUtils.toHex(this.signature) + "," + this.relevantLen + "," + this.payload.length;
    }

    @Override
    public short getType() {
        return 16;
    }

    public byte getRelevantCode() {
        byte relevantCode = this.relevantLen == this.payload.length ? (byte)-1 : (byte)this.relevantLen;
        return relevantCode;
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeLong(this.topSeq);
        this.senderHandle.serialize(buf);
        buf.write(this.hTopMinusOne, 0, this.hTopMinusOne.length);
        buf.write(this.signature, 0, this.signature.length);
        byte relevantCode = this.getRelevantCode();
        buf.writeByte(relevantCode);
        buf.write(this.payload, 0, this.payload.length);
    }

    public static <H extends RawSerializable> UserDataMessage<H> build(InputBuffer buf, Serializer<H> serializer, int hashSize, int sigSize) throws IOException {
        long seq = buf.readLong();
        RawSerializable handle = (RawSerializable)serializer.deserialize(buf);
        byte[] hash = new byte[hashSize];
        buf.read(hash);
        byte[] sig = new byte[sigSize];
        buf.read(sig);
        byte relevantCode = buf.readByte();
        int len = MathUtils.uByteToInt(relevantCode);
        byte[] msg = new byte[buf.bytesRemaining()];
        buf.read(msg);
        if (len == 255) {
            len = msg.length;
        }
        return new UserDataMessage<RawSerializable>(seq, handle, hash, sig, ByteBuffer.wrap(msg), len);
    }

    public long getTopSeq() {
        return this.topSeq;
    }

    public Handle getSenderHandle() {
        return this.senderHandle;
    }

    public byte[] getHTopMinusOne() {
        return this.hTopMinusOne;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getRelevantLen() {
        return this.relevantLen;
    }

    public ByteBuffer getPayload() {
        return ByteBuffer.wrap(this.payload);
    }

    public EvtRecv<Handle> getReceiveEvent(HashProvider hasher) {
        if (this.getRelevantLen() < this.getPayload().remaining()) {
            return new EvtRecv<Handle>(this.getSenderHandle(), this.getTopSeq(), this.getPayload(), this.getRelevantLen(), hasher);
        }
        return new EvtRecv<Handle>(this.getSenderHandle(), this.getTopSeq(), this.getPayload());
    }

    public byte[] getInnerHash(RawSerializable myId, HashProvider hasher) {
        try {
            SimpleOutputBuffer sob = new SimpleOutputBuffer();
            myId.serialize(sob);
            sob.writeBoolean(this.getRelevantLen() < this.getPayloadLen());
            return this.getInnerHash(sob.getByteBuffer(), hasher);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public byte[] getInnerHash(HashProvider hasher) {
        try {
            SimpleOutputBuffer sob = new SimpleOutputBuffer();
            this.senderHandle.serialize(sob);
            sob.writeLong(this.topSeq);
            sob.writeBoolean(this.relevantLen < this.getPayloadLen());
            return this.getInnerHash(sob.getByteBuffer(), hasher);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public byte[] getInnerHash(ByteBuffer header, HashProvider hasher) {
        if (this.relevantLen < this.payload.length) {
            byte[] irrelevantHash = hasher.hash(ByteBuffer.wrap(this.payload, this.relevantLen, this.payload.length - this.relevantLen));
            return hasher.hash(header, ByteBuffer.wrap(this.payload, 0, this.relevantLen), ByteBuffer.wrap(irrelevantHash));
        }
        return hasher.hash(header, ByteBuffer.wrap(this.payload));
    }

    public int getPayloadLen() {
        return this.payload.length;
    }

    @Override
    public short getEvidenceType() {
        return 2;
    }
}

