/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.peerreview.commitment.PeerInfo;
import org.mpisws.p2p.transport.peerreview.message.UserDataMessage;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingUserDataMessage<Handle extends RawSerializable>
extends UserDataMessage<Handle>
implements MessageRequestHandle<Handle, ByteBuffer> {
    PeerInfo<Handle> pi;
    MessageCallback<Handle, ByteBuffer> deliverAckToMe;
    Map<String, Object> options;

    public OutgoingUserDataMessage(long topSeq, Handle senderHandle, byte[] topMinusOne, byte[] sig, ByteBuffer message, int relevantlen, Map<String, Object> options, PeerInfo<Handle> pi, MessageCallback<Handle, ByteBuffer> deliverAckToMe) {
        super(topSeq, senderHandle, topMinusOne, sig, message, relevantlen);
        this.options = options;
        this.pi = pi;
        this.deliverAckToMe = deliverAckToMe;
    }

    @Override
    public Handle getIdentifier() {
        return this.pi.getHandle();
    }

    @Override
    public ByteBuffer getMessage() {
        return this.getPayload();
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public boolean cancel() {
        return false;
    }

    public void sendComplete() {
        if (this.deliverAckToMe != null) {
            this.deliverAckToMe.ack(this);
        }
    }

    public void sendFailed(IOException ioe) {
        if (this.deliverAckToMe != null) {
            this.deliverAckToMe.sendFailed(this, ioe);
        }
    }
}

