/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorSerializer;
import org.mpisws.p2p.transport.peerreview.message.PeerReviewMessage;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthPushMessage<Identifier extends RawSerializable>
implements PeerReviewMessage {
    public Map<Identifier, List<Authenticator>> authenticators;

    public AuthPushMessage(Map<Identifier, List<Authenticator>> authenticators) {
        this.authenticators = authenticators;
    }

    @Override
    public short getType() {
        return 21;
    }

    public static <I extends RawSerializable> AuthPushMessage<I> build(InputBuffer buf, Serializer<I> idSerializer, AuthenticatorSerializer authSerializer) throws IOException {
        HashMap authenticators = new HashMap();
        int numIds = buf.readShort();
        for (int i = 0; i < numIds; ++i) {
            RawSerializable id = (RawSerializable)idSerializer.deserialize(buf);
            int numAuths = buf.readShort();
            ArrayList<Authenticator> l = new ArrayList<Authenticator>();
            authenticators.put(id, l);
            for (int a = 0; a < numAuths; ++a) {
                l.add(authSerializer.deserialize(buf));
            }
        }
        return new AuthPushMessage(authenticators);
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort((short)this.authenticators.size());
        for (Map.Entry<Identifier, List<Authenticator>> e : this.authenticators.entrySet()) {
            ((RawSerializable)e.getKey()).serialize(buf);
            buf.writeShort((short)e.getValue().size());
            for (Authenticator a : e.getValue()) {
                a.serialize(buf);
            }
        }
    }
}

