/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.message;

import java.io.IOException;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.peerreview.message.PeerReviewMessage;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AckMessage<Identifier extends RawSerializable>
implements PeerReviewMessage,
Evidence {
    Identifier nodeId;
    long sendEntrySeq;
    long recvEntrySeq;
    byte[] hashTopMinusOne;
    byte[] signature;

    public AckMessage(Identifier nodeId, long sendEntrySeq, long recvEntrySeq, byte[] hashTopMinusOne, byte[] signature) {
        this.nodeId = nodeId;
        this.sendEntrySeq = sendEntrySeq;
        this.recvEntrySeq = recvEntrySeq;
        this.hashTopMinusOne = hashTopMinusOne;
        this.signature = signature;
    }

    @Override
    public short getType() {
        return 17;
    }

    @Override
    public short getEvidenceType() {
        return 2;
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        this.nodeId.serialize(buf);
        buf.writeLong(this.sendEntrySeq);
        buf.writeLong(this.recvEntrySeq);
        buf.write(this.hashTopMinusOne, 0, this.hashTopMinusOne.length);
        buf.write(this.signature, 0, this.signature.length);
    }

    public static <Identifier extends RawSerializable> AckMessage<Identifier> build(InputBuffer sib, Serializer<Identifier> serializer, int hashSizeInBytes, int signatureSizeInBytes) throws IOException {
        RawSerializable remoteId = (RawSerializable)serializer.deserialize(sib);
        long ackedSeq = sib.readLong();
        long hisSeq = sib.readLong();
        byte[] hTopMinusOne = new byte[hashSizeInBytes];
        sib.read(hTopMinusOne);
        byte[] signature = new byte[signatureSizeInBytes];
        sib.read(signature);
        return new AckMessage<RawSerializable>(remoteId, ackedSeq, hisSeq, hTopMinusOne, signature);
    }

    public Identifier getNodeId() {
        return this.nodeId;
    }

    public long getSendEntrySeq() {
        return this.sendEntrySeq;
    }

    public long getRecvEntrySeq() {
        return this.recvEntrySeq;
    }

    public byte[] getHashTopMinusOne() {
        return this.hashTopMinusOne;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

