/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.history;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.mpisws.p2p.transport.peerreview.audit.LogSnippet;
import org.mpisws.p2p.transport.peerreview.audit.SnippetEntry;
import org.mpisws.p2p.transport.peerreview.history.HashPolicy;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.HashSeq;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.IndexEntryFactory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.util.RandomAccessFileIOBuffer;

public class SecureHistoryImpl
implements SecureHistory {
    protected Logger logger;
    protected HashProvider hashProv;
    protected boolean pointerAtEnd;
    protected IndexEntry topEntry;
    protected long baseSeq;
    protected long nextSeq;
    protected long numEntries;
    protected RandomAccessFileIOBuffer indexFile;
    protected RandomAccessFileIOBuffer dataFile;
    protected boolean readOnly;
    protected IndexEntryFactory indexFactory;

    public SecureHistoryImpl(RandomAccessFileIOBuffer indexFile, RandomAccessFileIOBuffer dataFile, boolean readOnly, HashProvider hashProv, IndexEntryFactory indexFactory, Logger logger) throws IOException {
        assert (indexFile != null && dataFile != null);
        this.logger = logger;
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        this.indexFactory = indexFactory;
        indexFile.seek(0L);
        IndexEntry firstEntry = indexFactory.build(indexFile);
        this.baseSeq = firstEntry.seq;
        indexFile.seek(indexFile.length() - (long)indexFactory.getSerializedSize());
        this.topEntry = indexFactory.build(indexFile);
        this.numEntries = (int)(indexFile.length() / (long)indexFactory.getSerializedSize());
        dataFile.seek(dataFile.length());
        this.nextSeq = this.topEntry.seq + 1L;
        this.pointerAtEnd = true;
        this.indexFile = indexFile;
        this.dataFile = dataFile;
        this.readOnly = readOnly;
        this.hashProv = hashProv;
    }

    public long getBaseSeq() {
        return this.baseSeq;
    }

    public long getLastSeq() {
        return this.topEntry.seq;
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    public HashSeq getTopLevelEntry() {
        return new HashSeq(this.topEntry.nodeHash, this.topEntry.seq);
    }

    public void appendEntry(short type, boolean storeFullEntry, ByteBuffer ... entry) throws IOException {
        assert (this.indexFile != null && this.dataFile != null);
        if (this.logger.level <= 400) {
            this.logger.log("appendEntry(" + type + "," + storeFullEntry + "," + entry.length + "," + entry[0].remaining() + "):" + this.nextSeq);
        }
        if (this.readOnly) {
            throw new IllegalStateException("Cannot append entry to readonly history");
        }
        if (!this.pointerAtEnd) {
            this.indexFile.seek(this.indexFile.length());
            this.dataFile.seek(this.dataFile.length());
            this.pointerAtEnd = true;
        }
        IndexEntry e = new IndexEntry(this.nextSeq++);
        e.contentHash = this.hashProv.hash(entry);
        e.nodeHash = this.hashProv.hash(e.seq, type, this.topEntry.nodeHash, e.contentHash);
        e.type = type;
        e.fileIndex = this.dataFile.getFilePointer();
        if (storeFullEntry) {
            e.sizeInFile = 0;
            for (ByteBuffer ent : entry) {
                e.sizeInFile += ent.remaining();
                this.dataFile.write(ent.array(), ent.position(), ent.remaining());
            }
        } else {
            e.sizeInFile = -1;
        }
        this.topEntry = e;
        this.topEntry.serialize(this.indexFile);
        ++this.numEntries;
    }

    public void appendHash(short type, byte[] hash) throws IOException {
        assert (this.indexFile != null && this.dataFile != null);
        if (this.readOnly) {
            throw new IllegalStateException("Cannot append entry to readonly history");
        }
        if (!this.pointerAtEnd) {
            this.indexFile.seek(this.indexFile.length());
            this.dataFile.seek(this.dataFile.length());
            this.pointerAtEnd = true;
        }
        IndexEntry e = new IndexEntry(this.nextSeq++);
        e.contentHash = hash;
        e.nodeHash = this.hashProv.hash(e.seq, type, this.topEntry.nodeHash, e.contentHash);
        e.type = type;
        e.fileIndex = -1L;
        e.sizeInFile = -1;
        this.topEntry = e;
        this.topEntry.serialize(this.indexFile);
        ++this.numEntries;
    }

    public boolean setNextSeq(long nextSeq) {
        if (nextSeq < this.nextSeq) {
            return false;
        }
        this.nextSeq = nextSeq;
        return true;
    }

    public void close() throws IOException {
        assert (this.indexFile != null && this.dataFile != null);
        if (this.logger.level <= 500) {
            this.logger.logException(this + ".close()", new Exception("Stack Trace"));
        }
        this.indexFile.close();
        this.dataFile.close();
        this.indexFile = null;
        this.dataFile = null;
    }

    public long findSeq(long seq) throws IOException {
        return this.findSeqOrHigher(seq, false);
    }

    public long findSeqOrHigher(long seq, boolean allowHigher) throws IOException {
        assert (this.indexFile != null && this.dataFile != null);
        if (seq > this.topEntry.seq) {
            return -1L;
        }
        if (allowHigher && seq < this.baseSeq) {
            return 0L;
        }
        if (seq == this.topEntry.seq) {
            return this.numEntries - 1L;
        }
        this.pointerAtEnd = false;
        this.indexFile.seek(this.indexFile.length());
        long rbegin = 1L;
        long rend = this.indexFile.getFilePointer() / (long)this.indexFactory.getSerializedSize() - 1L;
        while (rbegin != rend) {
            assert (rend >= rbegin);
            long pivot = (rbegin + rend) / 2L;
            this.indexFile.seek(pivot * (long)this.indexFactory.getSerializedSize());
            IndexEntry ie = this.indexFactory.build(this.indexFile);
            if (ie.seq >= seq) {
                rend = pivot;
                continue;
            }
            rbegin = pivot + 1L;
        }
        if (allowHigher) {
            return rbegin;
        }
        this.indexFile.seek(rbegin * (long)this.indexFactory.getSerializedSize());
        IndexEntry ie = this.indexFactory.build(this.indexFile);
        if (ie.seq != seq) {
            return -1L;
        }
        return rbegin;
    }

    public LogSnippet serializeRange(long idxFrom, long idxTo, HashPolicy hashPolicy) throws IOException {
        assert (0L < idxFrom && idxFrom <= idxTo && idxTo < this.numEntries);
        this.pointerAtEnd = false;
        this.indexFile.seek((idxFrom - 1L) * (long)this.indexFactory.getSerializedSize());
        IndexEntry ie = this.indexFactory.build(this.indexFile);
        byte[] baseHash = ie.nodeHash;
        ArrayList<SnippetEntry> entryList = new ArrayList<SnippetEntry>();
        long previousSeq = -1L;
        for (long idx = idxFrom; idx <= idxTo; ++idx) {
            boolean hashIt;
            ie = this.indexFactory.build(this.indexFile);
            if (ie == null) {
                throw new IOException("History read error");
            }
            assert (previousSeq == -1L || ie.seq > previousSeq);
            byte[] buffer = null;
            if (ie.sizeInFile > 0) {
                buffer = new byte[ie.sizeInFile];
                assert (ie.fileIndex >= 0L);
                this.dataFile.seek(ie.fileIndex);
                this.dataFile.read(buffer);
            }
            boolean bl = hashIt = ie.sizeInFile < 0 || hashPolicy != null && hashPolicy.hashEntry(ie.type, buffer);
            if (hashIt) {
                buffer = ie.contentHash;
            }
            SnippetEntry entry = new SnippetEntry((byte)ie.type, ie.seq, hashIt, buffer);
            entryList.add(entry);
        }
        LogSnippet ret = new LogSnippet(baseHash, entryList);
        return ret;
    }

    public boolean serializeRange2(long idxFrom, long idxTo, HashPolicy hashPolicy, OutputBuffer outfile) throws IOException {
        assert (0L < idxFrom && idxFrom <= idxTo && idxTo < this.numEntries);
        this.pointerAtEnd = false;
        this.indexFile.seek((idxFrom - 1L) * (long)this.indexFactory.getSerializedSize());
        IndexEntry ie = this.indexFactory.build(this.indexFile);
        outfile.write(ie.nodeHash, 0, ie.nodeHash.length);
        long previousSeq = -1L;
        for (long idx = idxFrom; idx <= idxTo; ++idx) {
            boolean hashIt;
            ie = this.indexFactory.build(this.indexFile);
            if (ie == null) {
                throw new IOException("History read error");
            }
            assert (previousSeq == -1L || ie.seq > previousSeq);
            if (previousSeq >= 0L) {
                if (ie.seq == previousSeq + 1L) {
                    outfile.writeByte((byte)0);
                } else {
                    long dhigh = ie.seq / 1000L - previousSeq / 1000L;
                    if (dhigh < 255L && ie.seq % 1000L == 0L) {
                        outfile.writeByte((byte)(dhigh & 0xFFL));
                    } else {
                        outfile.writeByte((byte)-1);
                        outfile.writeLong(ie.seq);
                    }
                }
            }
            previousSeq = ie.seq;
            outfile.writeShort(ie.type);
            byte[] buffer = null;
            if (ie.sizeInFile > 0) {
                buffer = new byte[ie.sizeInFile];
                assert (ie.fileIndex >= 0L);
                this.dataFile.seek(ie.fileIndex);
                this.dataFile.read(buffer);
            }
            boolean bl = hashIt = ie.sizeInFile < 0 || hashPolicy != null && hashPolicy.hashEntry(ie.type, buffer);
            if (hashIt) {
                outfile.writeByte((byte)0);
                outfile.write(ie.contentHash, 0, ie.contentHash.length);
            } else if (ie.sizeInFile < 255) {
                outfile.writeByte((byte)(ie.sizeInFile & 0xFF));
            } else if (ie.sizeInFile < 65536) {
                outfile.writeByte((byte)-1);
                outfile.writeShort((short)(ie.sizeInFile & 0xFFFF));
            } else {
                outfile.writeByte((byte)-2);
                outfile.writeLong(ie.sizeInFile);
            }
            if (hashIt) continue;
            outfile.write(buffer, 0, buffer.length);
        }
        return true;
    }

    public IndexEntry statEntry(long idx) throws IOException {
        if (idx < 0L || idx >= this.numEntries) {
            return null;
        }
        this.pointerAtEnd = false;
        this.indexFile.seek(idx * (long)this.indexFactory.getSerializedSize());
        IndexEntry ie = this.indexFactory.build(this.indexFile);
        return ie;
    }

    public byte[] getEntry(long idx, int maxSizeToRead) throws IOException {
        return this.getEntry(this.statEntry(idx), maxSizeToRead);
    }

    public byte[] getEntry(IndexEntry ie, int maxSizeToRead) throws IOException {
        if (ie == null) {
            return null;
        }
        if (ie.sizeInFile < 0) {
            return null;
        }
        try {
            this.dataFile.seek(ie.fileIndex);
        }
        catch (IOException ioe) {
            this.logger.log("fileIndex:" + ie.fileIndex + " " + ie);
            throw ioe;
        }
        int bytesToRead = maxSizeToRead >= ie.sizeInFile ? ie.sizeInFile : maxSizeToRead;
        byte[] ret = new byte[bytesToRead];
        this.dataFile.read(ret);
        return ret;
    }

    public boolean upgradeHashedEntry(int idx, ByteBuffer entry) throws IOException {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot upgrade hashed entry in readonly history");
        }
        if (idx < 0 || (long)idx >= this.numEntries) {
            return false;
        }
        this.pointerAtEnd = false;
        this.indexFile.seek(idx * this.indexFactory.getSerializedSize());
        IndexEntry ie = this.indexFactory.build(this.indexFile);
        if (ie == null) {
            return false;
        }
        if (ie.sizeInFile >= 0) {
            return false;
        }
        this.dataFile.seek(this.dataFile.length());
        ie.fileIndex = this.dataFile.getFilePointer();
        ie.sizeInFile = entry.remaining();
        this.dataFile.write(entry.array(), entry.position(), entry.remaining());
        this.indexFile.seek(idx * this.indexFactory.getSerializedSize());
        ie.serialize(this.indexFile);
        return true;
    }

    public long findLastEntry(short[] types, long maxSeq) throws IOException {
        long maxIdx;
        for (long currentIdx = maxIdx = this.findSeqOrHigher(Math.min(maxSeq, this.topEntry.seq), true); currentIdx >= 0L; --currentIdx) {
            IndexEntry ie = this.statEntry(currentIdx);
            if (ie == null) {
                throw new IllegalStateException("Cannot stat history entry #" + currentIdx + " (num=" + this.numEntries + ")");
            }
            for (int i = 0; i < types.length; ++i) {
                if (ie.type != types[i]) continue;
                return currentIdx;
            }
        }
        return -1L;
    }

    public void appendSnippetToHistory(LogSnippet snippet) throws IOException {
        for (SnippetEntry sEntry : snippet.entries) {
            if (sEntry.seq <= this.getLastSeq()) continue;
            if (!this.setNextSeq(sEntry.seq)) {
                throw new RuntimeException("Audit: Cannot set history sequence number?!?");
            }
            if (!sEntry.isHash) {
                this.appendEntry(sEntry.type, true, ByteBuffer.wrap(sEntry.content));
                continue;
            }
            this.appendHash(sEntry.type, sEntry.content);
        }
    }
}

