/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.history;

import java.io.IOException;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class IndexEntry {
    long seq;
    long fileIndex;
    int sizeInFile;
    short type;
    byte[] contentHash;
    byte[] nodeHash;

    public IndexEntry(long seq) {
        this.seq = seq;
    }

    public IndexEntry(long seq, long index, short type, int size, byte[] contentHash, byte[] nodeHash) {
        this.seq = seq;
        this.fileIndex = index;
        this.type = type;
        this.sizeInFile = size;
        this.contentHash = contentHash;
        this.nodeHash = nodeHash;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeLong(this.seq);
        buf.writeLong(this.fileIndex);
        buf.writeInt(this.sizeInFile);
        buf.writeShort(this.type);
        buf.write(this.contentHash, 0, this.contentHash.length);
        buf.write(this.nodeHash, 0, this.nodeHash.length);
    }

    public byte[] getContentHash() {
        return this.contentHash;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public byte[] getNodeHash() {
        return this.nodeHash;
    }

    public long getSeq() {
        return this.seq;
    }

    public int getSizeInFile() {
        return this.sizeInFile;
    }

    public short getType() {
        return this.type;
    }

    public String toString() {
        return "IE{#" + this.seq + " t:" + this.type + " s:" + this.sizeInFile + "}";
    }

    public boolean isHashed() {
        return this.sizeInFile < 0;
    }
}

