/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.authpush;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.authpush.AuthenticatorPushProtocol;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorStore;
import org.mpisws.p2p.transport.peerreview.evidence.EvidenceTransferProtocol;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoStore;
import org.mpisws.p2p.transport.peerreview.message.AuthPushMessage;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticatorPushProtocolImpl<Handle extends RawSerializable, Identifier extends RawSerializable>
implements AuthenticatorPushProtocol<Handle, Identifier> {
    static final int MAX_SUBJECTS_PER_WITNESS = 110;
    static final int MAX_WITNESSES_PER_SUBJECT = 110;
    static final int MSS = 1200;
    AuthenticatorStore<Identifier> authOutStore;
    AuthenticatorStore<Identifier> authInStore;
    AuthenticatorStore<Identifier> authPendingStore;
    PeerInfoStore<Handle, Identifier> infoStore;
    PeerReview<Handle, Identifier> peerreview;
    IdentityTransport<Handle, Identifier> transport;
    EvidenceTransferProtocol<Handle, Identifier> evidenceTransferProtocol;
    boolean probabilistic;
    double pXmit;
    Random random = new Random();
    Environment environment;
    Logger logger;

    public AuthenticatorPushProtocolImpl(PeerReview<Handle, Identifier> peerreview, AuthenticatorStore<Identifier> inStore, AuthenticatorStore<Identifier> outStore, AuthenticatorStore<Identifier> pendingStore, IdentityTransport<Handle, Identifier> transport, PeerInfoStore<Handle, Identifier> infoStore, EvidenceTransferProtocol<Handle, Identifier> evidenceTransferProtocol, Environment env) {
        this.authInStore = inStore;
        this.authOutStore = outStore;
        this.authPendingStore = pendingStore;
        this.transport = transport;
        this.infoStore = infoStore;
        this.peerreview = peerreview;
        this.evidenceTransferProtocol = evidenceTransferProtocol;
        this.probabilistic = false;
        this.pXmit = 1.0;
        this.environment = env;
        this.logger = env.getLogManager().getLogger(AuthenticatorPushProtocolImpl.class, null);
    }

    public void enableProbabilisticChecking(double pXmit) {
        this.probabilistic = true;
        this.pXmit = pXmit;
    }

    @Override
    public void push() {
        if (this.logger.level <= 500) {
            this.logger.log("Authenticator push initiated with " + this.authOutStore.getNumSubjects() + " subjects");
        }
        this.evidenceTransferProtocol.requestWitnesses(this.authOutStore.getSubjects(), new Continuation<Map<Identifier, Collection<Handle>>, Exception>(){

            @Override
            public void receiveException(Exception exception) {
                AuthenticatorPushProtocolImpl.this.logger.logException("Error requesting witnesses " + AuthenticatorPushProtocolImpl.this.authOutStore.getSubjects(), exception);
            }

            @Override
            public void receiveResult(Map<Identifier, Collection<Handle>> result) {
                AuthenticatorPushProtocolImpl.this.continuePush(result);
            }
        });
    }

    @Override
    public void continuePush(Map<Identifier, Collection<Handle>> subjectsToWitnesses) {
        if (this.logger.level <= 500) {
            this.logger.log("Continuing authenticator push with " + subjectsToWitnesses.size() + " subjects");
        }
        HashMap<RawSerializable, HashMap<Identifier, List<Authenticator>>> witnesses = new HashMap<RawSerializable, HashMap<Identifier, List<Authenticator>>>();
        for (Map.Entry<Identifier, Collection<Handle>> entry : subjectsToWitnesses.entrySet()) {
            for (RawSerializable witness : entry.getValue()) {
                HashMap<Identifier, List<Authenticator>> m = (HashMap<Identifier, List<Authenticator>>)witnesses.get(witness);
                if (m == null) {
                    m = new HashMap<Identifier, List<Authenticator>>();
                    witnesses.put(witness, m);
                }
                m.put(entry.getKey(), this.authOutStore.getAuthenticators(entry.getKey()));
            }
        }
        if (this.logger.level <= 400) {
            this.logger.log("Found " + witnesses.size() + " unique witnesses");
        }
        try {
            for (Map.Entry<Object, Collection<Object>> entry : witnesses.entrySet()) {
                this.sendAuthenticators((RawSerializable)entry.getKey(), (Map)((Object)entry.getValue()));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error sending authenticators.", ioe);
        }
        if (this.logger.level <= 400) {
            this.logger.log("Push completed; releasing authenticators");
        }
        for (RawSerializable rawSerializable : subjectsToWitnesses.keySet()) {
            this.authOutStore.flush(rawSerializable);
        }
    }

    protected void sendAuthenticators(Handle h, Map<Identifier, List<Authenticator>> authenticators) throws IOException {
        if (this.probabilistic) {
            for (Map.Entry<Identifier, List<Authenticator>> e : authenticators.entrySet()) {
                Iterator<Authenticator> i = e.getValue().iterator();
                while (i.hasNext()) {
                    if (!((double)this.random.nextFloat() < 1.0 - this.pXmit)) continue;
                    i.remove();
                }
            }
        }
        this.peerreview.transmit(h, new AuthPushMessage<Identifier>(authenticators), null, null);
    }

    public void addAuthenticatorsIfValid(List<Authenticator> authenticators, Identifier id) {
        for (Authenticator thisAuth : authenticators) {
            if (this.peerreview.addAuthenticatorIfValid(this.authInStore, id, thisAuth) || this.logger.level > 900) continue;
            this.logger.log("Authenticator " + thisAuth + " has invalid signature; discarding");
        }
    }

    @Override
    public void handleIncomingAuthenticators(Handle source, AuthPushMessage<Identifier> msg) {
        if (this.logger.level <= 800) {
            this.logger.log("Received authenticators from " + source);
        }
        for (Map.Entry e : msg.authenticators.entrySet()) {
            RawSerializable id = (RawSerializable)e.getKey();
            if (this.logger.level <= 500) {
                this.logger.log("  Subject <" + id + ">, " + e.getValue().size() + " authenticators");
            }
            if (this.transport.hasCertificate(id)) {
                this.addAuthenticatorsIfValid(e.getValue(), id);
            } else {
                if (this.logger.level <= 500) {
                    this.logger.log("  Missing certificate for this subject; requesting from " + source + " and recording auths as pending");
                }
                for (Authenticator a : e.getValue()) {
                    this.authPendingStore.addAuthenticator(id, a);
                }
                this.peerreview.requestCertificate(source, id);
            }
            if (this.infoStore.getStatus(id) == 0) continue;
            this.evidenceTransferProtocol.sendEvidence(source, id);
        }
    }

    @Override
    public void notifyCertificateAvailable(Identifier id) {
        int numAuths = this.authPendingStore.numAuthenticatorsFor(id);
        if (numAuths > 0) {
            if (this.logger.level <= 500) {
                this.logger.log("Found " + numAuths + " pending authenticators for <" + id + ">; processing...");
            }
            List<Authenticator> buffer = this.authPendingStore.getAuthenticators(id);
            this.addAuthenticatorsIfValid(buffer, id);
            this.authPendingStore.flushAuthenticatorsFor(id);
        }
    }
}

