/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.audit;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.audit.EvidenceTool;
import org.mpisws.p2p.transport.peerreview.audit.LogSnippet;
import org.mpisws.p2p.transport.peerreview.audit.SnippetEntry;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorStore;
import org.mpisws.p2p.transport.peerreview.commitment.CommitmentProtocol;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtAck;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtInit;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtRecv;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtSend;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtSendSign;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtSign;
import org.mpisws.p2p.transport.peerreview.message.UserDataMessage;
import org.mpisws.p2p.transport.util.Serializer;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.p2p.util.tuples.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvidenceToolImpl<Handle extends RawSerializable, Identifier extends RawSerializable>
implements EvidenceTool<Handle, Identifier> {
    Logger logger;
    Serializer<Identifier> idSerializer;
    Serializer<Handle> handleSerializer;
    int hashSize;
    int signatureSize;
    private PeerReview<Handle, Identifier> peerreview;

    public EvidenceToolImpl(PeerReview<Handle, Identifier> peerreview, Serializer<Handle> handleSerializer, Serializer<Identifier> idSerializer, int hashSize, int signatureSize) {
        this.peerreview = peerreview;
        this.logger = peerreview.getEnvironment().getLogManager().getLogger(EvidenceToolImpl.class, null);
        this.handleSerializer = handleSerializer;
        this.idSerializer = idSerializer;
        this.hashSize = hashSize;
        this.signatureSize = signatureSize;
    }

    @Override
    public Tuple<Integer, Identifier> checkSnippet(LogSnippet snippet) {
        block11: for (SnippetEntry entry : snippet.entries) {
            if (entry.isHash && entry.type != 4 && entry.type != 6 && entry.type != 0) {
                if (this.logger.level <= 900) {
                    this.logger.log("Malformed statement: Entry of type #" + entry.type + " is hashed");
                }
                return new Tuple<Integer, Object>(2, null);
            }
            if (this.logger.level <= 400) {
                this.logger.log("Entry type " + entry.type + ", size=" + entry.content.length + " " + (entry.isHash ? " (hashed)" : ""));
            }
            try {
                SimpleInputBuffer sib = new SimpleInputBuffer(entry.content);
                switch (entry.type) {
                    case 0: {
                        if (entry.isHash) continue block11;
                        new EvtSend<Identifier>(sib, this.idSerializer, this.hashSize);
                        break;
                    }
                    case 1: {
                        EvtRecv<Handle> recv = new EvtRecv<Handle>(sib, this.handleSerializer, this.hashSize);
                        Object id = (RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(recv.getSenderHandle());
                        if (this.peerreview.hasCertificate(id)) continue block11;
                        if (this.logger.level <= 500) {
                            this.logger.log("AUDIT RESPONSE contains RECV from " + id + "; certificate needed");
                        }
                        return new Tuple<Integer, Identifier>(3, id);
                    }
                    case 2: {
                        new EvtSign(sib, this.signatureSize, this.hashSize);
                        break;
                    }
                    case 3: {
                        EvtAck<Identifier> evtAck = new EvtAck<Identifier>(sib, this.idSerializer, this.hashSize, this.signatureSize);
                        Object id = evtAck.getRemoteId();
                        if (this.peerreview.hasCertificate(id)) continue block11;
                        if (this.logger.level <= 500) {
                            this.logger.log("AUDIT RESPONSE contains RECV from " + id + "; certificate needed");
                        }
                        return new Tuple<Integer, Identifier>(3, id);
                    }
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    case 5: {
                        new EvtInit<Handle>(sib, this.handleSerializer);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    default: {
                        assert (entry.type > 9);
                        continue block11;
                    }
                }
            }
            catch (IOException ioe) {
                if (this.logger.level <= 900) {
                    this.logger.logException("Malformed entry:" + entry, ioe);
                }
                return new Tuple<Integer, Object>(2, null);
            }
        }
        return new Tuple<Integer, Object>(1, null);
    }

    @Override
    public boolean checkSnippetSignatures(LogSnippet snippet, Handle subjectHandle, AuthenticatorStore<Identifier> authStoreOrNull, byte flags, CommitmentProtocol<Handle, Identifier> commitmentProtocol, byte[] keyNodeHash, long keyNodeMaxSeq) {
        HashSet<Long> seqBuf;
        SnippetEntry lastEntry;
        boolean keyNodeFound;
        boolean firstEntry;
        byte[] prevPrevNodeHash;
        byte[] prevNodeHash;
        byte[] currentNodeHash;
        boolean startWithCheckpoint;
        block69: {
            startWithCheckpoint = (flags & 1) == 1;
            currentNodeHash = snippet.baseHash;
            prevNodeHash = null;
            prevPrevNodeHash = null;
            firstEntry = true;
            keyNodeFound = false;
            lastEntry = null;
            seqBuf = new HashSet<Long>();
            boolean numSeqs = false;
            try {
                if (commitmentProtocol == null || (flags & 2) != 2) break block69;
                assert (this.peerreview != null);
                SecureHistory history = this.peerreview.getHistory();
                for (long i = history.getNumEntries() - 1L; i >= 1L; --i) {
                    IndexEntry entry = history.statEntry(i);
                    short type = entry.getType();
                    if (entry.getSeq() >= snippet.getFirstSeq() - this.peerreview.getTimeToleranceMillis() * 1000000L) {
                        byte[] evtBytes;
                        EvtRecv<Handle> evtRecv;
                        Handle thisSender;
                        if (type != 1 || !(thisSender = (evtRecv = new EvtRecv<Handle>(new SimpleInputBuffer(evtBytes = history.getEntry(entry, entry.getSizeInFile())), this.handleSerializer, this.hashSize)).getSenderHandle()).equals(subjectHandle)) continue;
                        seqBuf.add(evtRecv.getSenderSeq());
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        HashMap<Long, SendEntryRecord> secache = new HashMap<Long, SendEntryRecord>();
        if (this.logger.level <= 500) {
            this.logger.log("Checking snippet (flags=" + flags + ")");
        }
        for (SnippetEntry entry : snippet.entries) {
            if (!firstEntry) {
                if (entry.seq <= lastEntry.seq) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Log snippet attempts to roll back the sequence number from " + lastEntry.seq + " to " + entry.seq + "; flagging invalid");
                    }
                    return false;
                }
                if (keyNodeHash != null && !keyNodeFound && entry.seq > keyNodeMaxSeq) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Hash of keyNode does not appear in [" + snippet.getFirstSeq() + "," + keyNodeMaxSeq + "]; flagging invalid");
                    }
                    return false;
                }
            }
            if (this.logger.level <= 400) {
                this.logger.log("Entry type " + entry.type + ", size=" + entry.content.length + ", seq=" + entry.seq + " " + (entry.isHash ? " (hashed)" : ""));
            }
            if (lastEntry != null && lastEntry.type == 1 && (entry.type != 2 || entry.seq != lastEntry.seq + 1L)) {
                if (this.logger.level <= 900) {
                    this.logger.log("Log snipped omits the mandatory EVT_SIGN after an EVT_RECV; flagging invalid");
                }
                return false;
            }
            prevPrevNodeHash = prevNodeHash;
            prevNodeHash = currentNodeHash;
            byte[] contentHash = entry.isHash ? entry.content : this.peerreview.hash(ByteBuffer.wrap(entry.content));
            currentNodeHash = this.peerreview.hash(entry.seq, entry.type, currentNodeHash, contentHash);
            try {
                SimpleInputBuffer sib = new SimpleInputBuffer(entry.content);
                switch (entry.type) {
                    case 0: {
                        if (!entry.isHash) {
                            this.idSerializer.deserialize(sib);
                            secache.put(entry.seq, new SendEntryRecord(entry.seq, ByteBuffer.wrap(entry.content, entry.content.length - sib.bytesRemaining(), sib.bytesRemaining())));
                        }
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 6: {
                        if (!entry.isHash) {
                            assert (entry.content.length >= this.signatureSize);
                            if (!firstEntry) {
                                if (lastEntry.type != 0) {
                                    if (this.logger.level <= 900) {
                                        this.logger.log("Spurious EVT_SENDSIGN in snippet; flagging invalid");
                                    }
                                    return false;
                                }
                                EvtSendSign evtSendSign = new EvtSendSign(sib, this.signatureSize);
                                boolean sendWasHashed = lastEntry.isHash;
                                if (sendWasHashed) {
                                    byte[] actualHash = this.peerreview.hash(ByteBuffer.wrap(evtSendSign.restOfMessage));
                                    if (!Arrays.equals(lastEntry.content, actualHash)) {
                                        if (this.logger.level <= 900) {
                                            this.logger.log("EVT_SENDSIGN content does not match hash in EVT_SEND");
                                        }
                                        return false;
                                    }
                                } else if (entry.content.length > this.signatureSize) {
                                    if (this.logger.level <= 900) {
                                        this.logger.log("EVT_SENDSIGN contains extra bytes, but preceding EVT_SEND was not hashed");
                                    }
                                    return false;
                                }
                                SimpleOutputBuffer authPrefix = new SimpleOutputBuffer();
                                authPrefix.writeLong(lastEntry.seq);
                                authPrefix.write(prevNodeHash);
                                byte[] signedHash = this.peerreview.hash(authPrefix.getByteBuffer());
                                int verifyResult = this.peerreview.verify(this.peerreview.getIdentifierExtractor().extractIdentifier(subjectHandle), signedHash, evtSendSign.signature);
                                assert (verifyResult == 1 || verifyResult == 0);
                                if (verifyResult != 1) {
                                    if (this.logger.level <= 900) {
                                        this.logger.log("Signature in EVT_SENDSIGN does not match node hash of EVT_SEND");
                                    }
                                    return false;
                                }
                                if (commitmentProtocol != null && (flags & 2) == 2) {
                                    assert (!sendWasHashed);
                                    EvtSend<Identifier> evtSend = new EvtSend<Identifier>(new SimpleInputBuffer(lastEntry.content), this.idSerializer, this.hashSize);
                                    Object dest = evtSend.receiverId;
                                    if (dest.equals(this.peerreview.getLocalId())) {
                                        boolean previouslyReceived = false;
                                        if (seqBuf.contains(lastEntry.seq)) {
                                            previouslyReceived = true;
                                        }
                                        if (!previouslyReceived) {
                                            if (this.logger.level <= 400) {
                                                this.logger.log("XXX accepting new message " + lastEntry.seq);
                                            }
                                            SimpleOutputBuffer msg = new SimpleOutputBuffer();
                                            msg.write(evtSend.payload.array(), evtSend.payload.position(), evtSend.payload.remaining());
                                            msg.write(evtSendSign.restOfMessage);
                                            UserDataMessage<Handle> message = new UserDataMessage<Handle>(lastEntry.seq, subjectHandle, prevPrevNodeHash, evtSendSign.signature, msg.getByteBuffer(), evtSend.payload.remaining());
                                            commitmentProtocol.handleIncomingMessage(subjectHandle, message, null);
                                        }
                                    }
                                }
                            }
                        }
                        break;
                    }
                    case 2: {
                        assert (entry.content.length == this.hashSize + this.signatureSize);
                        if (!firstEntry) {
                            byte[] senderContentHash;
                            Authenticator senderAuth;
                            boolean isGoodAuth;
                            if (lastEntry.type != 1) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("Spurious EVT_SIGN in snippet; flagging invalid");
                                }
                                return false;
                            }
                            EvtSign evtSign = new EvtSign(sib, this.hashSize, this.signatureSize);
                            EvtRecv<Handle> evtRecv = new EvtRecv<Handle>(new SimpleInputBuffer(lastEntry.content), this.handleSerializer, this.hashSize);
                            Handle senderHandle = evtRecv.getSenderHandle();
                            long senderSeq = evtRecv.getSenderSeq();
                            SimpleOutputBuffer sob = new SimpleOutputBuffer();
                            RawSerializable senderId = (RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(senderHandle);
                            RawSerializable subjectId = (RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(subjectHandle);
                            subjectId.serialize(sob);
                            sob.writeBoolean(evtRecv.getHash() != null);
                            sob.write(evtRecv.getPayload());
                            if (evtRecv.getHash() != null) {
                                sob.write(evtRecv.getHash());
                            }
                            if (!(isGoodAuth = this.peerreview.addAuthenticatorIfValid(authStoreOrNull, senderId, senderAuth = this.peerreview.extractAuthenticator(senderSeq, (short)0, senderContentHash = this.peerreview.hash(sob.getByteBuffer()), evtSign.hTopMinusOne, evtSign.signature)))) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("Snippet contains a RECV from " + senderHandle + " whose signature does not match; flagging invalid");
                                }
                                return false;
                            }
                        }
                        break;
                    }
                    case 3: {
                        EvtAck<Identifier> evtAck = new EvtAck<Identifier>(sib, this.idSerializer, this.hashSize, this.signatureSize);
                        SendEntryRecord seidx = (SendEntryRecord)secache.get(evtAck.getAckedSeq());
                        if (seidx == null) break;
                        secache.remove(evtAck.getAckedSeq());
                        SimpleOutputBuffer sob = new SimpleOutputBuffer();
                        subjectHandle.serialize(sob);
                        sob.writeLong(evtAck.getAckedSeq());
                        byte[] receiverContentHash = this.peerreview.hash(sob.getByteBuffer(), seidx.hashedPlusPayload);
                        byte[] h = this.peerreview.hash(evtAck.getHisSeq(), (short)1, evtAck.getHTopMinusOne(), receiverContentHash);
                        Authenticator receiverAuth = new Authenticator(evtAck.getHisSeq(), h, evtAck.getSignature());
                        boolean isGoodAuth = this.peerreview.addAuthenticatorIfValid(authStoreOrNull, evtAck.getRemoteId(), receiverAuth);
                        if (!isGoodAuth) {
                            if (this.logger.level <= 900) {
                                this.logger.log("Snippet contains an ACK from " + evtAck.getRemoteId() + " whose signature does not match; flagging invalid");
                            }
                            return false;
                        }
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        assert (entry.type > 9);
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                if (this.logger.level <= 900) {
                    this.logger.logException("Error verifying SnippitEntry " + entry, ioe);
                }
                return false;
            }
            lastEntry = entry;
            if (keyNodeHash != null && !keyNodeFound && Arrays.equals(currentNodeHash, keyNodeHash)) {
                keyNodeFound = true;
            }
            if (!firstEntry) continue;
            if (startWithCheckpoint) {
                if (entry.type != 4 && entry.type != 5) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Previous checkpoint requested, but not included; flagging invalid");
                    }
                    return false;
                }
                if (entry.isHash) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Previous checkpoint requested, but only hash is included; flagging invalid");
                    }
                    return false;
                }
            }
            firstEntry = false;
        }
        if (lastEntry.type == 1) {
            if (this.logger.level <= 900) {
                this.logger.log("Log snippet ends with a RECV event; missing mandatory SIGN");
            }
            return false;
        }
        if (lastEntry.type == 0) {
            if (this.logger.level <= 900) {
                this.logger.log("Log snippet ends with a SEND event; missing mandatory SENDSIGN");
            }
            return false;
        }
        if (keyNodeHash != null && !keyNodeFound) {
            if (this.logger.level <= 900) {
                this.logger.log("Key node not found in log snippet; flagging invalid");
            }
            return false;
        }
        return true;
    }

    static class SendEntryRecord {
        long seq;
        ByteBuffer hashedPlusPayload;

        public SendEntryRecord(long seq, ByteBuffer hashedPlusPayload) {
            this.seq = seq;
            this.hashedPlusPayload = hashedPlusPayload;
        }
    }
}

