/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.liveness;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessTransportLayer;
import org.mpisws.p2p.transport.liveness.LivenessTypes;
import org.mpisws.p2p.transport.liveness.OverrideLiveness;
import org.mpisws.p2p.transport.liveness.PingListener;
import org.mpisws.p2p.transport.liveness.PingMessage;
import org.mpisws.p2p.transport.liveness.PongMessage;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.time.TimeSource;
import rice.p2p.util.TimerWeakHashMap;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.selector.Timer;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivenessTransportLayerImpl<Identifier>
implements LivenessTypes,
LivenessTransportLayer<Identifier, ByteBuffer>,
TransportLayerCallback<Identifier, ByteBuffer>,
OverrideLiveness<Identifier> {
    public final int PING_DELAY;
    public final float PING_JITTER;
    public final int NUM_PING_TRIES;
    public final long BACKOFF_INITIAL;
    public final int BACKOFF_LIMIT;
    public long CHECK_DEAD_THROTTLE;
    public int DEFAULT_RTO;
    int RTO_UBOUND;
    int RTO_LBOUND;
    double gainH;
    double gainG;
    protected TransportLayer<Identifier, ByteBuffer> tl;
    protected Logger logger;
    protected Environment environment;
    protected TimeSource time;
    protected Timer timer;
    protected Random random;
    public static final byte HDR_NORMAL = 0;
    public static final byte HDR_PING = 1;
    public static final byte HDR_PONG = 2;
    Map<Identifier, EntityManager> managers;
    private TransportLayerCallback<Identifier, ByteBuffer> callback;
    private ErrorHandler<Identifier> errorHandler;
    boolean connectionExceptionMeansFaulty = true;
    boolean destroyed = false;
    List<LivenessListener<Identifier>> livenessListeners;
    List<PingListener<Identifier>> pingListeners;

    public LivenessTransportLayerImpl(TransportLayer<Identifier, ByteBuffer> tl, Environment env, ErrorHandler<Identifier> errorHandler, int checkDeadThrottle) {
        this.tl = tl;
        this.environment = env;
        this.logger = env.getLogManager().getLogger(LivenessTransportLayerImpl.class, null);
        this.time = env.getTimeSource();
        this.timer = env.getSelectorManager().getTimer();
        this.random = new Random();
        this.livenessListeners = new ArrayList<LivenessListener<Identifier>>();
        this.pingListeners = new ArrayList<PingListener<Identifier>>();
        this.managers = new TimerWeakHashMap<Identifier, EntityManager>(env.getSelectorManager(), 300000);
        Parameters p = env.getParameters();
        this.PING_DELAY = p.getInt("pastry_socket_scm_ping_delay");
        this.PING_JITTER = p.getFloat("pastry_socket_scm_ping_jitter");
        this.NUM_PING_TRIES = p.getInt("pastry_socket_scm_num_ping_tries");
        this.BACKOFF_INITIAL = p.getInt("pastry_socket_scm_backoff_initial");
        this.BACKOFF_LIMIT = p.getInt("pastry_socket_scm_backoff_limit");
        this.CHECK_DEAD_THROTTLE = checkDeadThrottle;
        this.DEFAULT_RTO = p.getInt("pastry_socket_srm_default_rto");
        this.RTO_UBOUND = p.getInt("pastry_socket_srm_rto_ubound");
        this.RTO_LBOUND = p.getInt("pastry_socket_srm_rto_lbound");
        this.gainH = p.getDouble("pastry_socket_srm_gain_h");
        this.gainG = p.getDouble("pastry_socket_srm_gain_g");
        tl.setCallback(this);
        this.errorHandler = errorHandler;
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler(this.logger);
        }
    }

    @Override
    public void clearState(Identifier i) {
        if (this.logger.level <= 500) {
            this.logger.log("clearState(" + i + ")");
        }
        this.deleteManager(i);
    }

    @Override
    public boolean checkLiveness(Identifier i, Map<String, Object> options) {
        return this.getManager(i).checkLiveness(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P2PSocket<Identifier> getLSocket(P2PSocket<Identifier> s, EntityManager manager) {
        LSocket sock = new LSocket(manager, s, manager.identifier.get());
        Set<LSocket> set = manager.sockets;
        synchronized (set) {
            manager.sockets.add(sock);
        }
        return sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManager getManager(Identifier i) {
        Map<Identifier, EntityManager> map = this.managers;
        synchronized (map) {
            EntityManager manager = this.managers.get(i);
            if (manager == null) {
                manager = new EntityManager(i);
                this.managers.put(i, manager);
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManager deleteManager(Identifier i) {
        Map<Identifier, EntityManager> map = this.managers;
        synchronized (map) {
            EntityManager manager = this.managers.remove(i);
            if (manager != null && manager.getPending() != null) {
                manager.getPending().cancel();
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLiveness(Identifier i, Map<String, Object> options) {
        if (this.logger.level <= 300) {
            this.logger.log("getLiveness(" + i + "," + options + ")");
        }
        Map<Identifier, EntityManager> map = this.managers;
        synchronized (map) {
            if (this.managers.containsKey(i)) {
                return this.managers.get(i).liveness;
            }
        }
        return 2;
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    public void connectionExceptionMeansFaulty(boolean b) {
        this.connectionExceptionMeansFaulty = b;
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(final Identifier i, final SocketCallback<Identifier> deliverSocketToMe, final Map<String, Object> options) {
        if (this.logger.level <= 750) {
            this.logger.log("openSocket(" + i + "," + deliverSocketToMe + "," + options + ")");
        }
        return this.tl.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                deliverSocketToMe.receiveResult(cancellable, LivenessTransportLayerImpl.this.getLSocket(sock, LivenessTransportLayerImpl.this.getManager(i)));
            }

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                if (LivenessTransportLayerImpl.this.connectionExceptionMeansFaulty && !(ex instanceof java.nio.channels.ClosedChannelException)) {
                    if (LivenessTransportLayerImpl.this.logger.level <= 400) {
                        LivenessTransportLayerImpl.this.logger.logException("Marking " + s + " dead due to exception opening socket.", ex);
                    }
                    LivenessTransportLayerImpl.this.getManager(i).markDead(options);
                }
                deliverSocketToMe.receiveException(s, ex);
            }
        }, options);
    }

    @Override
    public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(final Identifier i, ByteBuffer m, final MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        final MessageRequestHandleImpl<Identifier, ByteBuffer> handle = new MessageRequestHandleImpl<Identifier, ByteBuffer>(i, m, options);
        EntityManager mgr = this.getManager(i);
        if (mgr != null && mgr.liveness >= 3) {
            if (deliverAckToMe != null) {
                deliverAckToMe.sendFailed(handle, new NodeIsFaultyException(i, m));
            }
            return handle;
        }
        byte[] msgBytes = new byte[m.remaining() + 1];
        msgBytes[0] = 0;
        m.get(msgBytes, 1, m.remaining());
        ByteBuffer myMsg = ByteBuffer.wrap(msgBytes);
        handle.setSubCancellable(this.tl.sendMessage(i, myMsg, new MessageCallback<Identifier, ByteBuffer>(){

            @Override
            public void ack(MessageRequestHandle<Identifier, ByteBuffer> msg) {
                if (handle.getSubCancellable() != null && msg != handle.getSubCancellable()) {
                    throw new RuntimeException("msg != handle.getSubCancelable() (indicates a bug in the code) msg:" + msg + " sub:" + handle.getSubCancellable());
                }
                if (deliverAckToMe != null) {
                    deliverAckToMe.ack(handle);
                }
            }

            @Override
            public void sendFailed(MessageRequestHandle<Identifier, ByteBuffer> msg, Exception ex) {
                if (handle.getSubCancellable() != null && msg != handle.getSubCancellable()) {
                    throw new RuntimeException("msg != handle.getSubCancelable() (indicates a bug in the code) msg:" + msg + " sub:" + handle.getSubCancellable());
                }
                if (deliverAckToMe == null) {
                    LivenessTransportLayerImpl.this.errorHandler.receivedException(i, ex);
                } else {
                    deliverAckToMe.sendFailed(handle, ex);
                }
            }
        }, options));
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(Identifier i, ByteBuffer m, Map<String, Object> options) throws IOException {
        byte hdr = m.get();
        switch (hdr) {
            case 0: {
                if (this.logger.level <= 300) {
                    this.logger.log("messageReceived(" + i + "," + m + ")");
                }
                this.callback.messageReceived(i, m, options);
                return;
            }
            case 1: {
                if (this.logger.level <= 300) {
                    this.logger.log("messageReceived(" + i + ", PING)");
                }
                this.pong(i, m.getLong(), options);
                this.notifyPingListenersPing(i);
                return;
            }
            case 2: {
                if (this.logger.level <= 300) {
                    this.logger.log("messageReceived(" + i + ", PONG)");
                }
                EntityManager manager = this.getManager(i);
                long sendTime = m.getLong();
                int rtt = (int)(this.time.currentTimeMillis() - sendTime);
                if (rtt >= 0) {
                    manager.updateRTO(rtt);
                    boolean markAlive = false;
                    EntityManager entityManager = manager;
                    synchronized (entityManager) {
                        if (manager.getPending() != null) {
                            manager.getPending().pingResponse(sendTime, options);
                            markAlive = true;
                        }
                    }
                    manager.markAlive(options);
                    this.notifyPingListenersPong(i, rtt, options);
                } else {
                    if (this.logger.level <= 900) {
                        this.logger.log("I think the clock is fishy, rtt must be >= 0, was:" + rtt);
                    }
                    this.errorHandler.receivedUnexpectedData(i, m.array(), 0, null);
                }
                return;
            }
        }
        this.errorHandler.receivedUnexpectedData(i, m.array(), 0, null);
    }

    public boolean cancelLivenessCheck(Identifier i, Map<String, Object> options) {
        EntityManager manager = this.getManager(i);
        if (manager == null) {
            return false;
        }
        return this.cancelLivenessCheck(manager, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelLivenessCheck(EntityManager manager, Map<String, Object> options) {
        EntityManager entityManager = manager;
        synchronized (entityManager) {
            if (manager.getPending() != null) {
                manager.getPending().cancel();
                return true;
            }
        }
        manager.markAlive(options);
        return false;
    }

    public String toString() {
        return "LivenessTL{" + this.getLocalIdentifier() + "}";
    }

    @Override
    public boolean ping(final Identifier i, final Map<String, Object> options) {
        if (this.logger.level <= 400) {
            this.logger.log("ping(" + i + ")");
        }
        if (i.equals(this.tl.getLocalIdentifier())) {
            return false;
        }
        try {
            SimpleOutputBuffer sob = new SimpleOutputBuffer(1024);
            sob.writeByte((byte)1);
            final long now = this.time.currentTimeMillis();
            new PingMessage(now).serialize(sob);
            this.tl.sendMessage(i, ByteBuffer.wrap(sob.getBytes()), new MessageCallback<Identifier, ByteBuffer>(){

                @Override
                public void ack(MessageRequestHandle<Identifier, ByteBuffer> msg) {
                }

                @Override
                public void sendFailed(MessageRequestHandle<Identifier, ByteBuffer> msg, Exception reason) {
                    if (LivenessTransportLayerImpl.this.logger.level <= 400) {
                        LivenessTransportLayerImpl.this.logger.logException("ping(" + i + "," + now + "," + options + ") failed", reason);
                    } else if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                        LivenessTransportLayerImpl.this.logger.log("ping(" + i + "," + now + "," + options + ") failed " + reason);
                    }
                }
            }, options);
            return true;
        }
        catch (IOException ioe) {
            this.errorHandler.receivedException(i, ioe);
            return false;
        }
    }

    public void pong(final Identifier i, final long senderTime, final Map<String, Object> options) {
        if (this.logger.level <= 300) {
            this.logger.log("pong(" + i + "," + senderTime + ")");
        }
        try {
            SimpleOutputBuffer sob = new SimpleOutputBuffer(1024);
            sob.writeByte((byte)2);
            new PongMessage(senderTime).serialize(sob);
            this.tl.sendMessage(i, ByteBuffer.wrap(sob.getBytes()), new MessageCallback<Identifier, ByteBuffer>(){

                @Override
                public void ack(MessageRequestHandle<Identifier, ByteBuffer> msg) {
                }

                @Override
                public void sendFailed(MessageRequestHandle<Identifier, ByteBuffer> msg, Exception reason) {
                    if (LivenessTransportLayerImpl.this.logger.level <= 400) {
                        LivenessTransportLayerImpl.this.logger.logException("pong(" + i + "," + senderTime + "," + options + ") failed", reason);
                    } else if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                        LivenessTransportLayerImpl.this.logger.log("pong(" + i + "," + senderTime + "," + options + ") failed " + reason);
                    }
                }
            }, options);
        }
        catch (IOException ioe) {
            this.errorHandler.receivedException(i, ioe);
        }
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = this.errorHandler = handler;
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler(this.logger);
        }
    }

    @Override
    public void destroy() {
        if (this.logger.level <= 800) {
            this.logger.log("destroy()");
        }
        this.destroyed = true;
        this.tl.destroy();
        this.livenessListeners.clear();
        this.livenessListeners = null;
        this.pingListeners.clear();
        this.pingListeners = null;
        for (EntityManager em : this.managers.values()) {
            em.destroy();
        }
        this.managers.clear();
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        EntityManager m = this.getManager(s.getIdentifier());
        if (m.liveness > 2) {
            m.updated = 0L;
            m.checkLiveness(s.getOptions());
        }
        this.callback.incomingSocket(this.getLSocket(s, this.getManager(s.getIdentifier())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLivenessListener(LivenessListener<Identifier> name) {
        if (this.destroyed) {
            return;
        }
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            this.livenessListeners.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLivenessListener(LivenessListener<Identifier> name) {
        if (this.destroyed) {
            return true;
        }
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            return this.livenessListeners.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLivenessListeners(Identifier i, int liveness, Map<String, Object> options) {
        ArrayList<LivenessListener<Identifier>> temp;
        if (this.destroyed) {
            return;
        }
        if (this.logger.level <= 400) {
            this.logger.log("notifyLivenessListeners(" + i + "," + liveness + ")");
        }
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            temp = new ArrayList<LivenessListener<Identifier>>(this.livenessListeners);
        }
        for (LivenessListener livenessListener : temp) {
            livenessListener.livenessChanged(i, liveness, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPingListener(PingListener<Identifier> name) {
        List<PingListener<Identifier>> list = this.pingListeners;
        synchronized (list) {
            this.pingListeners.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePingListener(PingListener<Identifier> name) {
        List<PingListener<Identifier>> list = this.pingListeners;
        synchronized (list) {
            return this.pingListeners.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPingListenersPing(Identifier i) {
        ArrayList<PingListener<Identifier>> temp;
        List<PingListener<Identifier>> list = this.pingListeners;
        synchronized (list) {
            temp = new ArrayList<PingListener<Identifier>>(this.pingListeners);
        }
        for (PingListener pingListener : temp) {
            pingListener.pingReceived(i, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPingListenersPong(Identifier i, int rtt, Map<String, Object> options) {
        ArrayList<PingListener<Identifier>> temp;
        List<PingListener<Identifier>> list = this.pingListeners;
        synchronized (list) {
            temp = new ArrayList<PingListener<Identifier>>(this.pingListeners);
        }
        for (PingListener pingListener : temp) {
            pingListener.pingResponse(i, rtt, options);
        }
    }

    @Override
    public void setLiveness(Identifier i, int liveness, Map<String, Object> options) {
        EntityManager man = this.getManager(i);
        switch (liveness) {
            case 1: {
                man.markAlive(options);
                return;
            }
            case 2: {
                man.markSuspected(options);
                return;
            }
            case 3: {
                man.markDead(options);
                return;
            }
            case 4: {
                man.markDeadForever(options);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LSocket
    extends SocketWrapperSocket<Identifier, Identifier> {
        EntityManager manager;
        Identifier hardRef;
        TimerTask livenessCheckerTimer;
        boolean closed;

        public LSocket(EntityManager manager, P2PSocket<Identifier> socket, Identifier hardRef) {
            super(socket.getIdentifier(), socket, LivenessTransportLayerImpl.this.logger, LivenessTransportLayerImpl.this.errorHandler, socket.getOptions());
            this.closed = false;
            if (hardRef == null) {
                throw new IllegalArgumentException("hardRef == null " + manager + " " + socket);
            }
            this.manager = manager;
            this.hardRef = hardRef;
        }

        @Override
        public void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver<Identifier> receiver) {
            if (this.closed) {
                receiver.receiveException(this, new ClosedChannelException("Socket " + this + " is already closed."));
                return;
            }
            if (wantToWrite) {
                this.startLivenessCheckerTimer();
            }
            super.register(wantToRead, wantToWrite, receiver);
        }

        @Override
        public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
            EntityManager m = LivenessTransportLayerImpl.this.getManager(socket.getIdentifier());
            if (m.liveness > 2) {
                m.updated = 0L;
                m.checkLiveness(socket.getOptions());
            }
            if (canWrite) {
                this.stopLivenessCheckerTimer();
            }
            super.receiveSelectResult(socket, canRead, canWrite);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startLivenessCheckerTimer() {
            LSocket lSocket = this;
            synchronized (lSocket) {
                if (this.livenessCheckerTimer != null) {
                    return;
                }
                this.livenessCheckerTimer = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        LSocket lSocket = LSocket.this;
                        synchronized (lSocket) {
                            if (LSocket.this.livenessCheckerTimer == this) {
                                LSocket.this.livenessCheckerTimer = null;
                            }
                        }
                        LSocket.this.manager.checkLiveness(LSocket.this.options);
                    }
                };
            }
            if (this.logger.level <= 400) {
                this.logger.log("Checking liveness on " + this.manager.identifier.get() + " in " + this.manager.rto() + " millis if we don't write.");
            }
            LivenessTransportLayerImpl.this.timer.schedule(this.livenessCheckerTimer, this.manager.rto() * 4, 30000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopLivenessCheckerTimer() {
            LSocket lSocket = this;
            synchronized (lSocket) {
                if (this.livenessCheckerTimer != null) {
                    this.livenessCheckerTimer.cancel();
                }
                this.livenessCheckerTimer = null;
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.manager.removeSocket(this);
            super.close();
        }

        @Override
        public String toString() {
            return "LSocket{" + this.socket + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntityManager {
        int RTO;
        double RTT;
        double standardD;
        protected WeakReference<Identifier> identifier;
        protected int liveness;
        protected long updated;
        private DeadChecker pendingDeadchecker;
        protected Set<LSocket> sockets;

        public EntityManager(Identifier identifier) {
            this.RTO = LivenessTransportLayerImpl.this.DEFAULT_RTO;
            this.RTT = 0.0;
            this.standardD = (double)this.RTO / 4.0;
            if (identifier == null) {
                throw new IllegalArgumentException("identifier is null");
            }
            this.identifier = new WeakReference(identifier);
            this.liveness = 2;
            this.pendingDeadchecker = null;
            this.updated = 0L;
            this.sockets = new HashSet<LSocket>();
        }

        public DeadChecker getPending() {
            return this.pendingDeadchecker;
        }

        public void setPending(DeadChecker d) {
            this.pendingDeadchecker = d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSocket(LSocket socket) {
            Set<LSocket> set = this.sockets;
            synchronized (set) {
                this.sockets.remove(socket);
            }
        }

        public int rto() {
            return this.RTO;
        }

        protected void markAlive(Map<String, Object> options) {
            Object temp;
            boolean notify = false;
            if (this.liveness != 1) {
                notify = true;
            }
            this.liveness = 1;
            if (notify && (temp = this.identifier.get()) != null) {
                LivenessTransportLayerImpl.this.notifyLivenessListeners(temp, this.liveness, options);
            }
        }

        protected void markSuspected(Map<String, Object> options) {
            if (this.liveness > 2) {
                return;
            }
            boolean notify = false;
            if (this.liveness != 2) {
                notify = true;
            }
            this.liveness = 2;
            if (notify) {
                Object temp;
                if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                    LivenessTransportLayerImpl.this.logger.log(this + ".markSuspected() notify = true");
                }
                if ((temp = this.identifier.get()) != null) {
                    LivenessTransportLayerImpl.this.notifyLivenessListeners(temp, this.liveness, options);
                }
            }
        }

        protected void markDead(Map<String, Object> options) {
            boolean notify = false;
            if (this.liveness < 3) {
                notify = true;
            }
            if (LivenessTransportLayerImpl.this.logger.level <= 400) {
                LivenessTransportLayerImpl.this.logger.log(this + ".markDead() notify:" + notify);
            }
            this.markDeadHelper(3, options, notify);
        }

        protected void markDeadForever(Map<String, Object> options) {
            boolean notify = false;
            if (this.liveness < 4) {
                notify = true;
            }
            if (LivenessTransportLayerImpl.this.logger.level <= 400) {
                LivenessTransportLayerImpl.this.logger.log(this + ".markDeadForever() notify:" + notify);
            }
            this.markDeadHelper(4, options, notify);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void markDeadHelper(int liveness, Map<String, Object> options, boolean notify) {
            Object temp;
            this.liveness = liveness;
            if (this.getPending() != null) {
                this.getPending().cancel();
            }
            if (notify) {
                temp = this.identifier.get();
                if (temp != null) {
                    LivenessTransportLayerImpl.this.notifyLivenessListeners(temp, liveness, options);
                } else if (LivenessTransportLayerImpl.this.logger.level <= 900) {
                    LivenessTransportLayerImpl.this.logger.log("markDeadHelper(" + liveness + "," + options + "," + notify + ") temp == null!  Can't notify listeners!");
                }
            }
            Set<LSocket> set = this.sockets;
            synchronized (set) {
                temp = new ArrayList<LSocket>(this.sockets);
                this.sockets.clear();
            }
            for (LSocket sock : temp) {
                if (LivenessTransportLayerImpl.this.logger.level <= 800) {
                    LivenessTransportLayerImpl.this.logger.log("closing " + sock);
                }
                sock.close();
            }
        }

        private void updateRTO(long m) {
            if (m < 0L) {
                throw new IllegalArgumentException("rtt must be >= 0, was:" + m);
            }
            double err = (double)m - this.RTT;
            double absErr = err;
            if (absErr < 0.0) {
                absErr *= -1.0;
            }
            this.RTT += LivenessTransportLayerImpl.this.gainG * err;
            this.standardD += LivenessTransportLayerImpl.this.gainH * (absErr - this.standardD);
            this.RTO = (int)(this.RTT + 4.0 * this.standardD);
            if (this.RTO > LivenessTransportLayerImpl.this.RTO_UBOUND) {
                this.RTO = LivenessTransportLayerImpl.this.RTO_UBOUND;
            }
            if (this.RTO < LivenessTransportLayerImpl.this.RTO_LBOUND) {
                this.RTO = LivenessTransportLayerImpl.this.RTO_LBOUND;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean checkLiveness(final Map<String, Object> options) {
            if (LivenessTransportLayerImpl.this.logger.level <= 400) {
                LivenessTransportLayerImpl.this.logger.log(this + ".checkLiveness()");
            }
            boolean ret = false;
            int rto = LivenessTransportLayerImpl.this.DEFAULT_RTO;
            EntityManager entityManager = this;
            synchronized (entityManager) {
                if (this.getPending() != null) {
                    return this.liveness < 3;
                    {
                    }
                }
                long now = LivenessTransportLayerImpl.this.time.currentTimeMillis();
                if (this.liveness < 3 || this.updated < now - LivenessTransportLayerImpl.this.CHECK_DEAD_THROTTLE) {
                    this.updated = now;
                    rto = this.rto();
                    this.setPending(new DeadChecker(this, LivenessTransportLayerImpl.this.NUM_PING_TRIES, rto, options));
                    ret = true;
                } else if (LivenessTransportLayerImpl.this.logger.level <= 400) {
                    LivenessTransportLayerImpl.this.logger.log(this + ".checkLiveness() not checking " + this.identifier.get() + " checked to recently, can't check for " + (this.updated + LivenessTransportLayerImpl.this.CHECK_DEAD_THROTTLE - now) + " millis.");
                }
            }
            if (ret) {
                final int theRTO = rto;
                Runnable r = new Runnable(){

                    public void run() {
                        if (EntityManager.this.getPending() == null) {
                            return;
                        }
                        LivenessTransportLayerImpl.this.timer.schedule(EntityManager.this.getPending(), theRTO);
                        Object temp = EntityManager.this.identifier.get();
                        if (temp != null) {
                            LivenessTransportLayerImpl.this.ping(temp, options);
                        }
                    }

                    public String toString() {
                        return EntityManager.this.toString();
                    }
                };
                if (LivenessTransportLayerImpl.this.environment.getSelectorManager().isSelectorThread()) {
                    r.run();
                } else {
                    LivenessTransportLayerImpl.this.environment.getSelectorManager().invoke(r);
                }
            }
            if (this.liveness >= 3) {
                return false;
            }
            return ret;
        }

        public String toString() {
            Object temp = this.identifier.get();
            if (temp == null) {
                return "null";
            }
            return temp.toString();
        }

        public void destroy() {
            if (this.getPending() != null) {
                this.getPending().cancel();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DeadChecker
    extends TimerTask {
        protected int tries = 1;
        protected int numTries;
        protected EntityManager manager;
        long startTime;
        int initialDelay;
        Map<String, Object> options;

        public DeadChecker(EntityManager manager, int numTries, int initialDelay, Map<String, Object> options) {
            if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                LivenessTransportLayerImpl.this.logger.log("DeadChecker@" + System.identityHashCode(this) + " CHECKING DEATH OF PATH " + manager.identifier.get() + " rto:" + initialDelay + " options:" + options);
            }
            this.manager = manager;
            this.numTries = numTries;
            this.options = options;
            this.initialDelay = initialDelay;
            this.startTime = LivenessTransportLayerImpl.this.time.currentTimeMillis();
        }

        public void pingResponse(long RTT, Map<String, Object> options) {
            if (!this.cancelled && this.tries > 1) {
                long delay = LivenessTransportLayerImpl.this.time.currentTimeMillis() - this.startTime;
                if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                    LivenessTransportLayerImpl.this.logger.log("DeadChecker.pingResponse(" + this.manager.identifier.get() + ") tries=" + this.tries + " estimated=" + this.initialDelay + " totalDelay=" + delay);
                }
            }
            if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                LivenessTransportLayerImpl.this.logger.log("Terminated DeadChecker@" + System.identityHashCode(this) + "(" + this.manager.identifier.get() + ") due to ping.");
            }
            this.cancel();
        }

        @Override
        public void run() {
            if (LivenessTransportLayerImpl.this.destroyed) {
                return;
            }
            if (this.tries < this.numTries) {
                ++this.tries;
                this.manager.markSuspected(this.options);
                Object temp = this.manager.identifier.get();
                if (temp != null) {
                    if (LivenessTransportLayerImpl.this.logger.level <= 400) {
                        LivenessTransportLayerImpl.this.logger.log("DeadChecker@" + System.identityHashCode(this) + "(" + temp + ") pinging " + this.tries + " " + this.manager.getPending());
                    }
                    LivenessTransportLayerImpl.this.ping(temp, this.options);
                }
                int absPD = (int)((double)LivenessTransportLayerImpl.this.PING_DELAY * Math.pow(2.0, this.tries - 1));
                int jitterAmt = (int)((float)absPD * LivenessTransportLayerImpl.this.PING_JITTER);
                int scheduledTime = absPD - jitterAmt + LivenessTransportLayerImpl.this.random.nextInt(jitterAmt * 2);
                LivenessTransportLayerImpl.this.timer.schedule(this, scheduledTime);
            } else {
                if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                    LivenessTransportLayerImpl.this.logger.log("DeadChecker@" + System.identityHashCode(this) + "(" + this.manager.identifier.get() + ") expired - marking as dead.");
                }
                this.manager.markDead(this.options);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            EntityManager entityManager = this.manager;
            synchronized (entityManager) {
                this.manager.setPending(null);
            }
            return super.cancel();
        }

        public String toString() {
            return "DeadChecker(" + this.manager.identifier.get() + " #" + System.identityHashCode(this) + "):" + this.tries + "/" + this.numTries;
        }
    }
}

