/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.limitsockets;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.selector.Timer;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitSocketsTransportLayer<Identifier, MessageType>
implements TransportLayer<Identifier, MessageType>,
TransportLayerCallback<Identifier, MessageType> {
    int MAX_SOCKETS;
    protected TransportLayer<Identifier, MessageType> tl;
    protected LinkedHashMap<LSSocket, LSSocket> cache;
    protected Logger logger;
    protected TransportLayerCallback<Identifier, MessageType> callback;
    protected Timer timer;
    protected ErrorHandler<Identifier> handler;

    public LimitSocketsTransportLayer(int max_sockets, TransportLayer<Identifier, MessageType> tl, ErrorHandler<Identifier> handler, Environment env) {
        this.MAX_SOCKETS = max_sockets;
        this.tl = tl;
        this.logger = env.getLogManager().getLogger(LimitSocketsTransportLayer.class, null);
        this.timer = env.getSelectorManager().getTimer();
        this.cache = new LinkedHashMap(this.MAX_SOCKETS, 0.75f, true);
        this.handler = handler;
        if (this.handler == null) {
            this.handler = new DefaultErrorHandler(this.logger);
        }
        tl.setCallback(this);
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(final Identifier i, final SocketCallback<Identifier> deliverSocketToMe, final Map<String, Object> options) {
        if (this.logger.level <= 400) {
            this.logger.logException(this + ".openSocket(" + i + "," + deliverSocketToMe + "," + options + ")", new Exception("Stack Trace"));
        }
        final SocketRequestHandleImpl ret = new SocketRequestHandleImpl<Identifier>(i, options, this.logger){

            @Override
            public boolean cancel() {
                if (LimitSocketsTransportLayer.this.logger.level <= 400) {
                    LimitSocketsTransportLayer.this.logger.log(this + ".openSocket(" + i + "," + deliverSocketToMe + "):" + this + ".cancel()");
                }
                return super.cancel();
            }

            @Override
            public String toString() {
                return LimitSocketsTransportLayer.this + "RequestHandle.openSocket(" + i + "," + deliverSocketToMe + "," + options + ")";
            }
        };
        ret.setSubCancellable(this.tl.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                if (LimitSocketsTransportLayer.this.logger.level <= 400) {
                    LimitSocketsTransportLayer.this.logger.log(this + ".openSocket(" + i + "," + deliverSocketToMe + "):" + ret + ".receiveResult()");
                }
                deliverSocketToMe.receiveResult(ret, LimitSocketsTransportLayer.this.getLSSock(sock));
            }

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                if (LimitSocketsTransportLayer.this.logger.level <= 400) {
                    LimitSocketsTransportLayer.this.logger.log(this + ".openSocket(" + i + "," + deliverSocketToMe + "):" + ret + ".receiveException(" + ex + ")");
                }
                deliverSocketToMe.receiveException(ret, ex);
            }

            public String toString() {
                return LimitSocketsTransportLayer.this + "SocketCallback.openSocket(" + i + "," + deliverSocketToMe + "," + options + ")";
            }
        }, options));
        return ret;
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        if (this.logger.level <= 400) {
            this.logger.log(this + ".incomingSocket(" + s + ")");
        }
        this.callback.incomingSocket(this.getLSSock(s));
    }

    protected LSSocket getLSSock(P2PSocket<Identifier> sock) {
        LSSocket ret = new LSSocket(sock);
        this.cache.put(ret, ret);
        this.closeIfNecessary();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeIfNecessary() {
        ArrayList<LSSocket> closeMe = new ArrayList<LSSocket>();
        LinkedHashMap<LSSocket, LSSocket> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            while (this.cache.size() > this.MAX_SOCKETS) {
                Iterator<LSSocket> i = this.cache.keySet().iterator();
                closeMe.add(i.next());
                i.remove();
            }
        }
        for (LSSocket sock : closeMe) {
            sock.forceClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(LSSocket socket) {
        LinkedHashMap<LSSocket, LSSocket> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            if (this.cache.get(socket) == null) {
                this.cache.put(socket, socket);
                this.closeIfNecessary();
            }
        }
    }

    public String toString() {
        return "LimitSocks<" + this.cache.size() + ">";
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public MessageRequestHandle<Identifier, MessageType> sendMessage(Identifier i, MessageType m, MessageCallback<Identifier, MessageType> deliverAckToMe, Map<String, Object> options) {
        return this.tl.sendMessage(i, m, deliverAckToMe, options);
    }

    @Override
    public void messageReceived(Identifier i, MessageType m, Map<String, Object> options) throws IOException {
        this.callback.messageReceived(i, m, options);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, MessageType> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.handler = handler;
        this.tl.setErrorHandler(handler);
    }

    @Override
    public void destroy() {
        this.tl.destroy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LSSocket
    extends SocketWrapperSocket<Identifier, Identifier> {
        boolean closed;
        boolean forcedClose;

        public LSSocket(P2PSocket<Identifier> socket) {
            super(socket.getIdentifier(), socket, LimitSocketsTransportLayer.this.logger, LimitSocketsTransportLayer.this.handler, socket.getOptions());
            this.closed = false;
            this.forcedClose = false;
        }

        public void forceClose() {
            if (this.logger.level <= 500) {
                this.logger.log(this + ".forceClose()");
            }
            this.forcedClose = true;
            super.shutdownOutput();
            LimitSocketsTransportLayer.this.timer.schedule(new TimerTask(){

                public void run() {
                    try {
                        LSSocket.this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 3000L);
        }

        @Override
        public void close() {
            if (this.logger.level <= 400) {
                this.logger.log(this + ".close()");
            }
            this.closed = true;
            LimitSocketsTransportLayer.this.cache.remove(this);
            super.close();
        }

        @Override
        public long read(ByteBuffer dsts) throws IOException {
            if (!this.closed) {
                LimitSocketsTransportLayer.this.touch(this);
            }
            try {
                return super.read(dsts);
            }
            catch (IOException ioe) {
                this.close();
                throw ioe;
            }
        }

        @Override
        public void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver<Identifier> receiver) {
            if (this.forcedClose) {
                if (wantToWrite) {
                    receiver.receiveException(this, new ClosedChannelException("Limit Sockets forced close. " + this));
                }
                if (wantToRead) {
                    super.register(true, false, receiver);
                }
                return;
            }
            if (!this.closed) {
                LimitSocketsTransportLayer.this.touch(this);
            }
            super.register(wantToRead, wantToWrite, receiver);
        }

        @Override
        public long write(ByteBuffer srcs) throws IOException {
            if (this.forcedClose) {
                throw new ClosedChannelException("Limit Sockets forced close. " + this);
            }
            if (!this.closed) {
                LimitSocketsTransportLayer.this.touch(this);
            }
            try {
                return super.write(srcs);
            }
            catch (IOException ioe) {
                this.close();
                throw ioe;
            }
        }

        @Override
        public String toString() {
            return LimitSocketsTransportLayer.this.toString() + "$LSSocket<" + this.identifier + ">[" + (this.closed ? "closed" : "open") + "]@" + System.identityHashCode(this) + this.socket.toString();
        }
    }
}

