/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.commonapi;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.commonapi.CommonAPITransportLayer;
import org.mpisws.p2p.transport.commonapi.IdFactory;
import org.mpisws.p2p.transport.commonapi.OptionsAdder;
import org.mpisws.p2p.transport.commonapi.RawMessageDeserializer;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.priority.QueueOverflowException;
import org.mpisws.p2p.transport.util.DefaultCallback;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.OptionsFactory;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonAPITransportLayerImpl<Identifier extends NodeHandle>
implements CommonAPITransportLayer<Identifier>,
TransportLayerCallback<Identifier, ByteBuffer> {
    TransportLayer<Identifier, ByteBuffer> tl;
    TransportLayerCallback<Identifier, RawMessage> callback;
    ErrorHandler<Identifier> errorHandler;
    RawMessageDeserializer deserializer;
    IdFactory idFactory;
    Logger logger;
    public static final String MSG_CLASS = "commonapi_msg_class";
    public static final String MSG_STRING = "commonapi_msg_string";
    public static final String MSG_TYPE = "commonapi_msg_type";
    public static final String MSG_ADDR = "commonapi_msg_addr";
    protected OptionsAdder optionsAdder;
    protected boolean destroyed = false;

    public CommonAPITransportLayerImpl(TransportLayer<Identifier, ByteBuffer> tl, IdFactory idFactory, RawMessageDeserializer deserializer, OptionsAdder optionsAdder, ErrorHandler<Identifier> errorHandler, Environment env) {
        this.logger = env.getLogManager().getLogger(CommonAPITransportLayerImpl.class, null);
        this.tl = tl;
        this.deserializer = deserializer;
        this.optionsAdder = optionsAdder;
        if (this.optionsAdder == null) {
            this.optionsAdder = new OptionsAdder(){

                @Override
                public Map<String, Object> addOptions(Map<String, Object> options, RawMessage m) {
                    return OptionsFactory.addOption(options, CommonAPITransportLayerImpl.MSG_STRING, m.toString(), CommonAPITransportLayerImpl.MSG_TYPE, m.getType(), CommonAPITransportLayerImpl.MSG_CLASS, m.getClass().getName());
                }
            };
        }
        if (tl == null) {
            throw new IllegalArgumentException("tl must be non-null");
        }
        if (idFactory == null) {
            throw new IllegalArgumentException("idFactroy must be non-null");
        }
        if (deserializer == null) {
            throw new IllegalArgumentException("deserializer must be non-null");
        }
        this.idFactory = idFactory;
        this.errorHandler = errorHandler;
        if (this.callback == null) {
            this.callback = new DefaultCallback<Identifier, RawMessage>(env);
        }
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler(this.logger);
        }
        tl.setCallback(this);
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return (Identifier)((NodeHandle)this.tl.getLocalIdentifier());
    }

    @Override
    public MessageRequestHandle<Identifier, RawMessage> sendMessage(Identifier i, RawMessage m, MessageCallback<Identifier, RawMessage> deliverAckToMe, Map<String, Object> options) {
        if (this.destroyed) {
            return null;
        }
        if (this.logger.level <= 500) {
            this.logger.log("sendMessage(" + i + "," + m + ")");
        }
        MessageRequestHandleImpl<Identifier, RawMessage> handle = new MessageRequestHandleImpl<Identifier, RawMessage>(i, m, options);
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        try {
            this.deserializer.serialize(m, sob);
        }
        catch (IOException ioe2) {
            NodeIsFaultyException ioe2;
            if (ioe2 instanceof NodeIsFaultyException) {
                ioe2 = new NodeIsFaultyException(i, m, ioe2);
            }
            if (deliverAckToMe == null) {
                this.errorHandler.receivedException(i, ioe2);
            } else {
                deliverAckToMe.sendFailed(handle, ioe2);
            }
            return handle;
        }
        ByteBuffer buf = ByteBuffer.wrap(sob.getBytes());
        if (this.logger.level <= 300) {
            this.logger.log("sendMessage(" + i + "," + m + ") serizlized:" + buf);
        }
        handle.setSubCancellable(this.tl.sendMessage(i, buf, new MessageCallback<Identifier, ByteBuffer>((NodeHandle)i, m, handle, deliverAckToMe){
            final /* synthetic */ NodeHandle val$i;
            final /* synthetic */ RawMessage val$m;
            final /* synthetic */ MessageRequestHandleImpl val$handle;
            final /* synthetic */ MessageCallback val$deliverAckToMe;
            {
                this.val$i = nodeHandle;
                this.val$m = rawMessage;
                this.val$handle = messageRequestHandleImpl;
                this.val$deliverAckToMe = messageCallback;
            }

            @Override
            public void ack(MessageRequestHandle<Identifier, ByteBuffer> msg) {
                if (CommonAPITransportLayerImpl.this.logger.level <= 400) {
                    CommonAPITransportLayerImpl.this.logger.log("sendMessage(" + this.val$i + "," + this.val$m + ").ack()");
                }
                if (this.val$handle.getSubCancellable() != null && msg != this.val$handle.getSubCancellable()) {
                    throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + this.val$handle.getSubCancellable());
                }
                if (this.val$deliverAckToMe != null) {
                    this.val$deliverAckToMe.ack(this.val$handle);
                }
            }

            @Override
            public void sendFailed(MessageRequestHandle<Identifier, ByteBuffer> msg, Exception ex) {
                if (ex instanceof NodeIsFaultyException) {
                    ex = new NodeIsFaultyException(this.val$i, this.val$m, ex);
                }
                if (ex instanceof QueueOverflowException) {
                    ex = new QueueOverflowException(this.val$i, this.val$m, ex);
                }
                if (CommonAPITransportLayerImpl.this.logger.level <= 700) {
                    CommonAPITransportLayerImpl.this.logger.logException("sendFailed(" + this.val$i + "," + this.val$m + ")", ex);
                }
                if (this.val$handle.getSubCancellable() != null && msg != this.val$handle.getSubCancellable()) {
                    throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + this.val$handle.getSubCancellable());
                }
                if (this.val$deliverAckToMe == null) {
                    CommonAPITransportLayerImpl.this.errorHandler.receivedException(this.val$i, ex);
                } else {
                    this.val$deliverAckToMe.sendFailed(this.val$handle, ex);
                }
            }
        }, this.optionsAdder.addOptions(options, m)));
        return handle;
    }

    @Override
    public void messageReceived(Identifier i, ByteBuffer m, Map<String, Object> options) throws IOException {
        SimpleInputBuffer buf = new SimpleInputBuffer(m.array(), m.position());
        RawMessage ret = this.deserializer.deserialize(buf, (NodeHandle)i);
        if (this.logger.level <= 500) {
            this.logger.log("messageReceived(" + i + "," + ret + ")");
        }
        this.callback.messageReceived(i, ret, options);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, RawMessage> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        this.tl.destroy();
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(Identifier i, SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        if (deliverSocketToMe == null) {
            throw new IllegalArgumentException("deliverSocketToMe must be non-null!");
        }
        if (this.logger.level <= 500) {
            this.logger.log("openSocket(" + i + ")");
        }
        return this.tl.openSocket(i, deliverSocketToMe, options);
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("incomingSocket(" + s + ")");
        }
        this.callback.incomingSocket(s);
    }
}

