/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.bandwidthmeasure;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.time.TimeSource;
import rice.p2p.util.tuples.Tuple;
import rice.p2p.util.tuples.Tuple3;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BandwidthMeasuringTransportLayer<Identifier>
implements TransportLayer<Identifier, ByteBuffer>,
TransportLayerCallback<Identifier, ByteBuffer> {
    TransportLayer<Identifier, ByteBuffer> tl;
    TransportLayerCallback<Identifier, ByteBuffer> callback;
    Logger logger;
    ErrorHandler<Identifier> errorHandler;
    int measurementPeriod = 5000;
    public static final int CUR_DOWN = 0;
    public static final int CUR_UP = 1;
    public static final int CUR_SATURATED = 2;
    public static final int LAST_DOWN = 3;
    public static final int LAST_UP = 4;
    public static final int LAST_SATURATED = 5;
    public static final int NUM_VALS = 6;
    public static final int SATURATED = 1;
    public static final int NOT_SATURATED = 0;
    Map<Identifier, Tuple<int[], Collection<MySocket>>> measured = new HashMap<Identifier, Tuple<int[], Collection<MySocket>>>();
    protected TimeSource time;
    long lastMeasure;

    public BandwidthMeasuringTransportLayer(int measurementPeriod, TransportLayer<Identifier, ByteBuffer> tl, Environment env) {
        this.tl = tl;
        tl.setCallback(this);
        this.measurementPeriod = measurementPeriod;
        this.logger = env.getLogManager().getLogger(BandwidthMeasuringTransportLayer.class, null);
        this.errorHandler = new DefaultErrorHandler(this.logger);
        this.time = env.getTimeSource();
        this.lastMeasure = this.time.currentTimeMillis();
        env.getSelectorManager().schedule(new TimerTask(){

            public void run() {
                BandwidthMeasuringTransportLayer.this.measure();
            }
        }, measurementPeriod, measurementPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void measure() {
        Map<Identifier, Tuple<int[], Collection<MySocket>>> map = this.measured;
        synchronized (map) {
            long now = this.time.currentTimeMillis();
            int diff = (int)(now - this.lastMeasure);
            this.lastMeasure = now;
            block3: for (Identifier i : this.measured.keySet()) {
                Tuple<int[], Collection<MySocket>> t = this.measured.get(i);
                int[] vals = t.a();
                vals[3] = vals[0] * 1000 / diff;
                vals[4] = vals[1] * 1000 / diff;
                vals[5] = vals[2];
                vals[0] = 0;
                vals[1] = 0;
                vals[2] = 0;
                if (vals[5] != 0) continue;
                for (MySocket s : t.b()) {
                    if (!s.wantsToWrite()) continue;
                    vals[5] = 1;
                    continue block3;
                }
            }
        }
    }

    public Tuple<int[], Collection<MySocket>> getVals(Identifier i) {
        Tuple<int[], Collection<MySocket>> ret = this.measured.get(i);
        if (ret == null) {
            ret = new Tuple(new int[6], new ArrayList());
            this.measured.put(i, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Identifier, Tuple3<Integer, Integer, Boolean>> getBandwidthUsed() {
        Map<Identifier, Tuple<int[], Collection<MySocket>>> map = this.measured;
        synchronized (map) {
            HashMap<Identifier, Tuple3<Integer, Integer, Boolean>> ret = new HashMap<Identifier, Tuple3<Integer, Integer, Boolean>>();
            for (Identifier i : this.measured.keySet()) {
                Tuple<int[], Collection<MySocket>> t = this.measured.get(i);
                int[] vals = t.a();
                ret.put(i, new Tuple3<Integer, Integer, Boolean>(vals[3], vals[4], vals[5] == 1));
            }
            return ret;
        }
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        this.callback.incomingSocket(new MySocket(s.getIdentifier(), s, this.logger, this.errorHandler, s.getOptions()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(Identifier i, ByteBuffer m, Map<String, Object> options) throws IOException {
        Map<Identifier, Tuple<int[], Collection<MySocket>>> map = this.measured;
        synchronized (map) {
            int[] nArray = this.getVals(i).a();
            nArray[0] = nArray[0] + m.remaining();
        }
        this.callback.messageReceived(i, m, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(Identifier i, ByteBuffer m, MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        Map<Identifier, Tuple<int[], Collection<MySocket>>> map = this.measured;
        synchronized (map) {
            int[] nArray = this.getVals(i).a();
            nArray[1] = nArray[1] + m.remaining();
        }
        return this.tl.sendMessage(i, m, deliverAckToMe, options);
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(final Identifier i, final SocketCallback<Identifier> deliverSocketToMe, final Map<String, Object> options) {
        final SocketRequestHandleImpl<Identifier> ret = new SocketRequestHandleImpl<Identifier>(i, options, this.logger);
        ret.setSubCancellable(this.tl.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                deliverSocketToMe.receiveException(s, ex);
            }

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                deliverSocketToMe.receiveResult(ret, new MySocket(i, sock, BandwidthMeasuringTransportLayer.this.logger, BandwidthMeasuringTransportLayer.this.errorHandler, options));
            }
        }, options));
        return ret;
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
    }

    @Override
    public void destroy() {
        this.tl.destroy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MySocket
    extends SocketWrapperSocket<Identifier, Identifier> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Map map = BandwidthMeasuringTransportLayer.this.measured;
            synchronized (map) {
                BandwidthMeasuringTransportLayer.this.getVals(this.identifier).b().remove(this);
            }
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveException(P2PSocket<Identifier> socket, Exception e) {
            Map map = BandwidthMeasuringTransportLayer.this.measured;
            synchronized (map) {
                BandwidthMeasuringTransportLayer.this.getVals(this.identifier).b().remove(this);
            }
            super.receiveException(socket, e);
        }

        public boolean wantsToWrite() {
            return this.writer != null;
        }

        @Override
        public void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver<Identifier> receiver) {
            super.register(wantToRead, wantToWrite, receiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MySocket(Identifier identifier, P2PSocket<Identifier> socket, Logger logger, ErrorHandler<Identifier> errorHandler, Map<String, Object> options) {
            super(identifier, socket, logger, errorHandler, options);
            Map map = BandwidthMeasuringTransportLayer.this.measured;
            synchronized (map) {
                BandwidthMeasuringTransportLayer.this.getVals(identifier).b().add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long write(ByteBuffer srcs) throws IOException {
            long ret = super.write(srcs);
            Map map = BandwidthMeasuringTransportLayer.this.measured;
            synchronized (map) {
                int[] vals = BandwidthMeasuringTransportLayer.this.getVals(this.getIdentifier()).a();
                if (srcs.hasRemaining()) {
                    vals[2] = 1;
                }
                vals[1] = (int)((long)vals[1] + ret);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(ByteBuffer srcs) throws IOException {
            long ret = super.read(srcs);
            Map map = BandwidthMeasuringTransportLayer.this.measured;
            synchronized (map) {
                int[] vals = BandwidthMeasuringTransportLayer.this.getVals(this.getIdentifier()).a();
                vals[0] = (int)((long)vals[0] + ret);
            }
            return ret;
        }
    }
}

