/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer.replay;

import org.mpisws.p2p.testing.transportlayer.replay.MyScribeContent;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribeImpl;
import rice.p2p.scribe.Topic;
import rice.pastry.commonapi.PastryIdFactory;

public class MyScribeClient
implements ScribeClient,
Application {
    int seqNum = 0;
    CancellableTask publishTask;
    Scribe myScribe;
    Topic myTopic;
    Node node;
    protected Endpoint endpoint;
    protected Logger logger;

    public MyScribeClient(Node node) {
        this.node = node;
        this.logger = node.getEnvironment().getLogManager().getLogger(MyScribeClient.class, null);
        this.endpoint = node.buildEndpoint(this, "myinstance");
        this.myScribe = new ScribeImpl(node, "myScribeInstance");
        this.myTopic = new Topic(new PastryIdFactory(node.getEnvironment()), "example topic");
        this.endpoint.register();
    }

    public void subscribe() {
        this.myScribe.subscribe(this.myTopic, this);
    }

    public void startPublishTask() {
        this.publishTask = this.endpoint.scheduleMessage(new PublishContent(), 5000L, 5000L);
    }

    public void deliver(Id id, Message message) {
        if (message instanceof PublishContent) {
            this.sendMulticast();
            this.sendAnycast();
        }
    }

    public void sendMulticast() {
        System.out.println("Node " + this.endpoint.getLocalNodeHandle() + " broadcasting " + this.seqNum);
        MyScribeContent myMessage = new MyScribeContent(this.endpoint.getLocalNodeHandle(), this.seqNum);
        this.myScribe.publish(this.myTopic, myMessage);
        ++this.seqNum;
    }

    public void deliver(Topic topic, ScribeContent content) {
        this.logger.log("MyScribeClient.deliver(" + topic + "," + content + ")");
        if (((MyScribeContent)content).from == null) {
            new Exception("Stack Trace").printStackTrace();
        }
    }

    public void sendAnycast() {
        System.out.println("Node " + this.endpoint.getLocalNodeHandle() + " anycasting " + this.seqNum);
        MyScribeContent myMessage = new MyScribeContent(this.endpoint.getLocalNodeHandle(), this.seqNum);
        this.myScribe.anycast(this.myTopic, myMessage);
        ++this.seqNum;
    }

    public boolean anycast(Topic topic, ScribeContent content) {
        boolean returnValue = this.myScribe.getEnvironment().getRandomSource().nextInt(3) == 0;
        System.out.println("MyScribeClient.anycast(" + topic + "," + content + "):" + returnValue);
        return returnValue;
    }

    public void childAdded(Topic topic, NodeHandle child) {
    }

    public void childRemoved(Topic topic, NodeHandle child) {
    }

    public void subscribeFailed(Topic topic) {
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public boolean isRoot() {
        return this.myScribe.isRoot(this.myTopic);
    }

    public NodeHandle getParent() {
        return ((ScribeImpl)this.myScribe).getParent(this.myTopic);
    }

    public NodeHandle[] getChildren() {
        return this.myScribe.getChildren(this.myTopic);
    }

    class PublishContent
    implements Message {
        PublishContent() {
        }

        public int getPriority() {
            return -15;
        }
    }
}

