/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer.replay;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.mpisws.p2p.testing.transportlayer.replay.MyEvents;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.replay.BasicEntryDeserializer;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.util.rawserialization.SimpleInputBuffer;

public class MyEntryDeserializer
extends BasicEntryDeserializer
implements MyEvents {
    Serializer serializer;

    public MyEntryDeserializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public String entryId(short id) {
        String ret = super.entryId(id);
        if (ret != null) {
            return ret;
        }
        switch (id) {
            case 1001: {
                return "Boot";
            }
            case 1002: {
                return "Subscribe";
            }
            case 1003: {
                return "Publish";
            }
        }
        return null;
    }

    public String read(IndexEntry ie, SecureHistory history) throws IOException {
        DataInputStream nextEvent = null;
        if (ie.getSizeInFile() > 0) {
            nextEvent = new SimpleInputBuffer(history.getEntry(ie, ie.getSizeInFile()));
        }
        switch (ie.getType()) {
            case 31: {
                int socketId = nextEvent.readInt();
                byte[] addrBytes = new byte[4];
                nextEvent.read(addrBytes);
                InetSocketAddress addr = new InetSocketAddress(InetAddress.getByAddress(addrBytes), (int)nextEvent.readShort());
                return this.entryId(ie.getType()) + " socketId:" + socketId + " addr:" + addr;
            }
            case 32: {
                int socketId = nextEvent.readInt();
                return this.entryId(ie.getType()) + " socketId:" + socketId;
            }
            case 0: {
                SimpleInputBuffer buf = new SimpleInputBuffer(history.getEntry(ie, ie.getSizeInFile()));
                return this.entryId(ie.getType()) + " n:" + ie.getSeq() + " s:" + ie.getSizeInFile() + " i:" + ie.getFileIndex() + " ->" + this.serializer.deserialize(buf);
            }
        }
        return super.read(ie, history);
    }
}

