/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer.peerreview;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.testing.transportlayer.peerreview.PRRegressionTest;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.PeerReviewImpl;
import rice.environment.Environment;
import rice.p2p.util.MathUtils;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PRNonconform1
extends PRRegressionTest {
    public PRNonconform1() throws Exception {
        super(45000);
    }

    @Override
    public void finish() {
        try {
            if ((Integer)((Map)this.recordedStatus.get(this.aliceHandle)).get(this.bobHandle.id) != 2) {
                this.logger.log("Alice Didn't expose bob");
                System.exit(1);
            }
            if ((Integer)((Map)this.recordedStatus.get(this.carolHandle)).get(this.bobHandle.id) != 2) {
                this.logger.log("Carol Didn't expose bob");
                System.exit(1);
            }
        }
        catch (Exception e) {
            this.logger.logException("Failure", e);
            System.exit(1);
        }
        this.logger.log("Success");
        System.exit(0);
    }

    @Override
    public PRRegressionTest.BogusApp getBogusApp(PRRegressionTest.Player player, PeerReview<PRRegressionTest.HandleImpl, PRRegressionTest.IdImpl> pr, Environment env) {
        return new PRRegressionTest.BogusApp(player, pr, env){

            @Override
            public void init() {
                super.init();
                if (this.player.localHandle.id.id == 2) {
                    this.env.getSelectorManager().schedule(new TimerTask(){

                        public void run() {
                            this.sendMessage();
                        }
                    }, 10000L);
                }
            }

            @Override
            public void messageReceived(PRRegressionTest.HandleImpl i, ByteBuffer m, Map<String, Object> options) throws IOException {
                if (this.logger.level <= 800) {
                    this.logger.log("Message received: " + MathUtils.toBase64(m.array()));
                }
            }

            @Override
            public void notifyStatusChange(PRRegressionTest.IdImpl id, int newStatus) {
                if (this.player.localHandle.id.id == 2) {
                    return;
                }
                if (this.logger.level <= 800) {
                    this.logger.log("notifyStatusChange(" + id + "," + PeerReviewImpl.getStatusString(newStatus) + ")");
                }
                if (newStatus == 2 && !id.equals(PRNonconform1.this.bobHandle.id)) {
                    this.logger.log("Node not trusted: " + id);
                    System.exit(1);
                }
                PRNonconform1.this.addStatusNotification(this.player.localHandle, id, newStatus);
            }
        };
    }

    public static void main(String[] args) throws Exception {
        new PRNonconform1();
    }
}

