/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer.peerreview;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.testing.transportlayer.peerreview.PRRegressionTest;
import org.mpisws.p2p.transport.peerreview.IdentifierExtractor;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.PeerReviewImpl;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.IndexEntryFactory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactoryImpl;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryImpl;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.util.Serializer;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.util.RandomAccessFileIOBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PRInconsistent1
extends PRRegressionTest {
    public PRInconsistent1() throws Exception {
        super(45000);
    }

    @Override
    protected PeerReviewImpl<PRRegressionTest.HandleImpl, PRRegressionTest.IdImpl> getPeerReview(PRRegressionTest.Player player, PRRegressionTest.MyIdTL transport, Environment env) {
        if (player.localHandle.id.id == 2) {
            return new PeerReviewImpl<PRRegressionTest.HandleImpl, PRRegressionTest.IdImpl>((IdentityTransport)transport, env, (Serializer)new PRRegressionTest.HandleSerializer(), (Serializer)new PRRegressionTest.IdSerializer(), (IdentifierExtractor)new PRRegressionTest.IdExtractor(), this.getIdStrTranslator()){

                @Override
                protected SecureHistoryFactory getSecureHistoryFactory(IdentityTransport<PRRegressionTest.HandleImpl, PRRegressionTest.IdImpl> transport, final Environment env) {
                    return new SecureHistoryFactoryImpl(transport, env){

                        protected SecureHistoryImpl makeSecureHistory(RandomAccessFileIOBuffer indexFile, RandomAccessFileIOBuffer dataFile, boolean readOnly, HashProvider hashProv, IndexEntryFactory indexFactory, Logger logger) throws IOException {
                            ForkingSecureHistory foo = new ForkingSecureHistory(indexFile, dataFile, readOnly, hashProv, indexFactory, logger){
                                int acks;
                                {
                                    this.acks = 0;
                                }

                                public void appendEntry(short type, boolean storeFullEntry, ByteBuffer ... entry) throws IOException {
                                    super.appendEntry(type, storeFullEntry, entry);
                                    if (type == 2) {
                                        ++this.acks;
                                        if (this.acks == 3) {
                                            final long idx = this.findLastEntry(new short[]{1}, 0x7FFFFFFFFFFFFFF5L);
                                            env.getSelectorManager().invoke(new Runnable(){

                                                public void run() {
                                                    try {
                                                        this.fork(idx);
                                                    }
                                                    catch (IOException ioe) {
                                                        logger.logException("Error forking the history at index " + idx, ioe);
                                                    }
                                                }
                                            });
                                        }
                                    }
                                }
                            };
                            return foo;
                        }
                    };
                }
            };
        }
        return super.getPeerReview(player, transport, env);
    }

    @Override
    public void finish() {
        try {
            if ((Integer)((Map)this.recordedStatus.get(this.aliceHandle)).get(this.bobHandle.id) != 2) {
                this.logger.log("Alice Didn't expose bob");
                System.exit(1);
            }
            if ((Integer)((Map)this.recordedStatus.get(this.carolHandle)).get(this.bobHandle.id) != 2) {
                this.logger.log("Carol Didn't expose bob");
                System.exit(1);
            }
        }
        catch (Exception e) {
            this.logger.logException("Failure", e);
            System.exit(1);
        }
        this.logger.log("Success");
        System.exit(0);
    }

    @Override
    public PRRegressionTest.BogusApp getBogusApp(PRRegressionTest.Player player, PeerReview<PRRegressionTest.HandleImpl, PRRegressionTest.IdImpl> pr, Environment env) {
        return new PRRegressionTest.BogusApp(player, pr, env){

            public void notifyStatusChange(PRRegressionTest.IdImpl id, int newStatus) {
                if (this.player.localHandle.id.id == 2) {
                    return;
                }
                if (this.logger.level <= 800) {
                    this.logger.log("notifyStatusChange(" + id + "," + PeerReviewImpl.getStatusString(newStatus) + ")");
                }
                if (newStatus == 2 && !id.equals(PRInconsistent1.this.bobHandle.id)) {
                    this.logger.log("Node not trusted: " + id);
                    System.exit(1);
                }
                PRInconsistent1.this.addStatusNotification(this.player.localHandle, id, newStatus);
            }
        };
    }

    public static void main(String[] args) throws Exception {
        new PRInconsistent1();
    }

    public class ForkingSecureHistory
    extends SecureHistoryImpl {
        public ForkingSecureHistory(RandomAccessFileIOBuffer indexFile, RandomAccessFileIOBuffer dataFile, boolean readOnly, HashProvider hashProv, IndexEntryFactory indexFactory, Logger logger) throws IOException {
            super(indexFile, dataFile, readOnly, hashProv, indexFactory, logger);
        }

        public void fork(long entryIndex) throws IOException {
            IndexEntry entry = this.statEntry(entryIndex);
            this.logger.log("forking at " + entryIndex + " " + entry);
            this.dataFile.setLength(entry.getFileIndex());
            this.indexFile.setLength(entryIndex * (long)this.indexFactory.getSerializedSize());
            this.numEntries = entryIndex;
            this.topEntry = this.statEntry(entryIndex - 1L);
            assert (this.topEntry != null);
        }
    }
}

