/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer.peerreview;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;

public class MyInetSocketAddress
extends InetSocketAddress
implements RawSerializable {
    public static final Serializer<MyInetSocketAddress> serializer = new Serializer<MyInetSocketAddress>(){
        public static final byte IPV4 = 4;
        public static final byte IPV6 = 6;
        public static final int IPV4_BYTES = 4;
        public static final int IPV6_BYTES = 16;

        @Override
        public MyInetSocketAddress deserialize(InputBuffer b) throws IOException {
            byte[] addr;
            byte version = b.readByte();
            switch (version) {
                case 4: {
                    addr = new byte[4];
                    break;
                }
                case 6: {
                    addr = new byte[16];
                    break;
                }
                default: {
                    throw new IOException("Incorrect IP version, expecting 4 or 6, got " + version);
                }
            }
            b.read(addr);
            short port = b.readShort();
            return new MyInetSocketAddress(InetAddress.getByAddress(addr), 0xFFFF & port);
        }

        @Override
        public void serialize(MyInetSocketAddress i, OutputBuffer b) throws IOException {
            byte[] addr = i.getAddress().getAddress();
            switch (addr.length) {
                case 4: {
                    b.writeByte((byte)4);
                    break;
                }
                case 16: {
                    b.writeByte((byte)6);
                    break;
                }
                default: {
                    throw new IOException("Incorrect number of bytes for IPaddress, expecting 4 or 16, got " + addr.length);
                }
            }
            b.write(addr, 0, addr.length);
            b.writeShort((short)i.getPort());
        }
    };

    public MyInetSocketAddress(InetAddress addr, int port) {
        super(addr, port);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        serializer.serialize(this, buf);
    }
}

