/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer.peerreview;

import java.util.ArrayList;
import java.util.Random;
import org.mpisws.p2p.transport.peerreview.audit.LogSnippet;
import org.mpisws.p2p.transport.peerreview.audit.SnippetEntry;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

public class LogSnippitTest {
    public static void main(String[] args) throws Exception {
        Random r = new Random();
        int hashSize = r.nextInt(100) + 1;
        ArrayList<SnippetEntry> list = new ArrayList<SnippetEntry>(100);
        long seq = Math.abs(r.nextLong());
        for (int i = 0; i < 400; ++i) {
            byte[] content;
            boolean isHash;
            boolean bl = isHash = r.nextInt(10) == 1;
            if (isHash) {
                content = new byte[hashSize];
            } else {
                switch (r.nextInt(15)) {
                    case 9: {
                        content = new byte[r.nextInt(65535)];
                        break;
                    }
                    case 8: {
                        content = new byte[r.nextInt(327670)];
                        break;
                    }
                    case 10: {
                        content = new byte[255];
                        break;
                    }
                    case 11: {
                        content = new byte[254];
                        break;
                    }
                    case 12: {
                        content = new byte[253];
                        break;
                    }
                    case 13: {
                        content = new byte[65535];
                        break;
                    }
                    case 14: {
                        content = new byte[65534];
                        break;
                    }
                    default: {
                        content = new byte[r.nextInt(254) + 1];
                    }
                }
            }
            r.nextBytes(content);
            int seqChoice = r.nextInt(10);
            if (seqChoice < 5) {
                ++seq;
            } else if (seqChoice < 8) {
                seq -= seq % 1000000L;
                seq += 1000000L;
            } else {
                seq += (long)r.nextInt(Integer.MAX_VALUE);
            }
            list.add(new SnippetEntry((byte)r.nextInt(256), seq, isHash, content));
        }
        byte[] baseHash = new byte[hashSize];
        r.nextBytes(baseHash);
        LogSnippet ls = new LogSnippet(baseHash, list);
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        ls.serialize(sob);
        SimpleInputBuffer sib = new SimpleInputBuffer(sob.getBytes());
        LogSnippet ls2 = new LogSnippet(sib, hashSize);
        if (ls2.equals(ls)) {
            System.out.println("success");
        } else {
            System.out.println("failure");
        }
    }
}

