/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mpisws.p2p.testing.transportlayer.MagicNumberTest;
import org.mpisws.p2p.testing.transportlayer.TLTest;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.SourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.SourceRouteTap;
import org.mpisws.p2p.transport.sourceroute.SourceRouteTransportLayer;
import org.mpisws.p2p.transport.sourceroute.SourceRouteTransportLayerImpl;
import org.mpisws.p2p.transport.sourceroute.factory.WireSourceRouteFactory;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import org.mpisws.p2p.transport.wire.magicnumber.MagicNumberTransportLayer;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireSRTest
extends TLTest<SourceRoute<InetSocketAddress>> {
    static SourceRouteTransportLayer<InetSocketAddress> carol_tap;
    static TransportLayer carol;
    static SourceRouteFactory<InetSocketAddress> srFactory;
    public static final byte[] GOOD_HDR;

    @Override
    public SourceRoute getIdentifier(TransportLayer<SourceRoute<InetSocketAddress>, ByteBuffer> a, TransportLayer<SourceRoute<InetSocketAddress>, ByteBuffer> b) {
        SourceRoute<InetSocketAddress> src = a.getLocalIdentifier();
        SourceRoute intermediate = (SourceRoute)carol.getLocalIdentifier();
        SourceRoute<InetSocketAddress> dest = b.getLocalIdentifier();
        ArrayList<InetSocketAddress> retArr = new ArrayList<InetSocketAddress>(3);
        retArr.add(src.getFirstHop());
        retArr.add((InetSocketAddress)intermediate.getFirstHop());
        retArr.add(dest.getFirstHop());
        return srFactory.getSourceRoute((InetSocketAddress)((Object)retArr));
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        srFactory = new WireSourceRouteFactory();
        TLTest.setUpBeforeClass();
        int startPort = 5009;
        logger = env.getLogManager().getLogger(MagicNumberTest.class, null);
        InetAddress addr = InetAddress.getLocalHost();
        alice = WireSRTest.buildTL("alice", addr, startPort, env);
        bob = WireSRTest.buildTL("bob", addr, startPort + 1, env);
        carol_tap = (SourceRouteTransportLayer)WireSRTest.buildTL("carol", addr, startPort + 2, env);
        carol = carol_tap;
    }

    private static TransportLayer buildTL(String name, InetAddress addr, int port, Environment env) throws IOException {
        Environment env_a = new Environment(env.getSelectorManager(), env.getProcessor(), env.getRandomSource(), env.getTimeSource(), ((CloneableLogManager)env.getLogManager()).clone(name), env.getParameters(), env.getExceptionStrategy());
        env.addDestructable(env_a);
        InetSocketAddress addr_a = new InetSocketAddress(addr, port);
        return new SourceRouteTransportLayerImpl<InetSocketAddress>(srFactory, new MagicNumberTransportLayer<InetSocketAddress>(new WireTransportLayerImpl(addr_a, env_a, null), env_a, null, GOOD_HDR, 2000), null, env_a, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void openTCP() throws Exception {
        final Object lock = new Object();
        final ArrayList opened = new ArrayList(1);
        final ArrayList closed = new ArrayList(1);
        final ArrayList received = new ArrayList(1);
        final ArrayList bad = new ArrayList(1);
        SourceRouteTap tap = new SourceRouteTap(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void socketOpened(SourceRoute path, P2PSocket a, P2PSocket b) {
                Object object = lock;
                synchronized (object) {
                    opened.add(new Triplet(path, a, b));
                    lock.notify();
                }
            }

            public void receivedMessage(ByteBuffer m, SourceRoute path) {
                bad.add(new Triplet(path, null, null));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void socketClosed(SourceRoute path, P2PSocket a, P2PSocket b) {
                Object object = lock;
                synchronized (object) {
                    closed.add(new Triplet(path, a, b));
                    lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receivedBytes(ByteBuffer m, SourceRoute path, P2PSocket a, P2PSocket b) {
                Object object = lock;
                synchronized (object) {
                    Triplet t = new Triplet(path, a, b);
                    t.m = m;
                    received.add(t);
                    lock.notify();
                }
            }
        };
        carol_tap.addSourceRouteTap(tap);
        super.openTCP();
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && bad.isEmpty() && (received.isEmpty() || opened.isEmpty() || opened.isEmpty())) {
                lock.wait(1000L);
            }
        }
        carol_tap.removeSourceRouteTap(tap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void sendUDP() throws Exception {
        final Object lock = new Object();
        final ArrayList taptupels = new ArrayList(1);
        SourceRouteTap tap = new SourceRouteTap(){

            public void socketOpened(SourceRoute path, P2PSocket a, P2PSocket b) {
            }

            public void receivedBytes(ByteBuffer m, SourceRoute path, P2PSocket a, P2PSocket b) {
            }

            public void socketClosed(SourceRoute path, P2PSocket a, P2PSocket b) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receivedMessage(ByteBuffer m, SourceRoute path) {
                Object object = lock;
                synchronized (object) {
                    class TapTupel {
                        ByteBuffer m;
                        SourceRoute path;

                        public TapTupel(ByteBuffer m, SourceRoute path) {
                            this.m = m;
                            this.path = path;
                        }
                    }
                    taptupels.add(new TapTupel(m, path));
                    lock.notify();
                }
            }
        };
        carol_tap.addSourceRouteTap(tap);
        super.sendUDP();
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && taptupels.isEmpty()) {
                lock.wait(1000L);
            }
        }
        carol_tap.removeSourceRouteTap(tap);
        Assert.assertTrue((taptupels.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((TapTupel)taptupels.get((int)0)).path.equals(this.getIdentifier(alice, bob)));
    }

    @Override
    public SourceRoute<InetSocketAddress> getBogusIdentifier(SourceRoute<InetSocketAddress> local) throws IOException {
        return srFactory.getSourceRoute(local.getFirstHop(), new InetSocketAddress(InetAddress.getLocalHost(), 5007));
    }

    static {
        GOOD_HDR = new byte[]{-34, -83, -66, -17};
    }

    static class Triplet {
        SourceRoute path;
        P2PSocket a;
        P2PSocket b;
        ByteBuffer m;

        public Triplet(SourceRoute path, P2PSocket a, P2PSocket b) {
            this.path = path;
            this.a = a;
            this.b = b;
        }
    }
}

