/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.ast.Block;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.CodeNode;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Local;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.NamedVariable;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Pair;
import polyglot.util.Position;
import polyglot.util.UniqueID;
import polyglot.visit.ContextVisitor;
import polyglot.visit.InnerClassRemover;
import polyglot.visit.NodeVisitor;

public class LocalClassRemover
extends ContextVisitor {
    Map fieldForLocal = new HashMap();
    Map orphans = new HashMap();
    Map newFields = new HashMap();
    boolean inConstructorCall;
    Map localOfField = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public LocalClassRemover(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    public Node override(Node parent, Node n) {
        if (n instanceof Block) {
            Block b = (Block)n;
            ArrayList<Stmt> ss = new ArrayList<Stmt>(b.statements());
            for (int i = 0; i < ss.size(); ++i) {
                Stmt s = (Stmt)ss.get(i);
                if (s instanceof LocalClassDecl) {
                    s = (Stmt)n.visitChild(s, this);
                    LocalClassDecl lcd = (LocalClassDecl)s;
                    ClassDecl cd = lcd.decl();
                    Flags flags = this.context.inStaticContext() ? Flags.PRIVATE.Static() : Flags.PRIVATE;
                    cd = cd.flags(flags);
                    cd.type().flags(flags);
                    cd.type().kind(ClassType.MEMBER);
                    cd = this.rewriteLocalClass(cd, (List)LocalClassRemover.hashGet(this.newFields, cd.type(), Collections.EMPTY_LIST));
                    if (cd != lcd.decl()) {
                        ss.set(i, lcd.decl(cd));
                        for (int j = i; j < ss.size(); ++j) {
                            Stmt sj = (Stmt)ss.get(j);
                            sj = (Stmt)this.rewriteConstructorCalls(sj, cd.type(), (List)LocalClassRemover.hashGet(this.newFields, cd.type(), Collections.EMPTY_LIST));
                            ss.set(j, sj);
                        }
                        lcd = (LocalClassDecl)ss.get(i);
                        cd = lcd.decl();
                    }
                    LocalClassRemover.hashAdd(this.orphans, this.context.currentClassScope(), cd);
                    ss.remove(i);
                    --i;
                    continue;
                }
                s = (Stmt)n.visitChild(s, this);
                ss.set(i, s);
            }
            return b.statements(ss);
        }
        return null;
    }

    protected NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        LocalClassRemover v = (LocalClassRemover)super.enterCall(parent, n);
        if (n instanceof ConstructorCall && !this.inConstructorCall) {
            v = (LocalClassRemover)v.copy();
            v.inConstructorCall = true;
            return v;
        }
        if ((n instanceof ClassBody || n instanceof CodeNode) && v.inConstructorCall) {
            v = (LocalClassRemover)v.copy();
            v.inConstructorCall = false;
            return v;
        }
        return v;
    }

    protected boolean isLocal(Context c, String name) {
        return c.isLocal(name);
    }

    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        FieldInstance fi;
        Local l;
        Context c = this.context();
        Position pos = n.position();
        if (n instanceof Local && !this.inConstructorCall && !this.isLocal(this.context, (l = (Local)n).name()) && (fi = this.boxLocal(l.localInstance())) != null) {
            Field f = this.nf.Field(pos, this.makeMissingFieldTarget(fi, pos), this.nf.Id(pos, fi.name()));
            f = f.fieldInstance(fi);
            f = (Field)f.type(fi.type());
            return f;
        }
        if (n instanceof New) {
            ClassType s;
            New neu = (New)n;
            ClassBody body = neu.body();
            if (body == null) {
                return neu;
            }
            TypeNode superClass = neu.objectType();
            List<TypeNode> interfaces = Collections.EMPTY_LIST;
            Type supertype = neu.objectType().type();
            if (supertype instanceof ClassType && (s = (ClassType)supertype).flags().isInterface()) {
                superClass = this.defaultSuperType(pos);
                interfaces = Collections.singletonList(neu.objectType());
            }
            Id name = this.nf.Id(pos, UniqueID.newID("Anonymous"));
            ClassDecl cd = this.nf.ClassDecl(pos, Flags.PRIVATE, name, superClass, interfaces, body);
            ParsedClassType type = neu.anonType();
            type.kind(ClassType.MEMBER);
            type.name(cd.name());
            type.setContainer(this.context.currentClass());
            type.package_(this.context.package_());
            Flags flags = this.context.inStaticContext() ? Flags.PRIVATE.Static() : Flags.PRIVATE;
            type.flags(flags);
            cd = cd.type(type);
            cd = cd.flags(flags);
            ConstructorDecl td = this.addConstructor(cd, neu);
            cd.type().addConstructor(td.constructorInstance());
            ClassBody b = cd.body();
            ArrayList<ConstructorDecl> members = new ArrayList<ConstructorDecl>();
            members.addAll(b.members());
            members.add(td);
            b = b.members(members);
            cd = cd.body(b);
            ConstructorInstance oldCi = neu.constructorInstance();
            neu = neu.constructorInstance(td.constructorInstance());
            neu = neu.anonType(null);
            if (!flags.isStatic()) {
                neu = neu.qualifier(this.nf.This(pos).type(this.context.currentClass()));
            }
            cd = this.rewriteLocalClass(cd, (List)LocalClassRemover.hashGet(this.newFields, cd.type(), Collections.EMPTY_LIST));
            LocalClassRemover.hashAdd(this.orphans, this.context.currentClassScope(), cd);
            neu = neu.objectType(this.nf.CanonicalTypeNode(pos, type)).body(null);
            neu = (New)this.rewriteConstructorCalls(neu, cd.type(), (List)LocalClassRemover.hashGet(this.newFields, cd.type(), Collections.EMPTY_LIST));
            return neu;
        }
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            List o = (List)this.orphans.get(cd.type());
            if (o == null) {
                return cd;
            }
            ClassBody b = cd.body();
            ArrayList members = new ArrayList();
            members.addAll(b.members());
            members.addAll(o);
            b = b.members(members);
            return cd.body(b);
        }
        return n;
    }

    protected TypeNode defaultSuperType(Position pos) {
        return this.nf.CanonicalTypeNode(pos, this.ts.Object());
    }

    ClassDecl rewriteLocalClass(ClassDecl cd, List newFields) {
        return InnerClassRemover.addFieldsToClass(cd, newFields, this.ts, this.nf, false);
    }

    Node rewriteConstructorCalls(Node s, ClassType ct, List fields) {
        Node r = s.visit(new ConstructorCallRewriter(fields, ct));
        return r;
    }

    ConstructorDecl addConstructor(ClassDecl cd, New neu) {
        ArrayList<Formal> formals = new ArrayList<Formal>();
        ArrayList<Local> args = new ArrayList<Local>();
        ArrayList<Type> argTypes = new ArrayList<Type>();
        int i = 1;
        Iterator j = neu.arguments().iterator();
        while (j.hasNext()) {
            Expr e = (Expr)j.next();
            Position pos = e.position();
            Id name = this.nf.Id(pos, "a" + i);
            ++i;
            Formal f = this.nf.Formal(pos, Flags.FINAL, (TypeNode)this.nf.CanonicalTypeNode(pos, e.type()), name);
            Local l = this.nf.Local(pos, name);
            LocalInstance li = this.ts.localInstance(pos, f.flags(), f.declType(), name.id());
            li.setNotConstant();
            f = f.localInstance(li);
            l = l.localInstance(li);
            l = (Local)l.type(li.type());
            formals.add(f);
            args.add(l);
            argTypes.add(li.type());
        }
        Position pos = cd.position();
        ConstructorCall cc = this.nf.SuperCall(pos, args);
        cc = cc.constructorInstance(neu.constructorInstance());
        cc = cc.qualifier(this.adjustQualifier(neu.qualifier()));
        ArrayList<ConstructorCall> statements = new ArrayList<ConstructorCall>();
        statements.add(cc);
        ArrayList<CanonicalTypeNode> throwTypeNodes = new ArrayList<CanonicalTypeNode>();
        ArrayList<Type> throwTypes = new ArrayList<Type>();
        Iterator j2 = neu.constructorInstance().throwTypes().iterator();
        while (j2.hasNext()) {
            Type t = (Type)j2.next();
            throwTypes.add(t);
            throwTypeNodes.add(this.nf.CanonicalTypeNode(pos, t));
        }
        ConstructorDecl td = this.nf.ConstructorDecl(pos, Flags.PRIVATE, cd.id(), formals, throwTypeNodes, this.nf.Block(pos, statements));
        ConstructorInstance ci = this.ts.constructorInstance(pos, cd.type(), Flags.PRIVATE, argTypes, throwTypes);
        td = td.constructorInstance(ci);
        return td;
    }

    private Expr adjustQualifier(Expr e) {
        Special s;
        if (e instanceof Special && (s = (Special)e).kind() == Special.THIS && s.qualifier() == null) {
            return s.qualifier(this.nf.CanonicalTypeNode(s.position(), s.type()));
        }
        return e;
    }

    List addArgs(ProcedureCall n, ConstructorInstance nci, List fields, ClassType curr, ClassType theLocalClass) {
        if (nci == null || fields == null || fields.isEmpty() || n.arguments().size() == nci.formalTypes().size()) {
            return n.arguments();
        }
        ArrayList<NamedVariable> args = new ArrayList<NamedVariable>();
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            FieldInstance fi = (FieldInstance)i.next();
            if (curr != null && theLocalClass != null && this.ts.isEnclosed((ClassType)curr.declaration(), (ClassType)theLocalClass.declaration())) {
                Position pos = fi.position();
                Field f = this.nf.Field(pos, this.makeMissingFieldTarget(fi, pos), this.nf.Id(pos, fi.name()));
                f = f.fieldInstance(fi);
                f = (Field)f.type(fi.type());
                args.add(f);
                continue;
            }
            LocalInstance li = (LocalInstance)this.localOfField.get(fi);
            if (li != null) {
                Local l = this.nf.Local(li.position(), this.nf.Id(li.position(), li.name()));
                l = l.localInstance(li);
                l = (Local)l.type(li.type());
                args.add(l);
                continue;
            }
            throw new InternalCompilerError("field " + fi + " created with rev map to null", n.position());
        }
        args.addAll(n.arguments());
        if (!$assertionsDisabled && args.size() != nci.formalTypes().size()) {
            throw new AssertionError();
        }
        return args;
    }

    private FieldInstance boxLocal(LocalInstance li) {
        ClassType curr = this.currLocalClass();
        if (curr == null) {
            return null;
        }
        Pair key = new Pair(li = (LocalInstance)li.declaration(), curr);
        FieldInstance fi = (FieldInstance)this.fieldForLocal.get(key);
        if (fi != null) {
            return fi;
        }
        Position pos = li.position();
        fi = this.ts.fieldInstance(pos, curr, li.flags().Private(), li.type(), li.name());
        fi.setNotConstant();
        ParsedClassType ct = (ParsedClassType)curr.declaration();
        ct.addField(fi);
        List l = (List)LocalClassRemover.hashGet(this.newFields, ct, new ArrayList());
        l.add(fi);
        this.localOfField.put(fi, li);
        this.fieldForLocal.put(key, fi);
        return fi;
    }

    private ClassType currLocalClass() {
        for (ClassType curr = this.context.currentClass(); curr != null; curr = curr.outer()) {
            if (curr.isLocal() || curr.isAnonymous()) {
                return curr;
            }
            if (curr.isTopLevel()) break;
        }
        return null;
    }

    protected Receiver makeMissingFieldTarget(FieldInstance fi, Position pos) {
        ClassType scope;
        Context c = this.context();
        Receiver r = fi.flags().isStatic() ? this.nf.CanonicalTypeNode(pos, fi.container()) : (!this.ts.equals(scope = (ClassType)fi.container(), c.currentClass()) ? this.nf.This(pos.startOf(), this.nf.CanonicalTypeNode(pos, scope)).type(scope) : this.nf.This(pos.startOf()).type(scope));
        return r;
    }

    public static Object hashGet(Map map, Object k, Object v) {
        Object x = map.get(k);
        if (x != null) {
            return x;
        }
        map.put(k, v);
        return v;
    }

    public static void hashAdd(Map map, Object k, Object v) {
        ArrayList<Object> l = (ArrayList<Object>)map.get(k);
        if (l == null) {
            l = new ArrayList<Object>();
            map.put(k, l);
        }
        l.add(v);
    }

    static {
        $assertionsDisabled = !LocalClassRemover.class.desiredAssertionStatus();
    }

    protected final class ConstructorCallRewriter
    extends NodeVisitor {
        private final List newFields;
        private final ClassType theLocalClass;
        ParsedClassType curr;

        protected ConstructorCallRewriter(List fields, ClassType ct) {
            this.newFields = fields;
            this.theLocalClass = ct;
        }

        public NodeVisitor enter(Node n) {
            if (n instanceof ClassDecl) {
                ConstructorCallRewriter v = (ConstructorCallRewriter)this.copy();
                v.curr = ((ClassDecl)n).type();
                return v;
            }
            return this;
        }

        public Node leave(Node old, Node n, NodeVisitor v) {
            if (n instanceof New) {
                New neu = (New)n;
                ConstructorInstance ci = neu.constructorInstance();
                ConstructorInstance nci = (ConstructorInstance)ci.declaration();
                if (nci.container().toClass().declaration() == this.theLocalClass.declaration()) {
                    neu = (New)neu.arguments(LocalClassRemover.this.addArgs(neu, nci, this.newFields, this.curr, this.theLocalClass));
                    if (!this.theLocalClass.flags().isStatic()) {
                        Expr q = this.theLocalClass.outer() == LocalClassRemover.this.context.currentClass() ? LocalClassRemover.this.nf.This(neu.position()).type(this.theLocalClass.outer()) : LocalClassRemover.this.nf.This(neu.position(), LocalClassRemover.this.nf.CanonicalTypeNode(neu.position(), this.theLocalClass.outer())).type(this.theLocalClass.outer());
                        neu = neu.qualifier(q);
                    }
                }
                return neu;
            }
            if (n instanceof ConstructorCall) {
                ConstructorCall neu = (ConstructorCall)n;
                ConstructorInstance ci = neu.constructorInstance();
                ConstructorInstance nci = (ConstructorInstance)ci.declaration();
                if (nci.container().toClass().declaration() == this.theLocalClass.declaration()) {
                    neu = (ConstructorCall)neu.arguments(LocalClassRemover.this.addArgs(neu, nci, this.newFields, this.curr, this.theLocalClass));
                    if (!this.theLocalClass.flags().isStatic()) {
                        Expr q = this.theLocalClass.outer() == LocalClassRemover.this.context.currentClass() ? LocalClassRemover.this.nf.This(neu.position()).type(this.theLocalClass.outer()) : LocalClassRemover.this.nf.This(neu.position(), LocalClassRemover.this.nf.CanonicalTypeNode(neu.position(), this.theLocalClass.outer())).type(this.theLocalClass.outer());
                        neu = neu.qualifier(q);
                    }
                }
                return neu;
            }
            return n;
        }
    }
}

