/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Formal;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;

public abstract class InnerClassAbstractRemover
extends ContextVisitor {
    public InnerClassAbstractRemover(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    protected String namePrefix() {
        return "jl$";
    }

    String mangleClassName(ClassType ct) {
        return this.namePrefix() + ct.fullName().replace('.', '$');
    }

    List env(ClassType ct, boolean includeSuper) {
        if (ct == null || !ct.isInnerClass()) {
            return Collections.EMPTY_LIST;
        }
        List superEnv = Collections.EMPTY_LIST;
        if (includeSuper) {
            superEnv = this.env((ClassType)ct.superType(), true);
        }
        ArrayList<ClassType> env = new ArrayList<ClassType>();
        ClassType outer = ct.outer();
        while (true) {
            env.add(outer);
            if (!outer.isInnerClass()) break;
            outer = outer.outer();
        }
        env.removeAll(superEnv);
        if (env.isEmpty()) {
            return superEnv;
        }
        if (superEnv.isEmpty()) {
            return env;
        }
        ArrayList<ClassType> l = new ArrayList<ClassType>();
        l.addAll(env);
        l.addAll(superEnv);
        return l;
    }

    List envAsFormalTypes(List env) {
        return env;
    }

    List envAsFormals(List env) {
        ArrayList<Formal> formals = new ArrayList<Formal>();
        int arg = 1;
        Iterator i = env.iterator();
        while (i.hasNext()) {
            ClassType ct = (ClassType)i.next();
            LocalInstance li = this.ts.localInstance(Position.compilerGenerated(), Flags.FINAL, ct, "arg" + arg);
            Formal f = this.nf.Formal(li.position(), li.flags(), (TypeNode)this.nf.CanonicalTypeNode(Position.compilerGenerated(), li.type()), li.name());
            f = f.localInstance(li);
            formals.add(f);
            ++arg;
        }
        return formals;
    }

    List envAsActuals(List env, ClassType outer, Expr qualifier) {
        ArrayList<Expr> actuals = new ArrayList<Expr>();
        Iterator i = env.iterator();
        while (i.hasNext()) {
            String name;
            FieldInstance fi;
            ClassType ct = (ClassType)i.next();
            if (outer != null && qualifier != null && ct.equals(outer)) {
                actuals.add(qualifier);
                continue;
            }
            if (outer != null && (fi = outer.fieldNamed(name = this.mangleClassName(ct))) != null && fi.type().equals(ct)) {
                Special this_ = this.nf.Special(Position.compilerGenerated(), Special.THIS);
                this_ = (Special)this_.type(ct);
                Field field = this.nf.Field(Position.compilerGenerated(), (Receiver)this_, this.nf.Id(Position.compilerGenerated(), name));
                field = field.fieldInstance(fi);
                field = (Field)field.type(fi.type());
                actuals.add(field);
                continue;
            }
            CanonicalTypeNode tn = this.nf.CanonicalTypeNode(Position.compilerGenerated(), ct);
            Special this_ = this.nf.Special(Position.compilerGenerated(), Special.THIS, tn);
            this_ = (Special)this_.type(ct);
            actuals.add(this_);
        }
        return actuals;
    }
}

