/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.HashSet;
import java.util.Set;
import polyglot.ast.Assign;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceFile;
import polyglot.ast.Unary;
import polyglot.ast.VarDecl;
import polyglot.frontend.Job;
import polyglot.types.LocalInstance;
import polyglot.types.TypeSystem;
import polyglot.visit.NodeVisitor;

public class FinalLocalExtractor
extends NodeVisitor {
    protected Set isFinal;

    public FinalLocalExtractor(Job job, TypeSystem ts, NodeFactory nf) {
    }

    public NodeVisitor begin() {
        this.isFinal = new HashSet();
        return super.begin();
    }

    public void finish() {
        this.isFinal = null;
    }

    public NodeVisitor enter(Node parent, Node n) {
        Assign a;
        Unary u;
        LocalInstance li;
        VarDecl d;
        if (n instanceof Formal) {
            d = (Formal)n;
            li = d.localInstance();
            if (!li.flags().isFinal()) {
                li.setFlags(li.flags().Final());
            } else {
                this.isFinal.add(li);
            }
        }
        if (n instanceof LocalDecl) {
            d = (LocalDecl)n;
            li = d.localInstance();
            if (!li.flags().isFinal()) {
                li.setFlags(li.flags().Final());
            } else {
                this.isFinal.add(li);
            }
        }
        if (n instanceof Unary && (u = (Unary)n).expr() instanceof Local) {
            Local l = (Local)u.expr();
            LocalInstance li2 = l.localInstance().orig();
            if (!(u.operator() != Unary.PRE_DEC && u.operator() != Unary.POST_DEC && u.operator() != Unary.PRE_INC && u.operator() != Unary.POST_INC || this.isFinal.contains(li2.orig()))) {
                li2.setFlags(li2.flags().clearFinal());
            }
        }
        if (n instanceof Assign && (a = (Assign)n).left() instanceof Local && !this.isFinal.contains(li = ((Local)a.left()).localInstance().orig())) {
            li.setFlags(li.flags().clearFinal());
        }
        return super.enter(parent, n);
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof SourceFile) {
            return n.visit(new LocalDeclFixer());
        }
        return n;
    }

    protected static class LocalDeclFixer
    extends NodeVisitor {
        protected LocalDeclFixer() {
        }

        public Node leave(Node old, Node n, NodeVisitor v) {
            if (n instanceof Formal) {
                Formal d = (Formal)n;
                return d.flags(d.localInstance().flags());
            }
            if (n instanceof LocalDecl) {
                LocalDecl d = (LocalDecl)n;
                return d.flags(d.localInstance().flags());
            }
            return n;
        }
    }
}

