/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class ConstantChecker
extends ContextVisitor {
    public ConstantChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        Expr e;
        if (Report.should_report("visit", 2)) {
            Report.report(2, ">> " + this + "::leave " + n);
        }
        TypeCheckChecker tcc = new TypeCheckChecker();
        if (n instanceof Expr && !(e = (Expr)n).isTypeChecked()) {
            tcc.checked = false;
        }
        if (tcc.checked) {
            n.del().visitChildren(tcc);
        }
        Node m = n;
        if (!tcc.checked) {
            Scheduler scheduler = this.job().extensionInfo().scheduler();
            Goal g = scheduler.TypeChecked(this.job());
            throw new MissingDependencyException(g);
        }
        m = m.del().checkConstants((ConstantChecker)v);
        if (Report.should_report("visit", 2)) {
            Report.report(2, "<< " + this + "::leave " + n + " -> " + m);
        }
        return m;
    }

    protected static class TypeCheckChecker
    extends NodeVisitor {
        public boolean checked = true;

        protected TypeCheckChecker() {
        }

        public Node override(Node n) {
            if (!n.isTypeChecked()) {
                this.checked = false;
            }
            return n;
        }
    }
}

