/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeDecl;
import polyglot.ast.FieldDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.DisambiguationDriver;
import polyglot.visit.HaltingVisitor;
import polyglot.visit.NodeVisitor;

public class AmbiguityRemover
extends DisambiguationDriver {
    protected boolean visitSigs;
    protected boolean visitBodies;

    public AmbiguityRemover(Job job, TypeSystem ts, NodeFactory nf) {
        this(job, ts, nf, true, true);
    }

    public AmbiguityRemover(Job job, TypeSystem ts, NodeFactory nf, boolean visitSigs, boolean visitBodies) {
        super(job, ts, nf);
        this.visitSigs = visitSigs;
        this.visitBodies = visitBodies;
    }

    public Node override(Node parent, Node n) {
        if (!this.visitSigs && n instanceof ClassMember && !(n instanceof ClassDecl)) {
            return n;
        }
        if (!(this.visitBodies && this.visitSigs || !(parent instanceof ClassMember))) {
            if (parent instanceof FieldDecl && ((FieldDecl)parent).init() == n) {
                return n;
            }
            if (parent instanceof CodeDecl && ((CodeDecl)parent).body() == n) {
                return n;
            }
        }
        try {
            if (Report.should_report("visit", 2)) {
                Report.report(2, ">> " + this + "::override " + n + " (" + n.getClass().getName() + ")");
            }
            Node m = n.del().disambiguateOverride(parent, this);
            if (Report.should_report("visit", 2)) {
                Report.report(2, "<< " + this + "::override " + n + " -> " + m + (m != null ? " (" + m.getClass().getName() + ")" : ""));
            }
            return m;
        }
        catch (MissingDependencyException e) {
            if (Report.should_report("frontend", 3)) {
                e.printStackTrace();
            }
            Scheduler scheduler = this.job.extensionInfo().scheduler();
            Goal g = scheduler.currentGoal();
            scheduler.addDependencyAndEnqueue(g, e.goal(), e.prerequisite());
            g.setUnreachableThisRun();
            if (this.rethrowMissingDependencies) {
                throw e;
            }
            return n;
        }
        catch (SemanticException e) {
            if (e.getMessage() != null) {
                Position position = e.position();
                if (position == null) {
                    position = n.position();
                }
                this.errorQueue().enqueue(5, e.getMessage(), position);
            }
            return n;
        }
    }

    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (Report.should_report("visit", 2)) {
            Report.report(2, ">> " + this + "::enter " + n + " (" + n.getClass().getName() + ")");
        }
        AmbiguityRemover v = (AmbiguityRemover)n.del().disambiguateEnter(this);
        if (Report.should_report("visit", 2)) {
            Report.report(2, "<< " + this + "::enter " + n + " (" + n.getClass().getName() + ")" + " -> " + v);
        }
        return v;
    }

    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (Report.should_report("visit", 2)) {
            Report.report(2, ">> " + this + "::leave " + n + " (" + n.getClass().getName() + ")");
        }
        Node m = n.del().disambiguate((AmbiguityRemover)v);
        if (Report.should_report("visit", 2)) {
            Report.report(2, "<< " + this + "::leave " + n + " -> " + m + (m != null ? " (" + m.getClass().getName() + ")" : ""));
        }
        return m;
    }

    public HaltingVisitor bypass(Collection c) {
        throw new InternalCompilerError("AmbiguityRemover does not support bypassing. Implement any required functionality using Node.disambiguateOverride(Node, AmbiguityRemover).");
    }

    public HaltingVisitor bypass(Node n) {
        throw new InternalCompilerError("AmbiguityRemover does not support bypassing. Implement any required functionality using Node.disambiguateOverride(Node, AmbiguityRemover).");
    }

    public HaltingVisitor bypassChildren(Node n) {
        throw new InternalCompilerError("AmbiguityRemover does not support bypassing. Implement any required functionality using Node.disambiguateOverride(Node, AmbiguityRemover).");
    }

    public boolean isASTDisambiguated(Node n) {
        return AmbiguityRemover.astAmbiguityCount(n) == 0;
    }

    public static int astAmbiguityCount(Node n) {
        AmbChecker ac = new AmbChecker();
        n.visit(ac);
        return ac.notOkCount;
    }

    protected static class AmbChecker
    extends NodeVisitor {
        public int notOkCount;

        protected AmbChecker() {
        }

        public Node override(Node parent, Node n) {
            List<String> TOPICS = Arrays.asList("types", "frontend", "disam-check");
            if (n instanceof New) {
                return n;
            }
            if (!n.isDisambiguated()) {
                if (Report.should_report(TOPICS, 3)) {
                    Report.report(3, "  not ok at " + n + " (" + n.getClass().getName() + ")");
                }
                ++this.notOkCount;
            }
            return null;
        }
    }

    protected static class AmbChecker2
    extends NodeVisitor {
        public boolean amb;

        protected AmbChecker2() {
        }

        public Node override(Node n) {
            if (!n.isDisambiguated()) {
                this.amb = true;
            }
            return n;
        }
    }
}

