/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import polyglot.util.Transformation;

public final class TransformingIterator
implements Iterator {
    protected Object next_item;
    protected Iterator current_iter;
    protected int index = 0;
    protected Iterator[] backing_iterators;
    protected Transformation transformation;

    public TransformingIterator(Iterator iter, Transformation trans) {
        this(new Iterator[]{iter}, trans);
    }

    public TransformingIterator(Collection iters, Transformation trans) {
        this.backing_iterators = iters.toArray(new Iterator[0]);
        this.transformation = trans;
        if (this.backing_iterators.length > 0) {
            this.current_iter = this.backing_iterators[0];
        }
        this.findNextItem();
    }

    public TransformingIterator(Iterator[] iters, Transformation trans) {
        this.backing_iterators = (Iterator[])iters.clone();
        this.transformation = trans;
        if (iters.length > 0) {
            this.current_iter = iters[0];
        }
        this.findNextItem();
    }

    public Object next() {
        Object res = this.next_item;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.findNextItem();
        return res;
    }

    public boolean hasNext() {
        return this.next_item != null;
    }

    public void remove() {
        throw new UnsupportedOperationException("TransformingIterator.remove");
    }

    private void findNextItem() {
        while (this.current_iter != null) {
            while (this.current_iter.hasNext()) {
                Object o = this.current_iter.next();
                Object res = this.transformation.transform(o);
                if (res == Transformation.NOTHING) continue;
                this.next_item = res;
                return;
            }
            ++this.index;
            if (this.index < this.backing_iterators.length) {
                this.current_iter = this.backing_iterators[this.index];
                continue;
            }
            this.current_iter = null;
        }
        this.next_item = null;
    }
}

