/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MultiMap
extends AbstractMap {
    private Map map = new HashMap();

    private Set getValueSet(Object key) {
        HashSet values = (HashSet)this.map.get(key);
        if (values == null) {
            values = new HashSet();
            this.map.put(key, values);
        }
        return values;
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Set values = (Set)entry.getValue();
            if (!values.contains(values)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Set getValues(Object key) {
        Set s = (Set)this.map.get(key);
        if (s == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(s);
    }

    public Object put(Object key, Object value) {
        if (value instanceof Collection) {
            Object original = this.map.get(key);
            HashSet values = new HashSet();
            values.addAll((Collection)value);
            this.map.put(key, values);
            return original;
        }
        throw new IllegalArgumentException(value.getClass().toString());
    }

    public boolean add(Object key, Object value) {
        return this.getValueSet(key).add(value);
    }

    public boolean addAll(Object key, Collection values) {
        return this.getValueSet(key).addAll(values);
    }

    public Object remove(Object key) {
        Object original = this.map.get(key);
        this.map.remove(key);
        return original;
    }

    public boolean remove(Object key, Object value) {
        Set values = (Set)this.map.get(key);
        if (values == null) {
            return false;
        }
        return values.remove(value);
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        boolean first = true;
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object key = it.next();
            Set values = (Set)this.map.get(key);
            sb.append("[" + key + ": " + values + "]");
        }
        sb.append("}");
        return sb.toString();
    }
}

