/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.ConstantValue;

public class Field {
    protected DataInputStream in;
    protected ClassFile clazz;
    protected int modifiers;
    protected int name;
    protected int type;
    protected Attribute[] attrs;
    protected ConstantValue constantValue;
    protected boolean synthetic;

    Field(DataInputStream in, ClassFile clazz) throws IOException {
        this.clazz = clazz;
        this.in = in;
    }

    public void initialize() throws IOException {
        this.modifiers = this.in.readUnsignedShort();
        this.name = this.in.readUnsignedShort();
        this.type = this.in.readUnsignedShort();
        int numAttributes = this.in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            long n;
            int nameIndex = this.in.readUnsignedShort();
            int length = this.in.readInt();
            Constant name = this.clazz.getConstants()[nameIndex];
            if (name != null) {
                if ("ConstantValue".equals(name.value())) {
                    this.constantValue = new ConstantValue(this.in, nameIndex, length);
                    this.attrs[i] = this.constantValue;
                }
                if ("Synthetic".equals(name.value())) {
                    this.synthetic = true;
                }
            }
            if (this.attrs[i] != null || (n = this.in.skip(length)) == (long)length) continue;
            throw new EOFException();
        }
        this.in = null;
    }

    public boolean isString(Type t) {
        return t.isClass() && t.toClass().isTopLevel() && t.toClass().fullName().equals("java.lang.String");
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean isConstant() {
        return this.constantValue != null;
    }

    public Constant constantValue() {
        if (this.constantValue != null) {
            int index = this.constantValue.getIndex();
            return this.clazz.getConstants()[index];
        }
        return null;
    }

    public int getInt() throws SemanticException {
        Constant c = this.constantValue();
        if (c != null && c.tag() == 3) {
            Integer v = (Integer)c.value();
            return v;
        }
        throw new SemanticException("Could not find expected constant pool entry with tag INTEGER.");
    }

    public float getFloat() throws SemanticException {
        Constant c = this.constantValue();
        if (c != null && c.tag() == 4) {
            Float v = (Float)c.value();
            return v.floatValue();
        }
        throw new SemanticException("Could not find expected constant pool entry with tag FLOAT.");
    }

    public double getDouble() throws SemanticException {
        Constant c = this.constantValue();
        if (c != null && c.tag() == 6) {
            Double v = (Double)c.value();
            return v;
        }
        throw new SemanticException("Could not find expected constant pool entry with tag DOUBLE.");
    }

    public long getLong() throws SemanticException {
        Constant c = this.constantValue();
        if (c != null && c.tag() == 5) {
            Long v = (Long)c.value();
            return v;
        }
        throw new SemanticException("Could not find expected constant pool entry with tag LONG.");
    }

    public String getString() throws SemanticException {
        Constant c = this.constantValue();
        if (c != null && c.tag() == 8) {
            Integer i = (Integer)c.value();
            c = this.clazz.getConstants()[i];
            if (c != null && c.tag() == 1) {
                String v = (String)c.value();
                return v;
            }
        }
        throw new SemanticException("Could not find expected constant pool entry with tag STRING or UTF8.");
    }

    public Attribute[] getAttrs() {
        return this.attrs;
    }

    public ClassFile getClazz() {
        return this.clazz;
    }

    public ConstantValue getConstantValue() {
        return this.constantValue;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String name() {
        return (String)this.clazz.getConstants()[this.name].value();
    }
}

