/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.SchedulerException;
import polyglot.frontend.goals.Goal;
import polyglot.types.Named;
import polyglot.types.NamedPlaceHolder;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.CannotResolvePlaceHolderException;

public class PlaceHolder_c
implements NamedPlaceHolder {
    protected String name;

    protected PlaceHolder_c() {
    }

    public PlaceHolder_c(Named t) {
        this(t.fullName());
    }

    public PlaceHolder_c(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof PlaceHolder_c && this.name.equals(((PlaceHolder_c)o).name);
    }

    public TypeObject resolve(TypeSystem ts) throws CannotResolvePlaceHolderException {
        return this.resolveUnsafe(ts);
    }

    public TypeObject resolveUnsafe(TypeSystem ts) throws CannotResolvePlaceHolderException {
        Scheduler scheduler = ts.extensionInfo().scheduler();
        Goal g = scheduler.TypeExists(this.name);
        try {
            return ts.systemResolver().find(this.name);
        }
        catch (MissingDependencyException e) {
            g = e.goal();
            scheduler.currentGoal().setUnreachableThisRun();
            scheduler.addDependencyAndEnqueue(scheduler.currentGoal(), g, false);
            throw new CannotResolvePlaceHolderException(e);
        }
        catch (SchedulerException e) {
            scheduler.currentGoal().setUnreachableThisRun();
            scheduler.addDependencyAndEnqueue(scheduler.currentGoal(), g, false);
            throw new CannotResolvePlaceHolderException(e);
        }
        catch (SemanticException e) {
            scheduler.currentGoal().setUnreachableThisRun();
            scheduler.addDependencyAndEnqueue(scheduler.currentGoal(), g, false);
            throw new CannotResolvePlaceHolderException(e);
        }
    }

    public TypeObject resolveSafe(TypeSystem ts) throws CannotResolvePlaceHolderException {
        Named n = ts.systemResolver().check(this.name);
        if (n != null) {
            return n;
        }
        Scheduler scheduler = ts.extensionInfo().scheduler();
        scheduler.currentGoal().setUnreachableThisRun();
        scheduler.addDependencyAndEnqueue(scheduler.currentGoal(), scheduler.TypeExists(this.name), false);
        throw new CannotResolvePlaceHolderException("Could not resolve " + this.name);
    }

    public String toString() {
        return "PlaceHolder(" + this.name + ")";
    }
}

