/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.CachingResolver;
import polyglot.types.Declaration;
import polyglot.types.Package;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeObject_c;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;

public class Package_c
extends TypeObject_c
implements Package {
    protected Package prefix;
    protected String name;
    protected String fullname = null;
    protected transient Resolver memberCache;
    protected Package decl;

    protected Package_c() {
    }

    public Package_c(TypeSystem ts) {
        this(ts, null, null);
    }

    public Package_c(TypeSystem ts, String name) {
        this(ts, null, name);
    }

    public Package_c(TypeSystem ts, Package prefix, String name) {
        super(ts);
        this.prefix = prefix;
        this.name = name;
        this.decl = this;
    }

    public Resolver resolver() {
        if (this.memberCache == null) {
            this.memberCache = new CachingResolver(this.ts.createPackageContextResolver(this));
        }
        return this.memberCache;
    }

    public Object copy() {
        Package_c n = (Package_c)super.copy();
        n.memberCache = null;
        return n;
    }

    public Declaration declaration() {
        return this.decl;
    }

    public void setDeclaration(Declaration decl) {
        this.decl = (Package)decl;
    }

    public boolean equalsImpl(TypeObject o) {
        Package p;
        if (o instanceof Package && this.name.equals((p = (Package)o).name())) {
            if (this.prefix == null) {
                return p.prefix() == null;
            }
            return this.ts.equals(this.prefix, p.prefix());
        }
        return false;
    }

    public final boolean packageEquals(Package p) {
        return this.ts.packageEquals(this, p);
    }

    public boolean packageEqualsImpl(Package p) {
        if (this.name.equals(p.name())) {
            if (this.prefix == null) {
                return p.prefix() == null;
            }
            return this.ts.packageEquals(this.prefix, p.prefix());
        }
        return false;
    }

    public boolean isType() {
        return false;
    }

    public boolean isPackage() {
        return true;
    }

    public Type toType() {
        return null;
    }

    public Package toPackage() {
        return this;
    }

    public Package prefix() {
        return this.prefix;
    }

    public String name() {
        return this.name;
    }

    public String translate(Resolver c) {
        if (this.prefix() == null) {
            return this.name();
        }
        return this.prefix().translate(c) + "." + this.name();
    }

    public String fullName() {
        if (this.fullname == null) {
            this.fullname = this.prefix() == null ? this.name : this.prefix().fullName() + "." + this.name;
        }
        return this.fullname;
    }

    public String toString() {
        return this.prefix() == null ? this.name : this.prefix().toString() + "." + this.name;
    }

    public void print(CodeWriter w) {
        if (this.prefix() != null) {
            this.prefix().print(w);
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        w.write(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isCanonical() {
        return true;
    }
}

