/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.ParsedTypeObject;
import polyglot.types.SemanticException;
import polyglot.types.TopLevelResolver;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.StringUtil;

public class MemberClassResolver
implements TopLevelResolver {
    protected TypeSystem ts;
    protected TopLevelResolver inner;
    protected boolean allowRawClasses;
    protected Set nocache;
    protected static final Collection report_topics = CollectionUtil.list("types", "resolver", "loader", "mcr");

    public MemberClassResolver(TypeSystem ts, TopLevelResolver inner, boolean allowRawClasses) {
        this.ts = ts;
        this.inner = inner;
        this.allowRawClasses = allowRawClasses;
        this.nocache = new HashSet();
    }

    public boolean packageExists(String name) {
        return this.inner.packageExists(name);
    }

    public Named find(String name) throws SemanticException {
        if (Report.should_report(report_topics, 3)) {
            Report.report(3, "MemberCR.find(" + name + ")");
        }
        if (this.nocache.contains(name)) {
            throw new NoClassException(name);
        }
        Named n = this.ts.systemResolver().check(name);
        if (n != null) {
            return n;
        }
        SemanticException error = null;
        try {
            if (Report.should_report(report_topics, 2)) {
                Report.report(2, "MCR: loading " + name + " from " + this.inner);
            }
            return this.inner.find(name);
        }
        catch (SemanticException e) {
            if (Report.should_report(report_topics, 2)) {
                Report.report(2, "MCR: " + e.getMessage());
            }
            if (StringUtil.isNameShort(name)) {
                throw e;
            }
            error = e;
            boolean install = true;
            String prefix = StringUtil.getPackageComponent(name);
            String suffix = StringUtil.getShortNameComponent(name);
            try {
                if (Report.should_report(report_topics, 2)) {
                    Report.report(2, "MCR: loading prefix " + prefix);
                }
                if ((n = this.find(prefix)) instanceof ParsedTypeObject) {
                    return this.findMember(n, suffix);
                }
            }
            catch (SemanticException e2) {
                // empty catch block
            }
            if (install) {
                this.nocache.add(name);
            }
            throw error;
        }
    }

    protected Named findMember(Named container, String name) throws SemanticException {
        if (container instanceof ClassType) {
            ClassType n;
            ClassType ct = (ClassType)container;
            if (Report.should_report(report_topics, 2)) {
                Report.report(2, "MCR: found prefix " + ct);
            }
            if ((n = ct.memberClassNamed(name)) != null) {
                if (Report.should_report(report_topics, 2)) {
                    Report.report(2, "MCR: found member of " + ct + ": " + n);
                }
                return n;
            }
        }
        throw new NoClassException(container.fullName() + "." + name);
    }
}

