/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;

public class Flags
implements Serializable {
    protected Set flags = new TreeSet();
    public static final Flags NONE = new Flags();
    public static final Flags PUBLIC = Flags.createFlag("public", null);
    public static final Flags PRIVATE = Flags.createFlag("private", null);
    public static final Flags PROTECTED = Flags.createFlag("protected", null);
    public static final Flags STATIC = Flags.createFlag("static", null);
    public static final Flags FINAL = Flags.createFlag("final", null);
    public static final Flags SYNCHRONIZED = Flags.createFlag("synchronized", null);
    public static final Flags TRANSIENT = Flags.createFlag("transient", null);
    public static final Flags NATIVE = Flags.createFlag("native", null);
    public static final Flags INTERFACE = Flags.createFlag("interface", null);
    public static final Flags ABSTRACT = Flags.createFlag("abstract", null);
    public static final Flags VOLATILE = Flags.createFlag("volatile", null);
    public static final Flags STRICTFP = Flags.createFlag("strictfp", null);
    protected static final Flags ACCESS_FLAGS = PUBLIC.set(PRIVATE).set(PROTECTED);

    public static Flags createFlag(String name, Flags after) {
        Flags.addToOrder(name, after);
        return new Flags(name);
    }

    public static void addToOrder(String name, Flags after) {
        List order = FlagComparator.order;
        boolean added = false;
        if (after == null) {
            order.add(name);
        } else if (after.flags.isEmpty()) {
            order.add(0, name);
        } else {
            ListIterator<String> i = order.listIterator();
            while (i.hasNext()) {
                String s = (String)i.next();
                after = after.clear(new Flags(s));
                if (!after.flags.isEmpty()) continue;
                i.add(name);
                added = true;
                break;
            }
            if (!added) {
                order.add(name);
            }
        }
    }

    protected Flags() {
    }

    protected Flags(String name) {
        this();
        this.flags.add(name);
    }

    public Set flags() {
        return this.flags;
    }

    public Flags set(Flags other) {
        Flags f = new Flags();
        f.flags.addAll(this.flags);
        f.flags.addAll(other.flags);
        return f;
    }

    public Flags clear(Flags other) {
        Flags f = new Flags();
        f.flags.addAll(this.flags);
        f.flags.removeAll(other.flags);
        return f;
    }

    public Flags retain(Flags other) {
        Flags f = new Flags();
        f.flags.addAll(this.flags);
        f.flags.retainAll(other.flags);
        return f;
    }

    public boolean intersects(Flags other) {
        Iterator i = this.flags.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!other.flags.contains(name)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Flags other) {
        return this.flags.containsAll(other.flags);
    }

    public Flags Public() {
        return this.set(PUBLIC);
    }

    public Flags clearPublic() {
        return this.clear(PUBLIC);
    }

    public boolean isPublic() {
        return this.contains(PUBLIC);
    }

    public Flags Private() {
        return this.set(PRIVATE);
    }

    public Flags clearPrivate() {
        return this.clear(PRIVATE);
    }

    public boolean isPrivate() {
        return this.contains(PRIVATE);
    }

    public Flags Protected() {
        return this.set(PROTECTED);
    }

    public Flags clearProtected() {
        return this.clear(PROTECTED);
    }

    public boolean isProtected() {
        return this.contains(PROTECTED);
    }

    public Flags Package() {
        return this.clear(ACCESS_FLAGS);
    }

    public boolean isPackage() {
        return !this.intersects(ACCESS_FLAGS);
    }

    public Flags Static() {
        return this.set(STATIC);
    }

    public Flags clearStatic() {
        return this.clear(STATIC);
    }

    public boolean isStatic() {
        return this.contains(STATIC);
    }

    public Flags Final() {
        return this.set(FINAL);
    }

    public Flags clearFinal() {
        return this.clear(FINAL);
    }

    public boolean isFinal() {
        return this.contains(FINAL);
    }

    public Flags Synchronized() {
        return this.set(SYNCHRONIZED);
    }

    public Flags clearSynchronized() {
        return this.clear(SYNCHRONIZED);
    }

    public boolean isSynchronized() {
        return this.contains(SYNCHRONIZED);
    }

    public Flags Transient() {
        return this.set(TRANSIENT);
    }

    public Flags clearTransient() {
        return this.clear(TRANSIENT);
    }

    public boolean isTransient() {
        return this.contains(TRANSIENT);
    }

    public Flags Native() {
        return this.set(NATIVE);
    }

    public Flags clearNative() {
        return this.clear(NATIVE);
    }

    public boolean isNative() {
        return this.contains(NATIVE);
    }

    public Flags Interface() {
        return this.set(INTERFACE);
    }

    public Flags clearInterface() {
        return this.clear(INTERFACE);
    }

    public boolean isInterface() {
        return this.contains(INTERFACE);
    }

    public Flags Abstract() {
        return this.set(ABSTRACT);
    }

    public Flags clearAbstract() {
        return this.clear(ABSTRACT);
    }

    public boolean isAbstract() {
        return this.contains(ABSTRACT);
    }

    public Flags Volatile() {
        return this.set(VOLATILE);
    }

    public Flags clearVolatile() {
        return this.clear(VOLATILE);
    }

    public boolean isVolatile() {
        return this.contains(VOLATILE);
    }

    public Flags StrictFP() {
        return this.set(STRICTFP);
    }

    public Flags clearStrictFP() {
        return this.clear(STRICTFP);
    }

    public boolean isStrictFP() {
        return this.contains(STRICTFP);
    }

    public boolean moreRestrictiveThan(Flags f) {
        if (this.isPrivate() && (f.isProtected() || f.isPackage() || f.isPublic())) {
            return true;
        }
        if (this.isPackage() && (f.isProtected() || f.isPublic())) {
            return true;
        }
        return this.isProtected() && f.isPublic();
    }

    public String toString() {
        return this.translate().trim();
    }

    public String translate() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.flags.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString();
    }

    public int hashCode() {
        return ((Object)this.flags).hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Flags && ((Object)this.flags).equals(((Flags)o).flags);
    }

    protected static class FlagComparator
    implements Comparator {
        protected static List order = new ArrayList<String>(Arrays.asList("public", "private", "protected", "static", "final", "synchronized", "transient", "native", "interface", "abstract", "volatile", "strictfp"));

        protected FlagComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            for (int i = 0; i < order.size(); ++i) {
                if (o1.equals(order.get(i))) {
                    return -1;
                }
                if (!o2.equals(order.get(i))) continue;
                return 1;
            }
            return ((String)o1).compareTo((String)o2);
        }
    }
}

