/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import polyglot.main.Report;
import polyglot.types.AbstractAccessControlResolver;
import polyglot.types.ClassType;
import polyglot.types.MemberInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.ParsedTypeObject;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;

public class ClassContextResolver
extends AbstractAccessControlResolver {
    protected ClassType type;
    private static final Collection TOPICS = CollectionUtil.list("types", "resolver");

    public ClassContextResolver(TypeSystem ts, ClassType type) {
        super(ts);
        this.type = type;
    }

    public String toString() {
        return "(class-context " + this.type + ")";
    }

    public Named find(String name, ClassType accessor) throws SemanticException {
        Named n;
        Type sup;
        ParsedTypeObject pto;
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Looking for " + name + " in " + this);
        }
        if (!StringUtil.isNameShort(name)) {
            throw new InternalCompilerError("Cannot lookup qualified name " + name);
        }
        ClassType mt = null;
        String fullName = this.type.fullName() + "." + name;
        String rawName = this.ts.getTransformedClassName(this.type) + "$" + name;
        Named m = this.ts.systemResolver().check(fullName);
        if (m == null) {
            m = this.ts.systemResolver().check(rawName);
        }
        if (m == null) {
            m = this.type.memberClassNamed(name);
        }
        boolean useLoadedResolver = true;
        if (this.type instanceof ParsedTypeObject && (pto = (ParsedTypeObject)((Object)this.type)).job() != null) {
            useLoadedResolver = false;
        }
        if (m == null && useLoadedResolver) {
            try {
                m = this.ts.systemResolver().find(rawName);
            }
            catch (SemanticException e) {
                // empty catch block
            }
        }
        if (m instanceof ClassType) {
            mt = (ClassType)m;
            if (!mt.isMember()) {
                throw new SemanticException("Class " + mt + " is not a member class, " + " but was found in " + this.type + ".");
            }
            if (mt.outer().declaration() != this.type.declaration()) {
                throw new SemanticException("Class " + mt + " is not a member class " + " of " + this.type + ".");
            }
            if (!this.canAccess(mt, accessor)) {
                throw new SemanticException("Cannot access member type \"" + mt + "\".");
            }
            return mt;
        }
        HashSet<Named> acceptable = new HashSet<Named>();
        if (this.type.superType() != null && (sup = this.type.superType()) instanceof ClassType) {
            Resolver r = this.ts.classContextResolver((ClassType)sup, accessor);
            try {
                n = r.find(name);
                acceptable.add(n);
            }
            catch (SemanticException e) {
                // empty catch block
            }
        }
        Iterator i = this.type.interfaces().iterator();
        while (i.hasNext()) {
            Type sup2 = (Type)i.next();
            if (!(sup2 instanceof ClassType)) continue;
            Resolver r = this.ts.classContextResolver((ClassType)sup2, accessor);
            try {
                Named n2 = r.find(name);
                acceptable.add(n2);
            }
            catch (SemanticException e) {}
        }
        if (acceptable.size() == 0) {
            throw new NoClassException(name, this.type);
        }
        if (acceptable.size() > 1) {
            HashSet<ReferenceType> containers = new HashSet<ReferenceType>(acceptable.size());
            Iterator i2 = acceptable.iterator();
            while (i2.hasNext()) {
                n = (Named)i2.next();
                if (!(n instanceof MemberInstance)) continue;
                MemberInstance mi = (MemberInstance)((Object)n);
                containers.add(mi.container());
            }
            if (containers.size() == 2) {
                i2 = containers.iterator();
                Type t1 = (Type)i2.next();
                Type t2 = (Type)i2.next();
                throw new SemanticException("Member \"" + name + "\" of " + this.type + " is ambiguous; it is defined in both " + t1 + " and " + t2 + ".");
            }
            throw new SemanticException("Member \"" + name + "\" of " + this.type + " is ambiguous; it is defined in " + containers + ".");
        }
        Named t = (Named)acceptable.iterator().next();
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Found member class " + t);
        }
        return t;
    }

    protected boolean canAccess(Named n, ClassType accessor) {
        if (n instanceof MemberInstance) {
            return accessor == null || this.ts.isAccessible((MemberInstance)((Object)n), accessor);
        }
        return true;
    }

    public ClassType classType() {
        return this.type;
    }
}

