/*
 * Decompiled with CFR 0.152.
 */
package polyglot.parse;

import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.NodeFactory;
import polyglot.ast.PackageNode;
import polyglot.ast.Prefix;
import polyglot.ast.QualifierNode;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;

public class Name {
    public final Name prefix;
    public final Id name;
    public final Position pos;
    public final NodeFactory nf;
    public final TypeSystem ts;

    public Name(NodeFactory nf, TypeSystem ts, Position pos, Id name) {
        this(nf, ts, pos, null, name);
    }

    public Name(NodeFactory nf, TypeSystem ts, Position pos, Name prefix, Id name) {
        this.nf = nf;
        this.ts = ts;
        this.pos = pos != null ? pos : Position.COMPILER_GENERATED;
        this.prefix = prefix;
        this.name = name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Name(NodeFactory nf, TypeSystem ts, Position pos, Name prefix, String qualifiedName) {
        this.nf = nf;
        this.ts = ts;
        Position position = this.pos = pos != null ? pos : Position.COMPILER_GENERATED;
        if (!StringUtil.isNameShort(qualifiedName)) {
            if (prefix != null) throw new InternalCompilerError("Can only construct a qualified Name with a short name string: " + qualifiedName + " is not short.");
            Position prefixPos = pos.truncateEnd(qualifiedName.length() + 1);
            Position namePos = new Position(pos.truncateEnd(qualifiedName.length()).endOf(), pos.endOf());
            this.prefix = new Name(nf, ts, prefixPos, null, StringUtil.getPackageComponent(qualifiedName));
            this.name = nf.Id(namePos, StringUtil.getShortNameComponent(qualifiedName));
            return;
        } else {
            Position idPos = prefix == null ? pos : new Position(pos.truncateEnd(qualifiedName.length()).endOf(), pos.endOf());
            this.prefix = prefix;
            this.name = nf.Id(idPos, qualifiedName);
        }
    }

    public Expr toExpr() {
        if (this.prefix == null) {
            return this.nf.AmbExpr(this.pos, this.name);
        }
        return this.nf.Field(this.pos, this.prefix.toReceiver(), this.name);
    }

    public Receiver toReceiver() {
        if (this.prefix == null) {
            return this.nf.AmbReceiver(this.pos, this.name);
        }
        return this.nf.AmbReceiver(this.pos, this.prefix.toPrefix(), this.name);
    }

    public Prefix toPrefix() {
        if (this.prefix == null) {
            return this.nf.AmbPrefix(this.pos, this.name);
        }
        return this.nf.AmbPrefix(this.pos, this.prefix.toPrefix(), this.name);
    }

    public QualifierNode toQualifier() {
        if (this.prefix == null) {
            return this.nf.AmbQualifierNode(this.pos, this.name);
        }
        return this.nf.AmbQualifierNode(this.pos, this.prefix.toQualifier(), this.name);
    }

    public PackageNode toPackage() {
        if (this.prefix == null) {
            return this.nf.PackageNode(this.pos, this.ts.createPackage(null, this.name.id()));
        }
        return this.nf.PackageNode(this.pos, this.ts.createPackage(this.prefix.toPackage().package_(), this.name.id()));
    }

    public TypeNode toType() {
        if (this.prefix == null) {
            return this.nf.AmbTypeNode(this.pos, this.name);
        }
        return this.nf.AmbTypeNode(this.pos, this.prefix.toQualifier(), this.name);
    }

    public String toString() {
        if (this.prefix == null) {
            return this.name.toString();
        }
        return this.prefix.toString() + "." + this.name.toString();
    }
}

