/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.IOException;
import java.io.Reader;
import polyglot.ast.Node;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.Compiler;
import polyglot.frontend.FileSource;
import polyglot.frontend.Parser;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;

public class ParserPass
extends AbstractPass {
    protected Compiler compiler;

    public ParserPass(Compiler compiler, Goal goal) {
        super(goal);
        this.compiler = compiler;
    }

    public boolean run() {
        ErrorQueue eq = this.compiler.errorQueue();
        FileSource source = (FileSource)this.goal.job().source();
        try {
            Reader reader = source.open();
            Parser p = this.goal.job().extensionInfo().parser(reader, source, eq);
            if (Report.should_report("frontend", 2)) {
                Report.report(2, "Using parser " + p);
            }
            Node ast = p.parse();
            source.close();
            if (ast != null) {
                this.goal.job().ast(ast);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            eq.enqueue(2, e.getMessage(), new Position(this.goal.job().source().path(), this.goal.job().source().name(), 1, 1, 1, 1));
            return false;
        }
    }

    public String toString() {
        return super.toString() + "(" + this.goal.job().source() + ")";
    }
}

