/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Synchronized;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Synchronized_c
extends Stmt_c
implements Synchronized {
    protected Expr expr;
    protected Block body;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Synchronized_c(Position pos, Expr expr, Block body) {
        super(pos);
        if (!($assertionsDisabled || expr != null && body != null)) {
            throw new AssertionError();
        }
        this.expr = expr;
        this.body = body;
    }

    public Expr expr() {
        return this.expr;
    }

    public Synchronized expr(Expr expr) {
        Synchronized_c n = (Synchronized_c)this.copy();
        n.expr = expr;
        return n;
    }

    public Block body() {
        return this.body;
    }

    public Synchronized body(Block body) {
        Synchronized_c n = (Synchronized_c)this.copy();
        n.body = body;
        return n;
    }

    protected Synchronized_c reconstruct(Expr expr, Block body) {
        if (expr != this.expr || body != this.body) {
            Synchronized_c n = (Synchronized_c)this.copy();
            n.expr = expr;
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild(this.expr, v);
        Block body = (Block)this.visitChild(this.body, v);
        return this.reconstruct(expr, body);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.isSubtype(this.expr.type(), ts.Object())) {
            throw new SemanticException("Cannot synchronize on an expression of type \"" + this.expr.type() + "\".", this.expr.position());
        }
        return this;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Object();
        }
        return child.type();
    }

    public String toString() {
        return "synchronized (" + this.expr + ") { ... }";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("synchronized (");
        this.printBlock(this.expr, w, tr);
        w.write(") ");
        this.printSubStmt(this.body, w, tr);
    }

    public Term firstChild() {
        return this.expr;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG(this.expr, this.body, 1);
        v.visitCFG(this.body, this, 0);
        return succs;
    }

    public Node copy(NodeFactory nf) {
        return nf.Synchronized(this.position, this.expr, this.body);
    }

    static {
        $assertionsDisabled = !Synchronized_c.class.desiredAssertionStatus();
    }
}

