/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Case;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Switch;
import polyglot.ast.SwitchElement;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Switch_c
extends Stmt_c
implements Switch {
    protected Expr expr;
    protected List elements;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Switch_c(Position pos, Expr expr, List elements) {
        super(pos);
        if (!($assertionsDisabled || expr != null && elements != null)) {
            throw new AssertionError();
        }
        this.expr = expr;
        this.elements = TypedList.copyAndCheck(elements, SwitchElement.class, true);
    }

    public Expr expr() {
        return this.expr;
    }

    public Switch expr(Expr expr) {
        Switch_c n = (Switch_c)this.copy();
        n.expr = expr;
        return n;
    }

    public List elements() {
        return Collections.unmodifiableList(this.elements);
    }

    public Switch elements(List elements) {
        Switch_c n = (Switch_c)this.copy();
        n.elements = TypedList.copyAndCheck(elements, SwitchElement.class, true);
        return n;
    }

    protected Switch_c reconstruct(Expr expr, List elements) {
        if (expr != this.expr || !CollectionUtil.equals(elements, this.elements)) {
            Switch_c n = (Switch_c)this.copy();
            n.expr = expr;
            n.elements = TypedList.copyAndCheck(elements, SwitchElement.class, true);
            return n;
        }
        return this;
    }

    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild(this.expr, v);
        List elements = this.visitList(this.elements, v);
        return this.reconstruct(expr, elements);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.isImplicitCastValid(this.expr.type(), ts.Int())) {
            throw new SemanticException("Switch index must be an integer.", this.position());
        }
        return this;
    }

    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        HashSet<String> labels = new HashSet<String>();
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            String str;
            Object key;
            SwitchElement s = (SwitchElement)i.next();
            if (!(s instanceof Case)) continue;
            Case c = (Case)s;
            if (c.isDefault()) {
                key = "default";
                str = "default";
            } else {
                if (!c.expr().constantValueSet()) {
                    return this;
                }
                if (!c.expr().isConstant()) continue;
                key = new Long(c.value());
                str = c.expr().toString() + " (" + c.value() + ")";
            }
            if (labels.contains(key)) {
                throw new SemanticException("Duplicate case label: " + str + ".", c.position());
            }
            labels.add((String)key);
        }
        return this;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Int();
        }
        return child.type();
    }

    public String toString() {
        return "switch (" + this.expr + ") { ... }";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("switch (");
        this.printBlock(this.expr, w, tr);
        w.write(") {");
        w.unifiedBreak(4);
        w.begin(0);
        boolean lastWasCase = false;
        boolean first = true;
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            SwitchElement s = (SwitchElement)i.next();
            if (s instanceof Case) {
                if (lastWasCase) {
                    w.unifiedBreak(0);
                } else if (!first) {
                    w.unifiedBreak(0);
                }
                this.printBlock(s, w, tr);
                lastWasCase = true;
            } else {
                w.unifiedBreak(4);
                this.print(s, w, tr);
                lastWasCase = false;
            }
            first = false;
        }
        w.end();
        w.unifiedBreak(0);
        w.write("}");
    }

    public Term firstChild() {
        return this.expr;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        Object prev = null;
        LinkedList<Stmt> cases = new LinkedList<Stmt>();
        LinkedList<Integer> entry = new LinkedList<Integer>();
        boolean hasDefault = false;
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            SwitchElement s = (SwitchElement)i.next();
            if (!(s instanceof Case)) continue;
            cases.add(s);
            entry.add(new Integer(1));
            if (((Case)s).expr() != null) continue;
            hasDefault = true;
        }
        if (!hasDefault) {
            cases.add(this);
            entry.add(new Integer(0));
        }
        v.visitCFG((Term)this.expr, FlowGraph.EDGE_KEY_OTHER, cases, entry);
        v.push(this).visitCFGList(this.elements, this, 0);
        return succs;
    }

    public Node copy(NodeFactory nf) {
        return nf.Switch(this.position, this.expr, this.elements);
    }

    static {
        $assertionsDisabled = !Switch_c.class.desiredAssertionStatus();
    }
}

