/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.AbstractDelFactory_c;
import polyglot.ast.AbstractExtFactory_c;
import polyglot.ast.AbstractNodeFactory_c;
import polyglot.ast.AmbAssign;
import polyglot.ast.AmbAssign_c;
import polyglot.ast.AmbExpr;
import polyglot.ast.AmbExpr_c;
import polyglot.ast.AmbPrefix;
import polyglot.ast.AmbPrefix_c;
import polyglot.ast.AmbQualifierNode;
import polyglot.ast.AmbQualifierNode_c;
import polyglot.ast.AmbReceiver;
import polyglot.ast.AmbReceiver_c;
import polyglot.ast.AmbTypeNode;
import polyglot.ast.AmbTypeNode_c;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayAccessAssign;
import polyglot.ast.ArrayAccessAssign_c;
import polyglot.ast.ArrayAccess_c;
import polyglot.ast.ArrayInit;
import polyglot.ast.ArrayInit_c;
import polyglot.ast.ArrayTypeNode;
import polyglot.ast.ArrayTypeNode_c;
import polyglot.ast.Assert;
import polyglot.ast.Assert_c;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Binary_c;
import polyglot.ast.Block;
import polyglot.ast.Block_c;
import polyglot.ast.BooleanLit;
import polyglot.ast.BooleanLit_c;
import polyglot.ast.Branch;
import polyglot.ast.Branch_c;
import polyglot.ast.Call;
import polyglot.ast.Call_c;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.CanonicalTypeNode_c;
import polyglot.ast.Case;
import polyglot.ast.Case_c;
import polyglot.ast.Cast;
import polyglot.ast.Cast_c;
import polyglot.ast.Catch;
import polyglot.ast.Catch_c;
import polyglot.ast.CharLit;
import polyglot.ast.CharLit_c;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassBody_c;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassDecl_c;
import polyglot.ast.ClassLit;
import polyglot.ast.ClassLit_c;
import polyglot.ast.Conditional;
import polyglot.ast.Conditional_c;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorCall_c;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.ConstructorDecl_c;
import polyglot.ast.DelFactory;
import polyglot.ast.Do;
import polyglot.ast.Do_c;
import polyglot.ast.Empty;
import polyglot.ast.Empty_c;
import polyglot.ast.Eval;
import polyglot.ast.Eval_c;
import polyglot.ast.Expr;
import polyglot.ast.ExtFactory;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldAssign_c;
import polyglot.ast.FieldDecl;
import polyglot.ast.FieldDecl_c;
import polyglot.ast.Field_c;
import polyglot.ast.FloatLit;
import polyglot.ast.FloatLit_c;
import polyglot.ast.For;
import polyglot.ast.For_c;
import polyglot.ast.Formal;
import polyglot.ast.Formal_c;
import polyglot.ast.Id;
import polyglot.ast.Id_c;
import polyglot.ast.If;
import polyglot.ast.If_c;
import polyglot.ast.Import;
import polyglot.ast.Import_c;
import polyglot.ast.Initializer;
import polyglot.ast.Initializer_c;
import polyglot.ast.Instanceof;
import polyglot.ast.Instanceof_c;
import polyglot.ast.IntLit;
import polyglot.ast.IntLit_c;
import polyglot.ast.Labeled;
import polyglot.ast.Labeled_c;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalAssign_c;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.LocalClassDecl_c;
import polyglot.ast.LocalDecl;
import polyglot.ast.LocalDecl_c;
import polyglot.ast.Local_c;
import polyglot.ast.MethodDecl;
import polyglot.ast.MethodDecl_c;
import polyglot.ast.New;
import polyglot.ast.NewArray;
import polyglot.ast.NewArray_c;
import polyglot.ast.New_c;
import polyglot.ast.NodeFactory;
import polyglot.ast.NodeList;
import polyglot.ast.NodeList_c;
import polyglot.ast.NullLit;
import polyglot.ast.NullLit_c;
import polyglot.ast.PackageNode;
import polyglot.ast.PackageNode_c;
import polyglot.ast.Prefix;
import polyglot.ast.QualifierNode;
import polyglot.ast.Receiver;
import polyglot.ast.Return;
import polyglot.ast.Return_c;
import polyglot.ast.SourceCollection;
import polyglot.ast.SourceCollection_c;
import polyglot.ast.SourceFile;
import polyglot.ast.SourceFile_c;
import polyglot.ast.Special;
import polyglot.ast.Special_c;
import polyglot.ast.Stmt;
import polyglot.ast.StringLit;
import polyglot.ast.StringLit_c;
import polyglot.ast.Switch;
import polyglot.ast.SwitchBlock;
import polyglot.ast.SwitchBlock_c;
import polyglot.ast.Switch_c;
import polyglot.ast.Synchronized;
import polyglot.ast.Synchronized_c;
import polyglot.ast.Throw;
import polyglot.ast.Throw_c;
import polyglot.ast.Try;
import polyglot.ast.Try_c;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.ast.Unary_c;
import polyglot.ast.While;
import polyglot.ast.While_c;
import polyglot.types.Flags;
import polyglot.types.Package;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class NodeFactory_c
extends AbstractNodeFactory_c {
    private final ExtFactory extFactory;
    private final DelFactory delFactory;

    public NodeFactory_c() {
        this(new EmptyExtFactory(), new EmptyDelFactory());
    }

    public NodeFactory_c(ExtFactory extFactory) {
        this(extFactory, new EmptyDelFactory());
    }

    public NodeFactory_c(ExtFactory extFactory, DelFactory delFactory) {
        this.extFactory = extFactory;
        this.delFactory = delFactory;
    }

    protected ExtFactory extFactory() {
        return this.extFactory;
    }

    protected DelFactory delFactory() {
        return this.delFactory;
    }

    protected final ExtFactory findExtFactInstance(Class c) {
        for (ExtFactory e = this.extFactory(); e != null; e = e.nextExtFactory()) {
            if (!c.isInstance(e)) continue;
            return e;
        }
        return null;
    }

    public Id Id(Position pos, String name) {
        Id n = new Id_c(pos, name);
        n = (Id)n.ext(this.extFactory.extId());
        n = (Id)n.del(this.delFactory.delId());
        return n;
    }

    public AmbPrefix AmbPrefix(Position pos, Prefix prefix, Id name) {
        AmbPrefix n = new AmbPrefix_c(pos, prefix, name);
        n = (AmbPrefix)n.ext(this.extFactory.extAmbPrefix());
        n = (AmbPrefix)n.del(this.delFactory.delAmbPrefix());
        return n;
    }

    public AmbReceiver AmbReceiver(Position pos, Prefix prefix, Id name) {
        AmbReceiver n = new AmbReceiver_c(pos, prefix, name);
        n = (AmbReceiver)n.ext(this.extFactory.extAmbReceiver());
        n = (AmbReceiver)n.del(this.delFactory.delAmbReceiver());
        return n;
    }

    public AmbQualifierNode AmbQualifierNode(Position pos, QualifierNode qualifier, Id name) {
        AmbQualifierNode n = new AmbQualifierNode_c(pos, qualifier, name);
        n = (AmbQualifierNode)n.ext(this.extFactory.extAmbQualifierNode());
        n = (AmbQualifierNode)n.del(this.delFactory.delAmbQualifierNode());
        return n;
    }

    public AmbExpr AmbExpr(Position pos, Id name) {
        AmbExpr n = new AmbExpr_c(pos, name);
        n = (AmbExpr)n.ext(this.extFactory.extAmbExpr());
        n = (AmbExpr)n.del(this.delFactory.delAmbExpr());
        return n;
    }

    public AmbTypeNode AmbTypeNode(Position pos, QualifierNode qualifier, Id name) {
        AmbTypeNode n = new AmbTypeNode_c(pos, qualifier, name);
        n = (AmbTypeNode)n.ext(this.extFactory.extAmbTypeNode());
        n = (AmbTypeNode)n.del(this.delFactory.delAmbTypeNode());
        return n;
    }

    public ArrayAccess ArrayAccess(Position pos, Expr base, Expr index) {
        ArrayAccess n = new ArrayAccess_c(pos, base, index);
        n = (ArrayAccess)n.ext(this.extFactory.extArrayAccess());
        n = (ArrayAccess)n.del(this.delFactory.delArrayAccess());
        return n;
    }

    public ArrayInit ArrayInit(Position pos, List elements) {
        ArrayInit n = new ArrayInit_c(pos, CollectionUtil.nonNullList(elements));
        n = (ArrayInit)n.ext(this.extFactory.extArrayInit());
        n = (ArrayInit)n.del(this.delFactory.delArrayInit());
        return n;
    }

    public Assert Assert(Position pos, Expr cond, Expr errorMessage) {
        Assert n = new Assert_c(pos, cond, errorMessage);
        n = (Assert)n.ext(this.extFactory.extAssert());
        n = (Assert)n.del(this.delFactory.delAssert());
        return n;
    }

    public Assign Assign(Position pos, Expr left, Assign.Operator op, Expr right) {
        if (left instanceof Local) {
            return this.LocalAssign(pos, (Local)left, op, right);
        }
        if (left instanceof Field) {
            return this.FieldAssign(pos, (Field)left, op, right);
        }
        if (left instanceof ArrayAccess) {
            return this.ArrayAccessAssign(pos, (ArrayAccess)left, op, right);
        }
        return this.AmbAssign(pos, left, op, right);
    }

    public LocalAssign LocalAssign(Position pos, Local left, Assign.Operator op, Expr right) {
        LocalAssign n = new LocalAssign_c(pos, left, op, right);
        n = (LocalAssign)n.ext(this.extFactory.extLocalAssign());
        n = (LocalAssign)n.del(this.delFactory.delLocalAssign());
        return n;
    }

    public FieldAssign FieldAssign(Position pos, Field left, Assign.Operator op, Expr right) {
        FieldAssign n = new FieldAssign_c(pos, left, op, right);
        n = (FieldAssign)n.ext(this.extFactory.extFieldAssign());
        n = (FieldAssign)n.del(this.delFactory.delFieldAssign());
        return n;
    }

    public ArrayAccessAssign ArrayAccessAssign(Position pos, ArrayAccess left, Assign.Operator op, Expr right) {
        ArrayAccessAssign n = new ArrayAccessAssign_c(pos, left, op, right);
        n = (ArrayAccessAssign)n.ext(this.extFactory.extArrayAccessAssign());
        n = (ArrayAccessAssign)n.del(this.delFactory.delArrayAccessAssign());
        return n;
    }

    public AmbAssign AmbAssign(Position pos, Expr left, Assign.Operator op, Expr right) {
        AmbAssign n = new AmbAssign_c(pos, left, op, right);
        n = (AmbAssign)n.ext(this.extFactory.extAmbAssign());
        n = (AmbAssign)n.del(this.delFactory.delAmbAssign());
        return n;
    }

    public Binary Binary(Position pos, Expr left, Binary.Operator op, Expr right) {
        Binary n = new Binary_c(pos, left, op, right);
        n = (Binary)n.ext(this.extFactory.extBinary());
        n = (Binary)n.del(this.delFactory.delBinary());
        return n;
    }

    public Block Block(Position pos, List statements) {
        Block n = new Block_c(pos, CollectionUtil.nonNullList(statements));
        n = (Block)n.ext(this.extFactory.extBlock());
        n = (Block)n.del(this.delFactory.delBlock());
        return n;
    }

    public SwitchBlock SwitchBlock(Position pos, List statements) {
        SwitchBlock n = new SwitchBlock_c(pos, CollectionUtil.nonNullList(statements));
        n = (SwitchBlock)n.ext(this.extFactory.extSwitchBlock());
        n = (SwitchBlock)n.del(this.delFactory.delSwitchBlock());
        return n;
    }

    public BooleanLit BooleanLit(Position pos, boolean value) {
        BooleanLit n = new BooleanLit_c(pos, value);
        n = (BooleanLit)n.ext(this.extFactory.extBooleanLit());
        n = (BooleanLit)n.del(this.delFactory.delBooleanLit());
        return n;
    }

    public Branch Branch(Position pos, Branch.Kind kind, Id label) {
        Branch n = new Branch_c(pos, kind, label);
        n = (Branch)n.ext(this.extFactory.extBranch());
        n = (Branch)n.del(this.delFactory.delBranch());
        return n;
    }

    public Call Call(Position pos, Receiver target, Id name, List args) {
        Call n = new Call_c(pos, target, name, CollectionUtil.nonNullList(args));
        n = (Call)n.ext(this.extFactory.extCall());
        n = (Call)n.del(this.delFactory.delCall());
        return n;
    }

    public Case Case(Position pos, Expr expr) {
        Case n = new Case_c(pos, expr);
        n = (Case)n.ext(this.extFactory.extCase());
        n = (Case)n.del(this.delFactory.delCase());
        return n;
    }

    public Cast Cast(Position pos, TypeNode type, Expr expr) {
        Cast n = new Cast_c(pos, type, expr);
        n = (Cast)n.ext(this.extFactory.extCast());
        n = (Cast)n.del(this.delFactory.delCast());
        return n;
    }

    public Catch Catch(Position pos, Formal formal, Block body) {
        Catch n = new Catch_c(pos, formal, body);
        n = (Catch)n.ext(this.extFactory.extCatch());
        n = (Catch)n.del(this.delFactory.delCatch());
        return n;
    }

    public CharLit CharLit(Position pos, char value) {
        CharLit n = new CharLit_c(pos, value);
        n = (CharLit)n.ext(this.extFactory.extCharLit());
        n = (CharLit)n.del(this.delFactory.delCharLit());
        return n;
    }

    public ClassBody ClassBody(Position pos, List members) {
        ClassBody n = new ClassBody_c(pos, CollectionUtil.nonNullList(members));
        n = (ClassBody)n.ext(this.extFactory.extClassBody());
        n = (ClassBody)n.del(this.delFactory.delClassBody());
        return n;
    }

    public ClassDecl ClassDecl(Position pos, Flags flags, Id name, TypeNode superClass, List interfaces, ClassBody body) {
        ClassDecl n = new ClassDecl_c(pos, flags, name, superClass, CollectionUtil.nonNullList(interfaces), body);
        n = (ClassDecl)n.ext(this.extFactory.extClassDecl());
        n = (ClassDecl)n.del(this.delFactory.delClassDecl());
        return n;
    }

    public ClassLit ClassLit(Position pos, TypeNode typeNode) {
        ClassLit n = new ClassLit_c(pos, typeNode);
        n = (ClassLit)n.ext(this.extFactory.extClassLit());
        n = (ClassLit)n.del(this.delFactory.delClassLit());
        return n;
    }

    public Conditional Conditional(Position pos, Expr cond, Expr consequent, Expr alternative) {
        Conditional n = new Conditional_c(pos, cond, consequent, alternative);
        n = (Conditional)n.ext(this.extFactory.extConditional());
        n = (Conditional)n.del(this.delFactory.delConditional());
        return n;
    }

    public ConstructorCall ConstructorCall(Position pos, ConstructorCall.Kind kind, Expr outer, List args) {
        ConstructorCall n = new ConstructorCall_c(pos, kind, outer, CollectionUtil.nonNullList(args));
        n = (ConstructorCall)n.ext(this.extFactory.extConstructorCall());
        n = (ConstructorCall)n.del(this.delFactory.delConstructorCall());
        return n;
    }

    public ConstructorDecl ConstructorDecl(Position pos, Flags flags, Id name, List formals, List throwTypes, Block body) {
        ConstructorDecl n = new ConstructorDecl_c(pos, flags, name, CollectionUtil.nonNullList(formals), CollectionUtil.nonNullList(throwTypes), body);
        n = (ConstructorDecl)n.ext(this.extFactory.extConstructorDecl());
        n = (ConstructorDecl)n.del(this.delFactory.delConstructorDecl());
        return n;
    }

    public FieldDecl FieldDecl(Position pos, Flags flags, TypeNode type, Id name, Expr init) {
        FieldDecl n = new FieldDecl_c(pos, flags, type, name, init);
        n = (FieldDecl)n.ext(this.extFactory.extFieldDecl());
        n = (FieldDecl)n.del(this.delFactory.delFieldDecl());
        return n;
    }

    public Do Do(Position pos, Stmt body, Expr cond) {
        Do n = new Do_c(pos, body, cond);
        n = (Do)n.ext(this.extFactory.extDo());
        n = (Do)n.del(this.delFactory.delDo());
        return n;
    }

    public Empty Empty(Position pos) {
        Empty n = new Empty_c(pos);
        n = (Empty)n.ext(this.extFactory.extEmpty());
        n = (Empty)n.del(this.delFactory.delEmpty());
        return n;
    }

    public Eval Eval(Position pos, Expr expr) {
        Eval n = new Eval_c(pos, expr);
        n = (Eval)n.ext(this.extFactory.extEval());
        n = (Eval)n.del(this.delFactory.delEval());
        return n;
    }

    public Field Field(Position pos, Receiver target, Id name) {
        Field n = new Field_c(pos, target, name);
        n = (Field)n.ext(this.extFactory.extField());
        n = (Field)n.del(this.delFactory.delField());
        return n;
    }

    public FloatLit FloatLit(Position pos, FloatLit.Kind kind, double value) {
        FloatLit n = new FloatLit_c(pos, kind, value);
        n = (FloatLit)n.ext(this.extFactory.extFloatLit());
        n = (FloatLit)n.del(this.delFactory.delFloatLit());
        return n;
    }

    public For For(Position pos, List inits, Expr cond, List iters, Stmt body) {
        For n = new For_c(pos, CollectionUtil.nonNullList(inits), cond, CollectionUtil.nonNullList(iters), body);
        n = (For)n.ext(this.extFactory.extFor());
        n = (For)n.del(this.delFactory.delFor());
        return n;
    }

    public Formal Formal(Position pos, Flags flags, TypeNode type, Id name) {
        Formal n = new Formal_c(pos, flags, type, name);
        n = (Formal)n.ext(this.extFactory.extFormal());
        n = (Formal)n.del(this.delFactory.delFormal());
        return n;
    }

    public If If(Position pos, Expr cond, Stmt consequent, Stmt alternative) {
        If n = new If_c(pos, cond, consequent, alternative);
        n = (If)n.ext(this.extFactory.extIf());
        n = (If)n.del(this.delFactory.delIf());
        return n;
    }

    public Import Import(Position pos, Import.Kind kind, String name) {
        Import n = new Import_c(pos, kind, name);
        n = (Import)n.ext(this.extFactory.extImport());
        n = (Import)n.del(this.delFactory.delImport());
        return n;
    }

    public Initializer Initializer(Position pos, Flags flags, Block body) {
        Initializer n = new Initializer_c(pos, flags, body);
        n = (Initializer)n.ext(this.extFactory.extInitializer());
        n = (Initializer)n.del(this.delFactory.delInitializer());
        return n;
    }

    public Instanceof Instanceof(Position pos, Expr expr, TypeNode type) {
        Instanceof n = new Instanceof_c(pos, expr, type);
        n = (Instanceof)n.ext(this.extFactory.extInstanceof());
        n = (Instanceof)n.del(this.delFactory.delInstanceof());
        return n;
    }

    public IntLit IntLit(Position pos, IntLit.Kind kind, long value) {
        IntLit n = new IntLit_c(pos, kind, value);
        n = (IntLit)n.ext(this.extFactory.extIntLit());
        n = (IntLit)n.del(this.delFactory.delIntLit());
        return n;
    }

    public Labeled Labeled(Position pos, Id label, Stmt body) {
        Labeled n = new Labeled_c(pos, label, body);
        n = (Labeled)n.ext(this.extFactory.extLabeled());
        n = (Labeled)n.del(this.delFactory.delLabeled());
        return n;
    }

    public Local Local(Position pos, Id name) {
        Local n = new Local_c(pos, name);
        n = (Local)n.ext(this.extFactory.extLocal());
        n = (Local)n.del(this.delFactory.delLocal());
        return n;
    }

    public LocalClassDecl LocalClassDecl(Position pos, ClassDecl decl) {
        LocalClassDecl n = new LocalClassDecl_c(pos, decl);
        n = (LocalClassDecl)n.ext(this.extFactory.extLocalClassDecl());
        n = (LocalClassDecl)n.del(this.delFactory.delLocalClassDecl());
        return n;
    }

    public LocalDecl LocalDecl(Position pos, Flags flags, TypeNode type, Id name, Expr init) {
        LocalDecl n = new LocalDecl_c(pos, flags, type, name, init);
        n = (LocalDecl)n.ext(this.extFactory.extLocalDecl());
        n = (LocalDecl)n.del(this.delFactory.delLocalDecl());
        return n;
    }

    public MethodDecl MethodDecl(Position pos, Flags flags, TypeNode returnType, Id name, List formals, List throwTypes, Block body) {
        MethodDecl n = new MethodDecl_c(pos, flags, returnType, name, CollectionUtil.nonNullList(formals), CollectionUtil.nonNullList(throwTypes), body);
        n = (MethodDecl)n.ext(this.extFactory.extMethodDecl());
        n = (MethodDecl)n.del(this.delFactory.delMethodDecl());
        return n;
    }

    public New New(Position pos, Expr outer, TypeNode objectType, List args, ClassBody body) {
        New n = new New_c(pos, outer, objectType, CollectionUtil.nonNullList(args), body);
        n = (New)n.ext(this.extFactory.extNew());
        n = (New)n.del(this.delFactory.delNew());
        return n;
    }

    public NewArray NewArray(Position pos, TypeNode base, List dims, int addDims, ArrayInit init) {
        NewArray n = new NewArray_c(pos, base, CollectionUtil.nonNullList(dims), addDims, init);
        n = (NewArray)n.ext(this.extFactory.extNewArray());
        n = (NewArray)n.del(this.delFactory.delNewArray());
        return n;
    }

    public NodeList NodeList(Position pos, NodeFactory nf, List nodes) {
        NodeList n = new NodeList_c(pos, nf, nodes);
        n = (NodeList)n.ext(this.extFactory.extNodeList());
        n = (NodeList)n.del(this.delFactory.delNodeList());
        return n;
    }

    public NullLit NullLit(Position pos) {
        NullLit n = new NullLit_c(pos);
        n = (NullLit)n.ext(this.extFactory.extNullLit());
        n = (NullLit)n.del(this.delFactory.delNullLit());
        return n;
    }

    public Return Return(Position pos, Expr expr) {
        Return n = new Return_c(pos, expr);
        n = (Return)n.ext(this.extFactory.extReturn());
        n = (Return)n.del(this.delFactory.delReturn());
        return n;
    }

    public SourceCollection SourceCollection(Position pos, List sources) {
        SourceCollection n = new SourceCollection_c(pos, CollectionUtil.nonNullList(sources));
        n = (SourceCollection)n.ext(this.extFactory.extSourceCollection());
        n = (SourceCollection)n.del(this.delFactory.delSourceCollection());
        return n;
    }

    public SourceFile SourceFile(Position pos, PackageNode packageName, List imports, List decls) {
        SourceFile n = new SourceFile_c(pos, packageName, CollectionUtil.nonNullList(imports), CollectionUtil.nonNullList(decls));
        n = (SourceFile)n.ext(this.extFactory.extSourceFile());
        n = (SourceFile)n.del(this.delFactory.delSourceFile());
        return n;
    }

    public Special Special(Position pos, Special.Kind kind, TypeNode outer) {
        Special n = new Special_c(pos, kind, outer);
        n = (Special)n.ext(this.extFactory.extSpecial());
        n = (Special)n.del(this.delFactory.delSpecial());
        return n;
    }

    public StringLit StringLit(Position pos, String value) {
        StringLit n = new StringLit_c(pos, value);
        n = (StringLit)n.ext(this.extFactory.extStringLit());
        n = (StringLit)n.del(this.delFactory.delStringLit());
        return n;
    }

    public Switch Switch(Position pos, Expr expr, List elements) {
        Switch n = new Switch_c(pos, expr, CollectionUtil.nonNullList(elements));
        n = (Switch)n.ext(this.extFactory.extSwitch());
        n = (Switch)n.del(this.delFactory.delSwitch());
        return n;
    }

    public Synchronized Synchronized(Position pos, Expr expr, Block body) {
        Synchronized n = new Synchronized_c(pos, expr, body);
        n = (Synchronized)n.ext(this.extFactory.extSynchronized());
        n = (Synchronized)n.del(this.delFactory.delSynchronized());
        return n;
    }

    public Throw Throw(Position pos, Expr expr) {
        Throw n = new Throw_c(pos, expr);
        n = (Throw)n.ext(this.extFactory.extThrow());
        n = (Throw)n.del(this.delFactory.delThrow());
        return n;
    }

    public Try Try(Position pos, Block tryBlock, List catchBlocks, Block finallyBlock) {
        Try n = new Try_c(pos, tryBlock, CollectionUtil.nonNullList(catchBlocks), finallyBlock);
        n = (Try)n.ext(this.extFactory.extTry());
        n = (Try)n.del(this.delFactory.delTry());
        return n;
    }

    public ArrayTypeNode ArrayTypeNode(Position pos, TypeNode base) {
        ArrayTypeNode n = new ArrayTypeNode_c(pos, base);
        n = (ArrayTypeNode)n.ext(this.extFactory.extArrayTypeNode());
        n = (ArrayTypeNode)n.del(this.delFactory.delArrayTypeNode());
        return n;
    }

    public CanonicalTypeNode CanonicalTypeNode(Position pos, Type type) {
        if (!type.isCanonical()) {
            throw new InternalCompilerError("Cannot construct a canonical type node for a non-canonical type.");
        }
        CanonicalTypeNode n = new CanonicalTypeNode_c(pos, type);
        n = (CanonicalTypeNode)n.ext(this.extFactory.extCanonicalTypeNode());
        n = (CanonicalTypeNode)n.del(this.delFactory.delCanonicalTypeNode());
        return n;
    }

    public PackageNode PackageNode(Position pos, Package p) {
        PackageNode n = new PackageNode_c(pos, p);
        n = (PackageNode)n.ext(this.extFactory.extPackageNode());
        n = (PackageNode)n.del(this.delFactory.delPackageNode());
        return n;
    }

    public Unary Unary(Position pos, Unary.Operator op, Expr expr) {
        Unary n = new Unary_c(pos, op, expr);
        n = (Unary)n.ext(this.extFactory.extUnary());
        n = (Unary)n.del(this.delFactory.delUnary());
        return n;
    }

    public While While(Position pos, Expr cond, Stmt body) {
        While n = new While_c(pos, cond, body);
        n = (While)n.ext(this.extFactory.extWhile());
        n = (While)n.del(this.delFactory.delWhile());
        return n;
    }

    protected static class EmptyDelFactory
    extends AbstractDelFactory_c {
        protected EmptyDelFactory() {
        }
    }

    protected static class EmptyExtFactory
    extends AbstractExtFactory_c {
        protected EmptyExtFactory() {
        }
    }
}

