/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.ArrayType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class NewArray_c
extends Expr_c
implements NewArray {
    protected TypeNode baseType;
    protected List dims;
    protected int addDims;
    protected ArrayInit init;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NewArray_c(Position pos, TypeNode baseType, List dims, int addDims, ArrayInit init) {
        super(pos);
        if (!($assertionsDisabled || baseType != null && dims != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && addDims < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dims.isEmpty() && init == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && addDims <= 0 && init != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dims.size() + addDims <= 0) {
            throw new AssertionError();
        }
        this.baseType = baseType;
        this.dims = TypedList.copyAndCheck(dims, Expr.class, true);
        this.addDims = addDims;
        this.init = init;
    }

    public TypeNode baseType() {
        return this.baseType;
    }

    public NewArray baseType(TypeNode baseType) {
        NewArray_c n = (NewArray_c)this.copy();
        n.baseType = baseType;
        return n;
    }

    public List dims() {
        return Collections.unmodifiableList(this.dims);
    }

    public NewArray dims(List dims) {
        NewArray_c n = (NewArray_c)this.copy();
        n.dims = TypedList.copyAndCheck(dims, Expr.class, true);
        return n;
    }

    public int numDims() {
        return this.dims.size() + this.addDims;
    }

    public int additionalDims() {
        return this.addDims;
    }

    public NewArray additionalDims(int addDims) {
        NewArray_c n = (NewArray_c)this.copy();
        n.addDims = addDims;
        return n;
    }

    public ArrayInit init() {
        return this.init;
    }

    public NewArray init(ArrayInit init) {
        NewArray_c n = (NewArray_c)this.copy();
        n.init = init;
        return n;
    }

    protected NewArray_c reconstruct(TypeNode baseType, List dims, ArrayInit init) {
        if (baseType != this.baseType || !CollectionUtil.equals(dims, this.dims) || init != this.init) {
            NewArray_c n = (NewArray_c)this.copy();
            n.baseType = baseType;
            n.dims = TypedList.copyAndCheck(dims, Expr.class, true);
            n.init = init;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode baseType = (TypeNode)this.visitChild(this.baseType, v);
        List dims = this.visitList(this.dims, v);
        ArrayInit init = (ArrayInit)this.visitChild(this.init, v);
        return this.reconstruct(baseType, dims, init);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Iterator i = this.dims.iterator();
        while (i.hasNext()) {
            Expr expr = (Expr)i.next();
            if (ts.isImplicitCastValid(expr.type(), ts.Int())) continue;
            throw new SemanticException("Array dimension must be an integer.", expr.position());
        }
        ArrayType type = this.arrayOf(ts, this.baseType.type(), this.dims.size() + this.addDims);
        if (this.init != null) {
            this.init.typeCheckElements(type);
        }
        return this.type(type);
    }

    protected ArrayType arrayOf(TypeSystem ts, Type baseType, int dims) {
        return ts.arrayOf(baseType, dims);
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.init) {
            return this.type;
        }
        return child.type();
    }

    public String toString() {
        return "new " + this.baseType + "[...]";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("new ");
        this.print(this.baseType, w, tr);
        Iterator i = this.dims.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            w.write("[");
            this.printBlock(e, w, tr);
            w.write("]");
        }
        for (int i2 = 0; i2 < this.addDims; ++i2) {
            w.write("[]");
        }
        if (this.init != null) {
            w.write(" ");
            this.print(this.init, w, tr);
        }
    }

    public Term firstChild() {
        return this.baseType;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.init != null) {
            v.visitCFG(this.baseType, NewArray_c.listChild(this.dims, this.init), 1);
            v.visitCFGList(this.dims, this.init, 1);
            v.visitCFG(this.init, this, 0);
        } else {
            v.visitCFG(this.baseType, NewArray_c.listChild(this.dims, null), 1);
            v.visitCFGList(this.dims, this, 0);
        }
        return succs;
    }

    public List throwTypes(TypeSystem ts) {
        if (this.dims != null && !this.dims.isEmpty()) {
            try {
                return CollectionUtil.list(ts.typeForName("java.lang.NegativeArraySizeException"));
            }
            catch (SemanticException e) {
                throw new InternalCompilerError("Cannot find class java.lang.NegativeArraySizeException", e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public Node copy(NodeFactory nf) {
        return nf.NewArray(this.position, this.baseType, this.dims, this.addDims, this.init);
    }

    static {
        $assertionsDisabled = !NewArray_c.class.desiredAssertionStatus();
    }
}

