/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Id;
import polyglot.ast.Labeled;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NodeList;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class Labeled_c
extends Stmt_c
implements Labeled {
    protected Id label;
    protected Stmt statement;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Labeled_c(Position pos, Id label, Stmt statement) {
        super(pos);
        if (!($assertionsDisabled || label != null && statement != null)) {
            throw new AssertionError();
        }
        this.label = label;
        this.statement = statement;
    }

    public Id labelNode() {
        return this.label;
    }

    public Labeled labelNode(Id label) {
        Labeled_c n = (Labeled_c)this.copy();
        n.label = label;
        return n;
    }

    public String label() {
        return this.label.id();
    }

    public Labeled label(String label) {
        return this.labelNode(this.label.id(label));
    }

    public Stmt statement() {
        return this.statement;
    }

    public Labeled statement(Stmt statement) {
        Labeled_c n = (Labeled_c)this.copy();
        n.statement = statement;
        return n;
    }

    protected Labeled_c reconstruct(Id label, Stmt statement) {
        if (label != this.label || statement != this.statement) {
            Labeled_c n = (Labeled_c)this.copy();
            n.label = label;
            n.statement = statement;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Id label = (Id)this.visitChild(this.label, v);
        Node statement = this.visitChild(this.statement, v);
        if (statement instanceof NodeList) {
            NodeList nl = (NodeList)statement;
            ArrayList<Stmt> stmts = new ArrayList<Stmt>(nl.nodes());
            Stmt first = (Stmt)stmts.get(0);
            first = this.reconstruct(label, first);
            stmts.set(0, first);
            return nl.nodes(stmts);
        }
        return this.reconstruct(label, (Stmt)statement);
    }

    public String toString() {
        return this.label + ": " + this.statement;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.label + ": ");
        this.print(this.statement, w, tr);
    }

    public Term firstChild() {
        return this.statement;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.push(this).visitCFG(this.statement, this, 0);
        return succs;
    }

    public Node copy(NodeFactory nf) {
        return nf.Labeled(this.position, this.label, this.statement);
    }

    static {
        $assertionsDisabled = !Labeled_c.class.desiredAssertionStatus();
    }
}

