/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.AmbReceiver;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Field;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Field_c
extends Expr_c
implements Field {
    protected Receiver target;
    protected Id name;
    protected FieldInstance fi;
    protected boolean targetImplicit;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Field_c(Position pos, Receiver target, Id name) {
        super(pos);
        if (!($assertionsDisabled || target != null && name != null)) {
            throw new AssertionError();
        }
        this.target = target;
        this.name = name;
        this.targetImplicit = false;
        if (target == null) {
            throw new InternalCompilerError("Cannot create a field with a null target.  Use AmbExpr or prefix with the appropriate type node or this.");
        }
    }

    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    public Receiver target() {
        return this.target;
    }

    public Field target(Receiver target) {
        Field_c n = (Field_c)this.copy();
        n.target = target;
        return n;
    }

    public Id id() {
        return this.name;
    }

    public Field id(Id name) {
        Field_c n = (Field_c)this.copy();
        n.name = name;
        return n;
    }

    public String name() {
        return this.name.id();
    }

    public Field name(String name) {
        return this.id(this.name.id(name));
    }

    public Flags flags() {
        return this.fi.flags();
    }

    public VarInstance varInstance() {
        return this.fi;
    }

    public FieldInstance fieldInstance() {
        return this.fi;
    }

    public Field fieldInstance(FieldInstance fi) {
        if (fi == this.fi) {
            return this;
        }
        Field_c n = (Field_c)this.copy();
        n.fi = fi;
        return n;
    }

    public boolean isTargetImplicit() {
        return this.targetImplicit;
    }

    public Field targetImplicit(boolean implicit) {
        Field_c n = (Field_c)this.copy();
        n.targetImplicit = implicit;
        return n;
    }

    protected Field_c reconstruct(Receiver target, Id name) {
        if (target != this.target || name != this.name) {
            Field_c n = (Field_c)this.copy();
            n.target = target;
            n.name = name;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Receiver target = (Receiver)this.visitChild(this.target, v);
        Id name = (Id)this.visitChild(this.name, v);
        return this.reconstruct(target, name);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Field_c n = (Field_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        FieldInstance fi = ts.fieldInstance(this.position(), tb.currentClass(), Flags.NONE, ts.unknownType(this.position()), this.name.id());
        return n.fieldInstance(fi);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        TypeSystem ts = tc.typeSystem();
        if (this.target.type().isReference()) {
            FieldInstance fi = ts.findField(this.target.type().toReference(), this.name.id(), c.currentClass());
            if (fi == null) {
                throw new InternalCompilerError("Cannot access field on node of type " + this.target.getClass().getName() + ".");
            }
            Field_c f = (Field_c)this.fieldInstance(fi).type(fi.type());
            f.checkConsistency(c);
            if (!fi.flags().isStatic() && this.target instanceof TypeNode) {
                throw new SemanticException("Non-static field " + this.name.id() + " cannot be referenced " + "from a static context.", f.position());
            }
            return f;
        }
        throw new SemanticException("Cannot access field \"" + this.name.id() + "\" " + (this.target instanceof Expr ? "on an expression " : "") + "of non-reference type \"" + this.target.type() + "\".", this.target.position());
    }

    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        this.isConstant();
        return this;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.target) {
            return this.fi.container();
        }
        return child.type();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        if (!this.targetImplicit) {
            if (this.target instanceof Expr) {
                this.printSubExpr((Expr)this.target, w, tr);
            } else if (this.target instanceof TypeNode || this.target instanceof AmbReceiver) {
                this.print(this.target, w, tr);
            }
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        tr.print(this, this.name, w);
        w.end();
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.fi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.fi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name \"" + this.name + "\")");
        w.end();
    }

    public Term firstChild() {
        if (this.target instanceof Term) {
            return (Term)((Object)this.target);
        }
        return null;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.target instanceof Term) {
            v.visitCFG((Term)((Object)this.target), this, 0);
        }
        return succs;
    }

    public String toString() {
        return (this.target != null ? this.target + "." : "") + this.name;
    }

    public List throwTypes(TypeSystem ts) {
        if (this.target instanceof Expr && !(this.target instanceof Special)) {
            return Collections.singletonList(ts.NullPointerException());
        }
        return Collections.EMPTY_LIST;
    }

    public boolean constantValueSet() {
        if (this.fi != null && (this.target instanceof TypeNode || this.target instanceof Special && this.targetImplicit)) {
            return this.fi.constantValueSet();
        }
        return this.fi != null;
    }

    public boolean isConstant() {
        if (this.fi != null && (this.target instanceof TypeNode || this.target instanceof Special && this.targetImplicit)) {
            return this.fi.isConstant();
        }
        return false;
    }

    public Object constantValue() {
        if (this.isConstant()) {
            return this.fi.constantValue();
        }
        return null;
    }

    protected void checkConsistency(Context c) {
        if (this.targetImplicit) {
            VarInstance vi = c.findVariableSilent(this.name.id());
            if (vi instanceof FieldInstance) {
                FieldInstance rfi = (FieldInstance)vi;
                if (c.typeSystem().equals(rfi.orig(), this.fi.orig())) {
                    return;
                }
                System.out.println("(found) rfi is " + rfi.orig());
                System.out.println("(actual) fi is " + this.fi.orig());
            }
            throw new InternalCompilerError("Field " + this + " has an " + "implicit target, but the name " + this.name.id() + " resolves to " + vi + " instead of " + this.target, this.position());
        }
    }

    public Node copy(NodeFactory nf) {
        return nf.Field(this.position, this.target, this.name);
    }

    static {
        $assertionsDisabled = !Field_c.class.desiredAssertionStatus();
    }
}

