/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Iterator;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.InitializerInstance;
import polyglot.types.MemberInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.PruningVisitor;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class FieldDecl_c
extends Term_c
implements FieldDecl {
    protected Flags flags;
    protected TypeNode type;
    protected Id name;
    protected Expr init;
    protected FieldInstance fi;
    protected InitializerInstance ii;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FieldDecl_c(Position pos, Flags flags, TypeNode type, Id name, Expr init) {
        super(pos);
        if (!($assertionsDisabled || flags != null && type != null && name != null)) {
            throw new AssertionError();
        }
        this.flags = flags;
        this.type = type;
        this.name = name;
        this.init = init;
    }

    public boolean isDisambiguated() {
        return this.fi != null && this.fi.isCanonical() && (this.init == null || this.ii != null && this.ii.isCanonical()) && super.isDisambiguated();
    }

    public MemberInstance memberInstance() {
        return this.fi;
    }

    public VarInstance varInstance() {
        return this.fi;
    }

    public CodeInstance codeInstance() {
        return this.ii;
    }

    public InitializerInstance initializerInstance() {
        return this.ii;
    }

    public FieldDecl initializerInstance(InitializerInstance ii) {
        if (ii == this.ii) {
            return this;
        }
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.ii = ii;
        return n;
    }

    public Type declType() {
        return this.type.type();
    }

    public Flags flags() {
        return this.flags;
    }

    public FieldDecl flags(Flags flags) {
        if (flags.equals(this.flags)) {
            return this;
        }
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.flags = flags;
        return n;
    }

    public TypeNode type() {
        return this.type;
    }

    public FieldDecl type(TypeNode type) {
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.type = type;
        return n;
    }

    public Id id() {
        return this.name;
    }

    public FieldDecl id(Id name) {
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.name = name;
        return n;
    }

    public String name() {
        return this.name.id();
    }

    public FieldDecl name(String name) {
        return this.id(this.name.id(name));
    }

    public Term codeBody() {
        return this.init;
    }

    public Expr init() {
        return this.init;
    }

    public FieldDecl init(Expr init) {
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.init = init;
        return n;
    }

    public FieldDecl fieldInstance(FieldInstance fi) {
        if (fi == this.fi) {
            return this;
        }
        FieldDecl_c n = (FieldDecl_c)this.copy();
        n.fi = fi;
        return n;
    }

    public FieldInstance fieldInstance() {
        return this.fi;
    }

    protected FieldDecl_c reconstruct(TypeNode type, Id name, Expr init) {
        if (this.type != type || this.name != name || this.init != init) {
            FieldDecl_c n = (FieldDecl_c)this.copy();
            n.type = type;
            n.name = name;
            n.init = init;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode type = (TypeNode)this.visitChild(this.type, v);
        Id name = (Id)this.visitChild(this.name, v);
        Expr init = (Expr)this.visitChild(this.init, v);
        return this.reconstruct(type, name, init);
    }

    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb.pushCode();
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        FieldDecl n;
        TypeSystem ts = tb.typeSystem();
        ParsedClassType ct = tb.currentClass();
        if (ct == null) {
            return this;
        }
        Flags f = this.flags;
        if (ct.flags().isInterface()) {
            f = f.Public().Static().Final();
        }
        if (this.init != null) {
            Flags iflags = f.isStatic() ? Flags.STATIC : Flags.NONE;
            InitializerInstance ii = ts.initializerInstance(this.init.position(), ct, iflags);
            n = this.initializerInstance(ii);
        } else {
            n = this;
        }
        FieldInstance fi = ts.fieldInstance(this.position(), ct, f, ts.unknownType(this.position()), this.name.id());
        ct.addField(fi);
        return n.flags(f).fieldInstance(fi);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.fi.isCanonical()) {
            return this;
        }
        if (this.declType().isCanonical()) {
            this.fi.setType(this.declType());
        }
        return this;
    }

    public Context enterScope(Context c) {
        if (this.ii != null) {
            return c.pushCode(this.ii);
        }
        return c;
    }

    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        if (this.init == null || !this.init.isConstant() || !this.fi.flags().isFinal()) {
            this.fi.setNotConstant();
        } else {
            this.fi.setConstantValue(this.init.constantValue());
        }
        return this;
    }

    public boolean constantValueSet() {
        return this.fi != null && this.fi.constantValueSet();
    }

    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        FieldDecl nn = this;
        FieldDecl_c old = this;
        NodeVisitor childv = tc.enter(parent, this);
        if (childv instanceof PruningVisitor) {
            return nn;
        }
        boolean constantValueSet = false;
        FieldInstance fi = nn.fieldInstance();
        if (fi.constantValueSet()) {
            constantValueSet = true;
        } else {
            fi.setNotConstant();
        }
        TypeChecker childtc = (TypeChecker)childv;
        nn = (FieldDecl)nn.visitChildren(childtc);
        nn = (FieldDecl)tc.leave(parent, old, nn, childtc);
        if (!constantValueSet) {
            ConstantChecker cc = new ConstantChecker(tc.job(), tc.typeSystem(), tc.nodeFactory());
            cc = (ConstantChecker)cc.context(childtc.context());
            nn = (FieldDecl)nn.del().checkConstants(cc);
        }
        return nn;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Flags flags = this.fi.flags();
        try {
            ts.checkFieldFlags(flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (tc.context().currentClass().flags().isInterface() && (flags.isProtected() || flags.isPrivate())) {
            throw new SemanticException("Interface members must be public.", this.position());
        }
        if (this.init != null) {
            if (this.init instanceof ArrayInit) {
                ((ArrayInit)this.init).typeCheckElements(this.type.type());
            } else if (!(ts.isImplicitCastValid(this.init.type(), this.type.type()) || ts.typeEquals(this.init.type(), this.type.type()) || ts.numericConversionValid(this.type.type(), this.init.constantValue()))) {
                throw new SemanticException("The type of the variable initializer \"" + this.init.type() + "\" does not match that of " + "the declaration \"" + this.type.type() + "\".", this.init.position());
            }
        }
        if (this.flags().isStatic() && this.fieldInstance().container().toClass().isInnerClass() && (!this.flags().isFinal() || this.init == null || !this.init.isConstant())) {
            throw new SemanticException("Inner classes cannot declare static fields, unless they are compile-time constant fields.", this.position());
        }
        return this;
    }

    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push(new ExceptionChecker.CodeTypeReporter("field initializer"));
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.init) {
            TypeSystem ts = av.typeSystem();
            if (ts.numericConversionValid(this.type.type(), child.constantValue())) {
                return child.type();
            }
            return this.type.type();
        }
        return child.type();
    }

    public Term firstChild() {
        return this.type;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.init != null) {
            v.visitCFG(this.type, this.init, 1);
            v.visitCFG(this.init, this, 0);
        } else {
            v.visitCFG(this.type, this, 0);
        }
        return succs;
    }

    public String toString() {
        return this.flags.translate() + this.type + " " + this.name + (this.init != null ? " = " + this.init : "");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        boolean isInterface = this.fi != null && this.fi.container() != null && this.fi.container().toClass().flags().isInterface();
        Flags f = this.flags;
        if (isInterface) {
            f = f.clearPublic();
            f = f.clearStatic();
            f = f.clearFinal();
        }
        w.write(f.translate());
        this.print(this.type, w, tr);
        w.allowBreak(2, 2, " ", 1);
        tr.print(this, this.name, w);
        if (this.init != null) {
            w.write(" =");
            w.allowBreak(2, " ");
            this.print(this.init, w, tr);
        }
        w.write(";");
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.fi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.fi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
    }

    public Node copy(NodeFactory nf) {
        return nf.FieldDecl(this.position, this.flags, this.type, this.name, this.init);
    }

    static {
        $assertionsDisabled = !FieldDecl_c.class.desiredAssertionStatus();
    }

    public static class AddDependenciesVisitor
    extends NodeVisitor {
        protected Scheduler scheduler;
        protected FieldInstance fi;

        AddDependenciesVisitor(Scheduler scheduler, FieldInstance fi) {
            this.scheduler = scheduler;
            this.fi = fi;
        }

        public Node leave(Node old, Node n, NodeVisitor v) {
            Field f;
            if (n instanceof Field && !(f = (Field)n).fieldInstance().orig().constantValueSet()) {
                Goal newGoal = this.scheduler.FieldConstantsChecked(f.fieldInstance().orig());
                Goal myGoal = this.scheduler.FieldConstantsChecked(this.fi);
                Iterator i = newGoal.prerequisiteGoals(this.scheduler).iterator();
                while (i.hasNext()) {
                    Goal g = (Goal)i.next();
                    if (!this.scheduler.prerequisiteDependsOn(g, myGoal)) continue;
                    this.fi.setNotConstant();
                    return n;
                }
                throw new MissingDependencyException(newGoal, true);
            }
            return n;
        }
    }
}

