/*
 * Decompiled with CFR 0.152.
 */
import ensemble.Callbacks;
import ensemble.Group;
import ensemble.JoinOps;
import ensemble.View;
import java.util.Arrays;
import java.util.Random;

public class RandTest {
    static int nmembers = 2;
    static int thresh = 2;
    static final String groupName = "GroupA";
    static Random rand = new Random();
    Group g;
    int my_rank;
    int my_nmembers;
    Thread test_thread = null;

    static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static JoinOps create_JoinOps() {
        JoinOps joinOps = new JoinOps();
        joinOps.group_name = groupName;
        joinOps.hrtbt_rate = 10.0;
        return joinOps;
    }

    static RandTest create_endpt() {
        Group group;
        System.out.println("create_endpt");
        System.out.flush();
        JoinOps joinOps = RandTest.create_JoinOps();
        final RandTest randTest = new RandTest();
        randTest.g = group = new Group(new Callbacks(){

            public void install(View view) {
                randTest.my_rank = view.rank;
                randTest.my_nmembers = view.nmembers;
                System.out.println("RandTest: Install:{");
                System.out.println("  version= " + view.version);
                System.out.println("  proto= " + view.proto);
                System.out.println("  group= " + view.group);
                System.out.println("  coord= " + view.coord);
                System.out.println("  ltime= " + view.ltime);
                System.out.println("  primary= " + view.primary);
                System.out.println("  groupd= " + view.groupd);
                System.out.println("  xfer_view= " + view.xfer_view);
                System.out.println("  params= " + view.params);
                System.out.println("  uptime= " + view.uptime);
                System.out.println("  view= " + Arrays.asList(view.view));
                System.out.println("  address= " + Arrays.asList(view.address));
                System.out.println("  endpt= " + view.endpt);
                System.out.println("  addr= " + view.addr);
                System.out.println("  name= " + view.name);
                System.out.println("  nmembers= " + view.nmembers);
                System.out.println("  am_coord= " + view.am_coord);
                System.out.println("}");
            }

            public void exit() {
                System.out.println("RT exit");
                System.out.flush();
                new Thread(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void run() {
                        try {
                            Thread.sleep(1000L);
                            RandTest.create_endpt();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }.start();
            }

            public void recv_cast(int n, byte[] byArray) {
                System.out.println("RT recv_cast: " + new String(byArray) + " from " + n);
            }

            public void recv_send(int n, byte[] byArray) {
                System.out.println("RT recv_send: " + new String(byArray) + " from " + n);
            }

            public void flow_block(int n, boolean bl) {
            }

            public void block() {
                System.out.println("RT blocked");
            }

            public void heartbeat(double d) {
                System.out.println("RandTest: heartbeat " + d);
                System.out.flush();
            }
        });
        group.join(joinOps);
        System.out.println("******* JOIN " + randTest.g.nat_env + "**********************");
        RandTest.sleep(500);
        randTest.test_thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(500L);
                        System.out.flush();
                        Group group = randTest.g;
                        synchronized (group) {
                            int n = randTest.g.getStatus();
                            if (n == 5) {
                                return;
                            }
                            if (n == 2 && randTest.my_nmembers >= thresh) {
                                randTest.exec();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        };
        randTest.test_thread.start();
        return randTest;
    }

    static byte[] gen_msg() {
        String string = "Hello World";
        return string.getBytes();
    }

    static int gen_dest(int n, int n2) {
        int n3 = n;
        if (n2 == 1) {
            System.out.println("gen_dest in a group of size 1");
            System.exit(1);
        }
        while (n3 == n) {
            n3 = Math.abs(rand.nextInt()) % n2;
        }
        return n3;
    }

    static int[] gen_dests(int n, int n2) {
        int[] nArray = new int[]{RandTest.gen_dest(n, n2), RandTest.gen_dest(n, n2)};
        return nArray;
    }

    void exec() {
        int n = Math.abs(rand.nextInt()) % 100;
        String string = null;
        System.out.print(this.g.nat_env + " action = < ");
        System.out.flush();
        if (n < 6) {
            string = "Leave";
            System.out.println("******* LEAVE " + this.g.nat_env + "**********************");
            this.g.leave();
        } else if (n < 9) {
            string = "Prompt";
            System.out.println("Prompt");
            System.out.flush();
            this.g.prompt();
        } else if (n < 15) {
            string = "Suspect";
            this.g.suspect(RandTest.gen_dests(this.my_rank, this.my_nmembers));
        } else if (n < 25) {
            string = "Properties";
            String string2 = "Gmp:Sync:Heal:Frag:Suspect:Flow:Slander";
            String string3 = null;
            int n2 = Math.abs(rand.nextInt()) % 5;
            switch (n2) {
                case 0: {
                    string3 = string2;
                    break;
                }
                case 1: {
                    string3 = string2 + ":causal";
                    break;
                }
                case 2: {
                    string3 = string2 + ":total";
                    break;
                }
                case 3: {
                    string3 = string2 + ":scale";
                    break;
                }
                case 4: {
                    string3 = string2 + ":local";
                    break;
                }
                default: {
                    System.out.println("bad random value, abort, i=" + n2);
                    System.exit(1);
                }
            }
            this.g.changeProperties(string3);
        } else if (n < 40) {
            string = "Cast";
            this.g.cast(RandTest.gen_msg());
        } else if (n < 70) {
            string = "Send1";
            this.g.send1(RandTest.gen_dest(this.my_rank, this.my_nmembers), RandTest.gen_msg());
        } else {
            string = "Send";
            this.g.send(RandTest.gen_dests(this.my_rank, this.my_nmembers), RandTest.gen_msg());
        }
        System.out.println(string + ">");
        System.out.flush();
    }

    static String[] parse_cmd_line(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-t")) {
                thresh = Integer.parseInt(stringArray[n2 + 1]);
                System.out.println("thresh = " + thresh);
                stringArray[n2] = null;
                stringArray[n2 + 1] = null;
                ++n2;
            } else if (stringArray[n2].equals("-n")) {
                nmembers = Integer.valueOf(stringArray[n2 + 1]);
                System.out.println("nmembers = " + nmembers);
                stringArray[n2] = null;
                stringArray[n2 + 1] = null;
                ++n2;
            } else {
                ++n;
            }
            ++n2;
        }
        String[] stringArray2 = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null) {
                stringArray2[n4] = stringArray[n3];
                ++n4;
            }
            ++n3;
        }
        return stringArray2;
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = RandTest.parse_cmd_line(stringArray);
        Group.init((String[])stringArray2);
        int n = 0;
        while (n < nmembers) {
            RandTest.create_endpt();
            ++n;
        }
    }
}

