/*
 * Decompiled with CFR 0.152.
 */
import ensemble.Callbacks;
import ensemble.Group;
import ensemble.JoinOps;
import ensemble.View;
import java.util.Arrays;

public class PerfTest {
    static String prog = "rpc";
    static int nmembers = 2;
    static double rate = 0.01;
    static int size = 4;
    static double terminate_time = 10.0;
    static boolean quiet = false;
    View v;
    boolean blocked = false;
    boolean start = false;
    boolean first_time = false;
    boolean flow_block = false;
    byte[] msg = null;
    double start_time = 0.0;
    int total = 0;
    double next = 0.0;
    final Group rpc = new Group(new Callbacks(){

        public void install(View view) {
            PerfTest.this.v = view;
            System.out.println("  view= " + Arrays.asList(view.view));
            PerfTest.this.blocked = false;
            if (view.nmembers == 2) {
                PerfTest.this.start = true;
                PerfTest.this.msg = new byte[size];
            }
        }

        public void exit() {
            System.out.println("RT exit");
            System.out.flush();
            System.exit(0);
        }

        public void recv_cast(int n, byte[] byArray) {
        }

        public void recv_send(int n, byte[] byArray) {
            ++PerfTest.this.total;
            if (PerfTest.this.total % 1000 == 0) {
                System.out.println("RT recv_send: " + PerfTest.this.total);
            }
            if (PerfTest.this.start && !PerfTest.this.blocked && PerfTest.this.v.nmembers == 2 && !PerfTest.this.flow_block) {
                if (PerfTest.this.v.rank == 0) {
                    PerfTest.this.rpc.send1(1, byArray);
                }
                if (PerfTest.this.v.rank == 1) {
                    PerfTest.this.rpc.send1(0, byArray);
                }
            }
        }

        public void flow_block(int n, boolean bl) {
            PerfTest.this.flow_block = bl;
        }

        public void block() {
            PerfTest.this.blocked = true;
        }

        public void heartbeat(double d) {
            if (PerfTest.this.start && !PerfTest.this.first_time) {
                PerfTest.this.first_time = true;
                PerfTest.this.start_time = d;
            }
            if (PerfTest.this.start && !PerfTest.this.blocked && PerfTest.this.v.nmembers == 2 && !PerfTest.this.flow_block) {
                if (PerfTest.this.v.rank == 0) {
                    PerfTest.this.rpc.send1(1, PerfTest.this.msg);
                }
                if (PerfTest.this.v.rank == 1) {
                    PerfTest.this.rpc.send1(0, PerfTest.this.msg);
                }
            }
            if (PerfTest.this.start && d - PerfTest.this.start_time > terminate_time) {
                PerfTest.this.start = false;
                System.out.println("finished RPC test");
                System.out.println("total=" + PerfTest.this.total);
                System.out.println("time=" + terminate_time);
                System.out.println("round-trip latency=" + (d - PerfTest.this.start_time) / (double)PerfTest.this.total + "(sec)");
                PerfTest.this.rpc.leave();
            }
        }
    });
    final Group throu = new Group(new Callbacks(){

        public void install(View view) {
            PerfTest.this.v = view;
            System.out.println("  view= " + Arrays.asList(view.view));
            PerfTest.this.blocked = false;
            if (view.nmembers == 2) {
                PerfTest.this.start = true;
                PerfTest.this.msg = new byte[size];
            }
        }

        public void exit() {
            System.out.println("RT exit");
            System.out.flush();
            System.exit(0);
        }

        public void recv_cast(int n, byte[] byArray) {
        }

        public void recv_send(int n, byte[] byArray) {
            ++PerfTest.this.total;
            if (PerfTest.this.total % 1000 == 0) {
                System.out.println("RT recv_send: " + PerfTest.this.total);
            }
            if (PerfTest.this.start && !PerfTest.this.blocked && PerfTest.this.v.nmembers == 2 && !PerfTest.this.flow_block) {
                if (PerfTest.this.v.rank == 0) {
                    PerfTest.this.throu.send1(1, byArray);
                }
                if (PerfTest.this.v.rank == 1) {
                    PerfTest.this.throu.send1(0, byArray);
                }
            }
        }

        public void flow_block(int n, boolean bl) {
            PerfTest.this.flow_block = bl;
        }

        public void block() {
            PerfTest.this.blocked = true;
        }

        public void heartbeat(double d) {
            if (PerfTest.this.start && !PerfTest.this.first_time) {
                PerfTest.this.first_time = true;
                PerfTest.this.start_time = d;
                PerfTest.this.next = d;
            }
            if (PerfTest.this.start && !PerfTest.this.blocked && PerfTest.this.v.nmembers == 2 && !PerfTest.this.flow_block) {
                while (d > PerfTest.this.next) {
                    PerfTest.this.throu.cast(PerfTest.this.msg);
                    PerfTest.this.next += rate;
                    PerfTest.this.total += size;
                }
            }
            if (PerfTest.this.start && d - PerfTest.this.start_time > terminate_time) {
                PerfTest.this.start = false;
                System.out.println("finished THROU test");
                System.out.println("total=" + PerfTest.this.total);
                System.out.println("time=" + terminate_time);
                System.out.println("throughput= " + (double)PerfTest.this.total / (1024.0 * (d - PerfTest.this.start_time)) + "(K/sec)");
                PerfTest.this.throu.leave();
            }
        }
    });

    static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static String[] parse_cmd_line(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            boolean bl = false;
            if (stringArray[n2].equals("-prog")) {
                prog = stringArray[n2 + 1];
                System.out.println("prog = " + prog);
                bl = true;
            } else if (stringArray[n2].equals("-n")) {
                nmembers = Integer.parseInt(stringArray[n2 + 1]);
                System.out.println("nmembers" + nmembers);
                bl = true;
            } else if (stringArray[n2].equals("-r")) {
                rate = Float.parseFloat(stringArray[n2 + 1]);
                System.out.println("rate=" + rate);
                bl = true;
            } else if (stringArray[n2].equals("-s")) {
                size = Integer.parseInt(stringArray[n2 + 1]);
                System.out.println("size=" + size);
                bl = true;
            } else if (stringArray[n2].equals("-terminate_time")) {
                terminate_time = Integer.parseInt(stringArray[n2 + 1]);
                System.out.println("terminate_time=" + terminate_time);
                bl = true;
            } else if (stringArray[n2].equals("-quiet")) {
                quiet = true;
                System.out.println("quiet mode");
                bl = true;
            } else {
                ++n;
            }
            if (bl) {
                stringArray[n2] = null;
                stringArray[n2 + 1] = null;
                ++n2;
            }
            ++n2;
        }
        String[] stringArray2 = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null) {
                stringArray2[n4] = stringArray[n3];
                ++n4;
            }
            ++n3;
        }
        return stringArray2;
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = PerfTest.parse_cmd_line(stringArray);
        Group.init((String[])stringArray2);
        System.out.println("Args= ");
        System.out.println("\t prog= " + prog);
        System.out.println("\t nmembers= " + nmembers);
        System.out.println("\t rate= " + rate);
        System.out.println("\t size= " + size);
        System.out.println("\t terminate_time= " + terminate_time);
        System.out.println("\t quiet= " + quiet);
        JoinOps joinOps = new JoinOps();
        PerfTest perfTest = new PerfTest();
        joinOps.group_name = "java.PerfTest";
        if (prog.equals("rpc")) {
            joinOps.hrtbt_rate = 1.0;
            perfTest.rpc.join(joinOps);
        } else {
            joinOps.hrtbt_rate = rate;
            perfTest.throu.join(joinOps);
        }
        Thread.sleep(100000000L);
    }
}

