/*
 * Decompiled with CFR 0.152.
 */
package ensemble;

import ensemble.Callbacks;
import ensemble.JoinOps;
import ensemble.View;

public class Group {
    public static final int PRE = 0;
    public static final int JOINING = 1;
    public static final int NORMAL = 2;
    public static final int BLOCKED = 3;
    public static final int LEAVING = 4;
    public static final int LEFT = 5;
    public long nat_env = 0L;
    private Callbacks cb = null;
    private int status = 0;

    static native void natInit(String[] var0);

    native long natJoin(JoinOps var1);

    native void natLeave(long var1);

    native void natCast(long var1, byte[] var3);

    native void natSend(long var1, int[] var3, byte[] var4);

    native void natSend1(long var1, int var3, byte[] var4);

    native void natPrompt(long var1);

    native void natSuspect(long var1, int[] var3);

    native void natXferDone(long var1);

    native void natRekey(long var1);

    native void natChangeProtocol(long var1, String var3);

    native void natChangeProperties(long var1, String var3);

    private void abort(String string) {
        try {
            throw new Exception(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void check_normal() {
        if (this.status != 2) {
            this.abort("Trying to perform a group action while not in NORMAL state");
        }
    }

    public final String string_of_status(int n) {
        switch (n) {
            case 0: {
                return "PRE";
            }
            case 1: {
                return "JOINING";
            }
            case 2: {
                return "NORMAL";
            }
            case 3: {
                return "BLOCKED";
            }
            case 4: {
                return "LEAVING";
            }
            case 5: {
                return "LEFT";
            }
        }
        System.out.println("Bad value to status");
        System.exit(1);
        return "";
    }

    public int getStatus() {
        return this.status;
    }

    public Group(Callbacks callbacks) {
        if (callbacks == null) {
            System.out.println("Group constructor, callbacks are null");
            System.exit(0);
        }
        this.cb = callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(JoinOps joinOps) {
        Group group = this;
        synchronized (group) {
            if (this.status == 0) {
                this.status = 1;
            } else {
                this.abort("Join: trying to join twice");
            }
            this.nat_env = this.natJoin(joinOps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave() {
        Group group = this;
        synchronized (group) {
            this.check_normal();
            this.status = 4;
            this.natLeave(this.nat_env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cast(byte[] byArray) {
        Group group = this;
        synchronized (group) {
            this.check_normal();
            this.natCast(this.nat_env, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(int[] nArray, byte[] byArray) {
        Group group = this;
        synchronized (group) {
            this.check_normal();
            this.natSend(this.nat_env, nArray, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send1(int n, byte[] byArray) {
        Group group = this;
        synchronized (group) {
            this.check_normal();
            this.natSend1(this.nat_env, n, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prompt() {
        Group group = this;
        synchronized (group) {
            this.check_normal();
            this.natPrompt(this.nat_env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspect(int[] nArray) {
        Group group = this;
        synchronized (group) {
            this.check_normal();
            this.natSuspect(this.nat_env, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xferDone() {
        Group group = this;
        synchronized (group) {
            this.check_normal();
            this.natXferDone(this.nat_env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rekey() {
        Group group = this;
        synchronized (group) {
            this.check_normal();
            this.natRekey(this.nat_env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeProtocol(String string) {
        Group group = this;
        synchronized (group) {
            this.check_normal();
            this.natChangeProtocol(this.nat_env, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeProperties(String string) {
        Group group = this;
        synchronized (group) {
            this.check_normal();
            this.natChangeProperties(this.nat_env, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(String string, String string2, String string3, int n, int n2, boolean bl, boolean bl2, boolean bl3, String string4, double d, String[] stringArray, String[] stringArray2, String string5, String string6, int n3, String string7, int n4, boolean bl4) {
        View view = new View(string, string2, string3, n, n2, bl, bl2, bl3, string4, d, stringArray, stringArray2, string5, string6, n3, string7, n4, bl4);
        Group group = this;
        synchronized (group) {
            this.status = 2;
            this.cb.install(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit() {
        Group group = this;
        synchronized (group) {
            this.status = 5;
            this.cb.exit();
        }
    }

    private void recv_cast(int n, byte[] byArray) {
        this.cb.recv_cast(n, byArray);
    }

    private void recv_send(int n, byte[] byArray) {
        this.cb.recv_send(n, byArray);
    }

    private void flow_block(int n, boolean bl) {
        this.cb.flow_block(n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block() {
        Group group = this;
        synchronized (group) {
            this.status = 3;
            this.cb.block();
        }
    }

    private void heartbeat(double d) {
        this.cb.heartbeat(d);
    }

    public static void init(String[] stringArray) {
        try {
            System.loadLibrary("cejava");
        }
        catch (Exception exception) {
            System.out.println("Could not load the cejava C library, exiting.");
            exception.printStackTrace();
            System.exit(1);
        }
        Group.natInit(stringArray);
    }
}

