(**************************************************************)
(*
 *  Ensemble, 1.10
 *  Copyright 2001 Cornell University, Hebrew University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(* This module collects the information generated by the life master, *)
(* and supplies it to others via a set of callbacks and functions *)

(* Version 0, by Sam Weber *)

open Rules
open Msgs

(* Setup functions *)

  (* called before computation begins with the number of generations that *)
  (* will be computed *)

  val start: int->unit

(* The functions used to connect to the lifemaster *)

  (* called by the master when a cell value is determined *)
  (* the arguments are the cell's generation, coordinates and value *)

  val masterCellValue: int->cellCoordinate->cell->unit

  (* called by the master when the master's view changes *)
  (* the argument is the number of endpoints in the new view *)

  val masterViewChange: int->unit

  (* called by the master when the computation terminates *)

  val masterExit: unit->unit

(* Callbacks to notify clients of events *)

  (* called whenever a cell value is determined *)
  (* the arguments are the cell's generation, coordinates and value *)

  val setCellValueCallback: (int->cellCoordinate->cell->unit)->unit

  (* called whenever the master's view changes *)
  (* the argumements are the number of endpoints in the master's view *)

  val setMasterViewChangeFunc: (int->unit)->unit

  (* called when the master completes *)

  val setMasterEndFunc: (unit->unit)->unit

(* Informational functions *)

  (* returns the number of cells that have been computed for the given *)
  (* generation *)

  val numberCellsComputed: int->int

  (* returns the list of (cell-coordinate, value) pairs that have been *)
  (* computed for the given generation *)

  val cellsComputed: int-> (cellCoordinate*cell) list
