(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* UTIL.MLI *)
(* Author: Mark Hayden, 4/95 *)
(**************************************************************)
open Trans
(**************************************************************)

external (=|) : int -> int -> bool = "%eq"
external (<>|) : int -> int -> bool = "%noteq"
external (>=|) : int -> int -> bool = "%geint"
external (<=|) : int -> int -> bool = "%leint"
external (>|) : int -> int -> bool = "%gtint"
external (<|) : int -> int -> bool = "%ltint"

(**************************************************************)
(* Really basic things.
 *)

val zero 		: float
val counter 		: unit -> unit -> int
val ident 		: 'a -> 'a

(**************************************************************)
(* Debugging stuff.
 *)

val verbose		: bool ref
val make_failwith	: string -> string -> unit
val make_assert		: (string -> unit) -> bool -> string -> unit
val failmsg             : string -> string -> string
val addinfo             : string -> string -> string

(**************************************************************)
(* Export printf and sprintf.
 *)

val printf		: ('a, unit, unit) format -> 'a
val eprintf		: ('a, unit, unit) format -> 'a
val sprintf		: ('a, unit, string) format -> 'a

(**************************************************************)
(* Optimization registration and printout.
 *)

val register_opt	: string -> string -> unit
val print_opts		: unit -> unit

(**************************************************************)
(* Some list/queue/array operations.
 *)

val queue_clean 	: ('a -> 'b) -> 'a Queue.t -> unit
val sequence		: int -> int list
val index               : 'a -> 'a list -> int
val except              : 'a -> 'a list -> 'a list
val list_of_queue	: 'a Queue.t -> 'a list
val list_filter		: ('a -> bool) -> 'a list -> 'a list
val array_filter	: ('a -> bool) -> 'a array -> 'a array
val array_index 	: 'a -> 'a array -> int
val array_create	: debug -> int -> 'a -> 'a array
val array_createf	: int -> (int -> 'a) -> 'a array
val array_mem 	        : 'a -> 'a array -> bool
val array_filter_nones  : 'a option array -> 'a array
val array_exists	: (int -> 'a -> bool) -> 'a array -> bool
val array_incr 		: int array -> int -> unit
val array_add           : int array -> int -> int -> unit
val array_sub           : int array -> int -> int -> unit
val array_combine       : 'a array -> 'b array -> ('a * 'b) array
val array_split         : ('a * 'b) array -> ('a array * 'b array)
val array_for_all 	: ('a -> bool) -> 'a array -> bool
val array_for_all2 	: ('a -> 'b -> bool) -> 'a array -> 'b array -> bool
val array_fold_left     : ('a -> 'b -> 'a) -> 'a -> 'b array -> 'a
val for_array		: (int -> 'a -> unit) -> 'a array -> unit
val matrix_incr 	: int array array -> int -> int -> unit
val just_once		: (unit -> 'a) -> (unit -> 'a)
val hashtbl_size	: ('a,'b) Hashtbl.t -> int
val list_of_hashtbl     : ('a,'b) Hashtbl.t -> ('a * 'b) list
val hashtbl_clean       : ('a,'b) Hashtbl.t -> unit

(**************************************************************)
(* Some string conversion functions.
 *)

val string_map          : (char -> char) -> string -> string
val string_of_pair      : 
  ('a -> string) -> ('b -> string) -> ('a * 'b -> string)
val string_of_list 	: ('a -> string) -> 'a list -> string
val string_of_array 	: ('a -> string) -> 'a array -> string
val string_of_int_list 	: int list -> string
val string_of_int_array : int array -> string
val bool_of_string      : string -> bool
val string_of_bool	: bool -> string
val string_of_bool_list : bool list -> string
val string_of_bool_array : bool array -> string
val string_split	: string -> string -> string list
val hex_of_string	: string -> string

(**************************************************************)
(* Some additional option operations.
 *)

val if_some 		: 'a option -> ('a -> unit) -> unit
val some_of 		: 'a option -> 'a
val is_none 		: 'a option -> bool
val string_of_option 	: ('a -> string) -> 'a option -> string
val option_map		: ('a -> 'b) -> 'a option -> 'b option
val filter_nones        : 'a option list -> 'a list
val once                : 'a option list -> 'a

(**************************************************************)

val string_of_exn : exn -> string

(**************************************************************)

val make_magic : unit   -> (('a -> Obj.t ) * (Obj.t  -> 'a))

(* Make matched marshallers to/from strings.
 *)
(* BUG: this should be * (string -> 'a) *)
val make_marsh : string -> bool ->
  (('a -> string) * (string -> int -> int -> 'a))

(* Make matched marshallers to/from strings, with offsets.
 *)
val make_marsh_buf : string -> bool ->
  (('a -> string -> int -> int -> int) * 
   (string -> int -> int -> 'a))

(**************************************************************)

val average   : int -> unit

(**************************************************************)

(* Number of bytes in a word (4).  At some later point, will
 * deal with 64-bit architectures.
 *)
val word_len : int

(* Check that value is word-aligned.
 *)
val is_aligned : int -> bool

(* Round up/down to next multiple of 4.
 *)
val floor_word : int -> int
val ceil_word : int -> int

(**************************************************************)

val disable_sigpipe : unit -> unit

(**************************************************************)

val gc_profile : string -> ('a -> 'b) -> 'a -> 'b
val gc_profile3 : string -> ('a -> 'b -> 'c -> 'd) -> 'a -> 'b -> 'c -> 'd

(**************************************************************)
(* TransisE additions
 *)

val some_less    : int option -> int option -> bool
val some_inc     : int option -> int 
val some_min     : int option -> int option -> int option  
val some_max     : int option -> int option -> int option  
val some_comp    : int option -> int option -> bool
val int_of_some  : int option -> int
val print_some   : int option -> unit
val max_vct      : int option array -> int option array -> unit

(**************************************************************)

val choose : 'a array -> int -> 'a list
val gossip : bool array -> int -> int array
val random_list : 'a list -> 'a list

(**************************************************************)

val strtok : string -> string -> string * string

(**************************************************************)

val make_map : string -> string -> 
  (string * 'a) list -> 
  ((string -> 'a) * ('a -> string))

(**************************************************************)

(* Read input from stdin.
 *)
val read_lines : unit -> string list

(**************************************************************)

val string_list_of_gc_stat : Gc.stat -> string list

(**************************************************************)
